/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.SqlUtils;
import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.AbstractDialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.DateUtils;
import cn.featherfly.common.lang.LangUtils;
import java.util.Date;

public class PostgreSQLDialect
extends AbstractDialect {
    public PostgreSQLDialect() {
        this.setTableAndColumnNameUppercase(false);
    }

    @Override
    public String getPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, false);
    }

    @Override
    public String getParamNamedPaginationSql(String sql, int start, int limit) {
        return this.getPaginationSql(sql, start, true);
    }

    @Override
    public Object[] getPaginationSqlParameter(Object[] params, int start, int limit) {
        Object[] pagingParams = null;
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            pagingParams = new Object[]{limit, start};
        } else {
            this.logger.debug("start < 0 , don't use start");
            pagingParams = new Object[]{limit};
        }
        return (Object[])ArrayUtils.concat((Object)params, (Object)pagingParams);
    }

    private String getPaginationSql(String sql, int start, boolean isParamNamed) {
        sql = sql.trim();
        boolean isForUpdate = false;
        if (this.isForUpdate(sql)) {
            sql = sql.substring(0, sql.length() - " for update".length());
            isForUpdate = true;
        }
        int sqlLengthOffset = 50;
        StringBuilder pagingSelect = new StringBuilder(sql.length() + 50);
        pagingSelect.append(sql);
        if (isParamNamed) {
            if (start > 0) {
                pagingSelect.append(String.format(" LIMIT :%s OFFSET :%s", "dialect_paging_limit", "dialect_paging_start"));
            } else {
                pagingSelect.append(String.format(" LIMIT :%s", "dialect_paging_limit"));
            }
        } else if (start > 0) {
            pagingSelect.append(" LIMIT ? OFFSET ?");
        } else {
            pagingSelect.append(" LIMIT ?");
        }
        if (isForUpdate) {
            pagingSelect.append(" for update");
        }
        this.logger.debug("\u539f\u59cbSql\uff1a{}", (Object)sql);
        this.logger.debug("\u5206\u9875Sql\uff1a{}", (Object)pagingSelect);
        return pagingSelect.toString();
    }

    @Override
    public String convertValueToSql(Object value, int sqlType) {
        StringBuilder sqlPart = new StringBuilder();
        if (value == null) {
            sqlPart.append("null");
        } else {
            switch (sqlType) {
                case -7: 
                case -6: 
                case -5: 
                case 0: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 8: 
                case 16: {
                    sqlPart.append(value);
                    break;
                }
                case 91: 
                case 92: 
                case 93: {
                    if (value instanceof Date) {
                        sqlPart.append("'").append(DateUtils.formart((Date)((Date)value), (String)"yyyy-MM-dd HH:mm:ss")).append("'");
                        break;
                    }
                    sqlPart.append("'").append(value).append("'");
                    break;
                }
                default: {
                    sqlPart.append("'").append(SqlUtils.transferStringForSql(value.toString())).append("'");
                }
            }
        }
        return sqlPart.toString();
    }

    @Override
    public String wrapName(String name) {
        if (LangUtils.isNotEmpty((String)name)) {
            return this.getWrapSign() + name + this.getWrapSign();
        }
        return name;
    }

    @Override
    public String getFkCheck(boolean check) {
        throw new UnsupportedException();
    }

    @Override
    public String getWrapSign() {
        return "\"";
    }

    @Override
    protected String getPrimaryKeyDDL(Table table) {
        StringBuilder result = new StringBuilder("(");
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            result.append(this.wrapName(column.getName())).append(".");
        }
        result.deleteCharAt(result.length() - 1);
        result.append(")");
        return BuilderUtils.link(this.getKeyword(Keywords.CONSTRAINT), this.wrapName(table.getName() + "_pkey"), this.getKeyword(Keywords.PRIMARY), this.getKeyword(Keywords.KEY), result.toString());
    }
}

