/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.builder.model.TableElement;
import cn.featherfly.common.db.dialect.DialectException;
import cn.featherfly.common.db.dialect.Join;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.repository.operate.AggregateFunction;
import cn.featherfly.common.repository.operate.Function;
import cn.featherfly.common.repository.operate.LogicOperator;
import cn.featherfly.common.repository.operate.SortOperator;
import java.util.Map;

public interface Dialect {
    public static final String START_PARAM_NAME = "dialect_paging_start";
    public static final String LIMIT_PARAM_NAME = "dialect_paging_limit";
    public static final int DEFAULT_LIMIT = 10;

    public String getPaginationSql(String var1, int var2, int var3);

    public Object[] getPaginationSqlParameter(Object[] var1, int var2, int var3);

    public Map<String, Object> getPaginationSqlParameter(Map<String, Object> var1, int var2, int var3);

    public String getParamNamedPaginationSql(String var1, int var2, int var3);

    public String valueToSql(Object var1, int var2);

    public String wrapName(String var1);

    public String getFkCheck(boolean var1);

    default public boolean isKeywordsUppercase() {
        return true;
    }

    default public boolean isTableAndColumnNameUppercase() {
        return false;
    }

    default public Keyworld getKeywords() {
        return new Keyworld(this);
    }

    default public String getKeyword(SortOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getKeyword(LogicOperator keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getKeyword(Keywords keywords) {
        if (this.isKeywordsUppercase()) {
            return keywords.toString();
        }
        return keywords.toString().toLowerCase();
    }

    default public String getFunction(Function function) {
        if (this.isKeywordsUppercase()) {
            return function.toString().toUpperCase();
        }
        return function.toString().toLowerCase();
    }

    default public String buildColumnSql(String columnName, Function function) {
        return this.buildColumnSql(columnName, null, function);
    }

    default public String buildColumnSql(String columnName, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, null, aggregateFunction);
    }

    default public String buildColumnSql(String columnName, String tableAlias) {
        return this.buildColumnSql(columnName, tableAlias, null, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, String asName) {
        return this.buildColumnSql(columnName, tableAlias, null, asName);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction) {
        return this.buildColumnSql(columnName, tableAlias, aggregateFunction, null);
    }

    default public String buildColumnSql(String columnName, String tableAlias, AggregateFunction aggregateFunction, String asName) {
        String column = columnName;
        if (!"*".equals(columnName)) {
            column = this.wrapName(this.convertTableOrColumnName(columnName));
        }
        if (LangUtils.isNotEmpty((String)tableAlias) && !"*".equals(columnName)) {
            column = tableAlias + "." + column;
        }
        if (aggregateFunction != null) {
            switch (aggregateFunction) {
                case DISTINCT: {
                    column = this.getFunction((Function)aggregateFunction) + " " + column;
                    break;
                }
                default: {
                    column = this.getFunction((Function)aggregateFunction) + "(" + column + ")";
                }
            }
        }
        if (LangUtils.isNotEmpty((String)asName)) {
            column = column + " " + this.wrapName(asName);
        }
        return column;
    }

    default public String buildColumnSql(String columnName, String tableAlias, Function function) {
        if (function instanceof AggregateFunction) {
            return this.buildColumnSql(columnName, tableAlias, function);
        }
        throw new DialectException("\u53ea\u5b9e\u73b0\u4e86 AggregateFunction\uff0c\u672a\u5b9e\u73b0\u7684 function" + function.getClass().getName());
    }

    default public String convertTableOrColumnName(String tableOrColumnName) {
        if (LangUtils.isEmpty((String)tableOrColumnName)) {
            return tableOrColumnName;
        }
        String result = tableOrColumnName;
        result = this.isTableAndColumnNameUppercase() ? result.toUpperCase() : result.toLowerCase();
        return result;
    }

    default public String buildTableSql(TableElement table) {
        return this.buildTableSql(table.getName(), table.getAlias());
    }

    default public String buildTableSql(String tableName) {
        return this.buildTableSql(tableName, null);
    }

    default public String buildTableSql(String tableName, String tableAlias) {
        String result = this.wrapName(this.convertTableOrColumnName(tableName));
        if (LangUtils.isNotEmpty((String)tableAlias)) {
            result = result + " " + tableAlias;
        }
        return result;
    }

    default public String buildCreateDataBaseDDL(String dataBaseName) {
        AssertIllegalArgument.isNotEmpty((String)dataBaseName, (String)"dataBaseName");
        return BuilderUtils.link(this.getKeyword(Keywords.CREATE), this.getKeyword(Keywords.DATABASE), this.wrapName(dataBaseName));
    }

    default public String buildDropDataBaseDDL(String dataBaseName) {
        return this.buildDropDataBaseDDL(dataBaseName, false);
    }

    default public String buildDropDataBaseDDL(String dataBaseName, boolean ifExists) {
        AssertIllegalArgument.isNotEmpty((String)dataBaseName, (String)"dataBaseName");
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.DATABASE), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), this.wrapName(dataBaseName));
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.DATABASE), this.wrapName(dataBaseName));
    }

    default public String buildCreateTableDDL(Table table) {
        return this.buildCreateTableDDL(table.getCatalog(), table);
    }

    public String buildCreateTableDDL(String var1, Table var2);

    default public String buildDropTableDDL(String tableName) {
        return this.buildDropTableDDL(null, tableName);
    }

    default public String buildDropTableDDL(String tableName, boolean ifExists) {
        return this.buildDropTableDDL(null, tableName, ifExists);
    }

    default public String buildDropTableDDL(String databaseName, String tableName) {
        return this.buildDropTableDDL(databaseName, tableName, false);
    }

    default public String buildDropTableDDL(String databaseName, String tableName, boolean ifExists) {
        String tn;
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        String string = tn = LangUtils.isEmpty((String)databaseName) ? this.wrapName(tableName) : this.wrapName(databaseName) + "." + this.wrapName(tableName);
        if (ifExists) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.TABLE), this.getKeyword(Keywords.IF), this.getKeyword(Keywords.EXISTS), tn);
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.TABLE), tn);
    }

    default public String buildAlterTableDDL(String tableName) {
        return this.buildAlterTableDDL(null, tableName);
    }

    default public String buildAlterTableDDL(String databaseName, String tableName) {
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        if (LangUtils.isEmpty((String)databaseName)) {
            return BuilderUtils.link(this.getKeyword(Keywords.ALTER), this.getKeyword(Keywords.TABLE), this.wrapName(tableName));
        }
        return BuilderUtils.link(this.getKeyword(Keywords.ALTER), this.getKeyword(Keywords.TABLE), this.wrapName(databaseName) + "." + this.wrapName(tableName));
    }

    default public String buildAlterTableAddColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableAddColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableAddColumnDDL(String var1, String var2, Column ... var3);

    default public String buildAlterTableModifyColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableModifyColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableModifyColumnDDL(String var1, String var2, Column ... var3);

    default public String buildAlterTableDropColumnDDL(String tableName, Column ... columns) {
        return this.buildAlterTableDropColumnDDL(null, tableName, columns);
    }

    public String buildAlterTableDropColumnDDL(String var1, String var2, Column ... var3);

    public String buildAlterTableDropColumnDDL(String var1, String var2, String ... var3);

    default public String buildDropViewDDL(String viewName) {
        return this.buildDropViewDDL(null, viewName);
    }

    default public String buildDropViewDDL(String databaseName, String viewName) {
        AssertIllegalArgument.isNotEmpty((String)viewName, (String)"viewName");
        if (LangUtils.isEmpty((String)databaseName)) {
            return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.VIEW), this.wrapName(viewName));
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.VIEW), this.wrapName(databaseName) + "." + this.wrapName(viewName));
    }

    default public String buildDropIndexDDL(String tableName, String indexName) {
        return this.buildDropIndexDDL(null, tableName, indexName);
    }

    default public String buildDropIndexDDL(String database, String tableName, String indexName) {
        AssertIllegalArgument.isNotEmpty((String)tableName, (String)"tableName");
        AssertIllegalArgument.isNotEmpty((String)indexName, (String)"indexName");
        if (LangUtils.isEmpty((String)tableName)) {
            return BuilderUtils.link(this.buildAlterTableDDL(database, tableName), this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), this.wrapName(indexName));
        }
        return BuilderUtils.link(this.buildAlterTableDDL(database, tableName), this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.INDEX), this.wrapName(indexName));
    }

    public String getWrapSign();

    public static class Keyworld {
        private Dialect dialect;

        Keyworld(Dialect dialect) {
            this.dialect = dialect;
        }

        public String select() {
            return this.dialect.getKeyword(Keywords.SELECT);
        }

        public String from() {
            return this.dialect.getKeyword(Keywords.FROM);
        }

        public String where() {
            return this.dialect.getKeyword(Keywords.WHERE);
        }

        public String update() {
            return this.dialect.getKeyword(Keywords.UPDATE);
        }

        public String set() {
            return this.dialect.getKeyword(Keywords.SET);
        }

        public String delete() {
            return this.dialect.getKeyword(Keywords.DELETE);
        }

        public String deleteFrom() {
            return this.delete() + " " + this.from();
        }

        public String insert() {
            return this.dialect.getKeyword(Keywords.INSERT);
        }

        public String into() {
            return this.dialect.getKeyword(Keywords.INTO);
        }

        public String values() {
            return this.dialect.getKeyword(Keywords.VALUES);
        }

        public String join() {
            return this.dialect.getKeyword(Keywords.JOIN);
        }

        public String join(Join join) {
            switch (join) {
                case INNER_JOIN: {
                    return this.join();
                }
                case LEFT_JOIN: {
                    return this.left() + " " + this.join();
                }
                case RIGHT_JOIN: {
                    return this.right() + " " + this.join();
                }
                case FULL_JOIN: {
                    return this.full() + " " + this.join();
                }
            }
            return this.join();
        }

        public String on() {
            return this.dialect.getKeyword(Keywords.ON);
        }

        public String inner() {
            return this.dialect.getKeyword(Keywords.INNER);
        }

        public String left() {
            return this.dialect.getKeyword(Keywords.LEFT);
        }

        public String right() {
            return this.dialect.getKeyword(Keywords.RIGHT);
        }

        public String create() {
            return this.dialect.getKeyword(Keywords.CREATE);
        }

        public String drop() {
            return this.dialect.getKeyword(Keywords.DROP);
        }

        public String after() {
            return this.dialect.getKeyword(Keywords.AFTER);
        }

        public String table() {
            return this.dialect.getKeyword(Keywords.TABLE);
        }

        public String add() {
            return this.dialect.getKeyword(Keywords.ADD);
        }

        public String truncate() {
            return this.dialect.getKeyword(Keywords.TRUNCATE);
        }

        public String outer() {
            return this.dialect.getKeyword(Keywords.OUTER);
        }

        public String full() {
            return this.dialect.getKeyword(Keywords.FULL);
        }

        public String cross() {
            return this.dialect.getKeyword(Keywords.CORSS);
        }

        public String order() {
            return this.dialect.getKeyword(Keywords.ORDER);
        }

        public String by() {
            return this.dialect.getKeyword(Keywords.BY);
        }

        public String orderBy() {
            return this.order() + " " + this.by();
        }

        public String desc() {
            return this.dialect.getKeyword(Keywords.DESC);
        }

        public String asc() {
            return this.dialect.getKeyword(Keywords.ASC);
        }

        public String in() {
            return this.dialect.getKeyword(Keywords.IN);
        }

        public String is() {
            return this.dialect.getKeyword(Keywords.IS);
        }

        public String isNull() {
            return this.is() + " " + this.nullText();
        }

        public String isNotNull() {
            return this.is() + " " + this.not() + " " + this.nullText();
        }

        public String like() {
            return this.dialect.getKeyword(Keywords.LIKE);
        }

        public String nullText() {
            return this.dialect.getKeyword(Keywords.NULL);
        }

        public String not() {
            return this.dialect.getKeyword(Keywords.NOT);
        }

        public String notIn() {
            return this.not() + " " + this.in();
        }

        public String between() {
            return this.dialect.getKeyword(Keywords.BETWEEN);
        }

        public String union() {
            return this.dialect.getKeyword(Keywords.UNION);
        }

        public String intersect() {
            return this.dialect.getKeyword(Keywords.INTERSECT);
        }

        public String except() {
            return this.dialect.getKeyword(Keywords.EXCEPT);
        }

        public String and() {
            return this.dialect.getKeyword(Keywords.AND);
        }

        public String or() {
            return this.dialect.getKeyword(Keywords.OR);
        }

        public String all() {
            return this.dialect.getKeyword(Keywords.ALL);
        }

        public String as() {
            return this.dialect.getKeyword(Keywords.AS);
        }

        public String count() {
            return this.dialect.getKeyword(Keywords.COUNT);
        }

        public String sum() {
            return this.dialect.getKeyword(Keywords.SUM);
        }

        public String max() {
            return this.dialect.getKeyword(Keywords.MAX);
        }

        public String min() {
            return this.dialect.getKeyword(Keywords.MIN);
        }

        public String avg() {
            return this.dialect.getKeyword(Keywords.AVG);
        }

        public String distinct() {
            return this.dialect.getKeyword(Keywords.DISTINCT);
        }
    }
}

