/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.dialect;

import cn.featherfly.common.db.builder.BuilderUtils;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.db.dialect.Keywords;
import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.SqlType;
import cn.featherfly.common.db.metadata.Table;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDialect
implements Dialect {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private Dialect.Keyworld keyworld = new Dialect.Keyworld(this);
    protected static final String UPDATE_STRING = " for update";
    private boolean keywordsUppercase = true;
    private boolean tableAndColumnNameUppercase = false;

    @Override
    public boolean isKeywordsUppercase() {
        return this.keywordsUppercase;
    }

    public void setKeywordsUppercase(boolean keywordsUppercase) {
        this.keywordsUppercase = keywordsUppercase;
    }

    @Override
    public boolean isTableAndColumnNameUppercase() {
        return this.tableAndColumnNameUppercase;
    }

    public void setTableAndColumnNameUppercase(boolean tableAndColumnNameUppercase) {
        this.tableAndColumnNameUppercase = tableAndColumnNameUppercase;
    }

    @Override
    public String buildAlterTableAddColumnDDL(String databaseName, String tableName, Column ... columns) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(databaseName, tableName));
        ddl.append("\n");
        for (Column column : columns) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.ADD), this.getKeyword(Keywords.COLUMN), this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildAlterTableModifyColumnDDL(String databaseName, String tableName, Column ... columns) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(databaseName, tableName));
        ddl.append("\n");
        for (Column column : columns) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.MODIFY), this.getKeyword(Keywords.COLUMN), this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildAlterTableDropColumnDDL(String databaseName, String tableName, Column ... columns) {
        String[] columnNames = new String[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            columnNames[i] = columns[i].getName();
        }
        return this.buildAlterTableDropColumnDDL(databaseName, tableName, columnNames);
    }

    @Override
    public String buildAlterTableDropColumnDDL(String databaseName, String tableName, String ... columnNames) {
        StringBuilder ddl = new StringBuilder(this.buildAlterTableDDL(databaseName, tableName));
        ddl.append("\n");
        for (String columnName : columnNames) {
            BuilderUtils.link(ddl, this.getKeyword(Keywords.DROP), this.getKeyword(Keywords.COLUMN), this.wrapName(columnName));
            ddl.append(",");
            ddl.append("\n");
        }
        ddl.deleteCharAt(ddl.length() - 1).deleteCharAt(ddl.length() - 1);
        return ddl.toString();
    }

    @Override
    public String buildCreateTableDDL(String dataBaseName, Table table) {
        AssertIllegalArgument.isNotEmpty((Object)table, (String)"table");
        StringBuilder sql = new StringBuilder();
        String tableName = LangUtils.isEmpty((String)dataBaseName) ? this.wrapName(table.getName()) : this.wrapName(dataBaseName) + "." + this.wrapName(table.getName());
        BuilderUtils.link(sql, this.getKeyword(Keywords.CREATE), this.getKeyword(Keywords.TABLE), tableName, "(");
        sql.append("\n");
        BuilderUtils.link(sql, this.getTableColumnsDDL(table));
        sql.append("\n");
        BuilderUtils.link(sql, ")", this.getTableComment(table));
        return sql.toString();
    }

    protected String getTableComment(Table table) {
        return LangUtils.isEmpty((String)table.getRemark()) ? "" : BuilderUtils.link(this.getKeyword(Keywords.COMMENT), "'" + table.getRemark() + "'");
    }

    protected String getTableColumnsDDL(Table table) {
        StringBuilder ddl = new StringBuilder();
        for (Column column : table.getColumns()) {
            BuilderUtils.link(ddl, this.getColumnDDL(column));
            ddl.append(",");
            ddl.append("\n");
        }
        BuilderUtils.link(ddl, this.getPrimaryKeyDDL(table));
        return ddl.toString();
    }

    protected String getColumnDDL(Column column) {
        return BuilderUtils.link(this.wrapName(column.getName()), this.getColumnTypeDDL(column), this.getColumnNotNull(column), this.getDefaultValue(column), this.getAutoIncrement(column), this.getColumnComment(column));
    }

    protected String getPrimaryKeyDDL(Table table) {
        StringBuilder result = new StringBuilder("(");
        for (Column column : table.getColumns()) {
            if (!column.isPrimaryKey()) continue;
            result.append(this.wrapName(column.getName())).append(",");
        }
        result.deleteCharAt(result.length() - 1);
        result.append(")");
        return BuilderUtils.link(this.getKeyword(Keywords.PRIMARY), this.getKeyword(Keywords.KEY), result.toString());
    }

    protected String getDefaultValue(Column column) {
        if (LangUtils.isEmpty((String)column.getDefaultValue())) {
            return "";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.DEFAULT), "'" + column.getDefaultValue() + "'");
    }

    protected String getAutoIncrement(Column column) {
        return "";
    }

    protected String getColumnComment(Column column) {
        return LangUtils.isEmpty((String)column.getRemark()) ? "" : BuilderUtils.link(this.getKeyword(Keywords.COMMENT), "'" + column.getRemark() + "'");
    }

    protected String getColumnNotNull(Column column) {
        if (column.isNullable()) {
            return "";
        }
        return BuilderUtils.link(this.getKeyword(Keywords.NOT), this.getKeyword(Keywords.NULL));
    }

    protected String getColumnTypeDDL(Column column) {
        return this.getColumnTypeDDL(column, null);
    }

    protected String getColumnTypeDDL(Column column, String extra) {
        int size = column.getSize();
        int decimalDigits = column.getDecimalDigits();
        String result = this.getColumnTypeName(column.getSqlType());
        if (size > 0) {
            result = result + "(" + size;
            if (decimalDigits > 0) {
                result = result + "." + decimalDigits;
            }
            result = result + ")";
        }
        if (LangUtils.isNotEmpty((String)extra)) {
            result = BuilderUtils.link(result, extra);
        }
        return result;
    }

    protected String getColumnTypeName(SqlType sqlType) {
        return sqlType.getName();
    }

    @Override
    public Dialect.Keyworld getKeywords() {
        return this.keyworld;
    }

    @Override
    public Object[] getPaginationSqlParameter(Object[] params, int start, int limit) {
        Object[] pagingParams = null;
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            pagingParams = new Object[2];
            pagingParams[0] = start;
        } else {
            this.logger.debug("start < 0 , don't use start");
            pagingParams = new Object[1];
        }
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        pagingParams[pagingParams.length - 1] = limit;
        return (Object[])ArrayUtils.concat((Object)params, (Object)pagingParams);
    }

    @Override
    public Map<String, Object> getPaginationSqlParameter(Map<String, Object> params, int start, int limit) {
        if (start > 0) {
            this.logger.debug("start > 0 , use start {}", (Object)start);
            params.put("dialect_paging_start", start);
        } else {
            this.logger.debug("start < 0 , don't use start");
        }
        if (limit > 0) {
            this.logger.debug("limit > 0 , use limit {}", (Object)limit);
        } else if (limit == 0) {
            this.logger.debug("limit = 0 , use default limit {}", (Object)10);
            limit = 10;
        } else {
            this.logger.debug("limit < 0 , don't use limit");
            limit = Integer.MAX_VALUE;
        }
        params.put("dialect_paging_limit", limit);
        return params;
    }

    protected boolean isForUpdate(String sql) {
        return sql.toLowerCase().endsWith(UPDATE_STRING);
    }

    @Override
    public String valueToSql(Object value, int sqlType) {
        return this.convertValueToSql(value, sqlType);
    }

    protected abstract String convertValueToSql(Object var1, int var2);
}

