/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.data;

import cn.featherfly.common.db.JdbcUtils;
import cn.featherfly.common.db.data.AbstractDataImportor;
import cn.featherfly.common.db.data.DataImportor;
import cn.featherfly.common.db.data.ImportException;
import cn.featherfly.common.db.data.RecordModel;
import cn.featherfly.common.db.dialect.Dialect;
import cn.featherfly.common.lang.LangUtils;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.Reader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;

public class JsonImportor
extends AbstractDataImportor {
    private JsonFactory factory = new JsonFactory();

    public JsonImportor(Dialect dialect) {
        super(dialect);
    }

    @Override
    public void imp(Reader reader) {
        Connection conn = null;
        try {
            JsonParser parser = this.factory.createParser(reader);
            conn = this.getDataSource().getConnection();
            conn.setAutoCommit(false);
            if (!this.isFkCheck()) {
                this.addPrepareSql(this.getDialect().getFkCheck(this.isFkCheck()));
            }
            if (LangUtils.isNotEmpty(this.getPrepareSqls())) {
                for (String prepareSql : this.getPrepareSqls()) {
                    this.logger.debug("prepareSql: {}", (Object)prepareSql);
                    conn.createStatement().execute(prepareSql);
                }
            }
            while (parser.nextToken() != null) {
                System.out.print("token: " + parser.getCurrentToken().asString());
                System.out.print(" \t name : " + parser.getCurrentName());
                System.out.println(" \t " + parser.getCurrentToken());
                if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                    System.out.print("token == JsonToken.START_ARRAY: " + parser.getCurrentToken().asString());
                    System.out.println(" \t name: " + parser.getCurrentName());
                    this.readTable(parser, conn);
                    continue;
                }
                if (parser.getCurrentToken() == JsonToken.START_OBJECT || "name".equals(parser.getCurrentName()) || !"tables".equals(parser.getCurrentName())) continue;
            }
            if (this.getTransactionPolicy() == DataImportor.TransactionPolicy.all) {
                conn.commit();
            }
            JdbcUtils.closeQuietly(conn);
        }
        catch (Exception e) {
            JdbcUtils.rollbackAndCloseQuietly(conn);
            throw new ImportException(e);
        }
    }

    private void readTable(JsonParser parser, Connection conn) throws Exception {
        Statement statement = conn.createStatement();
        String tableName = null;
        String pkMapping = null;
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            System.out.print(" readTable token: " + parser.getCurrentToken().asString());
            System.out.println(" \t name: " + parser.getCurrentName());
            if (parser.getCurrentToken() == JsonToken.START_ARRAY) {
                this.readRows(parser, statement, tableName, pkMapping);
                continue;
            }
            if ("name".equals(parser.getCurrentName())) {
                parser.nextToken();
                tableName = parser.getText();
                continue;
            }
            if (!"pkMapping".equals(parser.getCurrentName())) continue;
            parser.nextToken();
            pkMapping = parser.getText();
        }
        statement.executeBatch();
        statement.close();
        if (this.getTransactionPolicy() == DataImportor.TransactionPolicy.table) {
            conn.commit();
        }
    }

    private void readRows(JsonParser parser, Statement statement, String tableName, String pkMapping) throws Exception {
        String[] pkMappings = pkMapping.split(",");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("select count(*) as num from ").append(tableName).append(" where ");
        for (int i = 0; i < pkMappings.length; ++i) {
            String pkName = pkMappings[i];
            if (i > 0) {
                selectSql.append(" and ");
            }
            selectSql.append(pkName).append(" = ? ");
        }
        this.logger.debug("selectSql : {}", (Object)selectSql.toString());
        PreparedStatement prep = statement.getConnection().prepareStatement(selectSql.toString());
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            if (parser.getCurrentToken() != JsonToken.START_OBJECT) continue;
            System.out.print(" readTable token: " + parser.getCurrentToken().asString());
            System.out.println(" \t name: " + parser.getCurrentName());
            this.readRow(parser, statement, tableName, pkMappings, prep);
        }
    }

    private void readRow(JsonParser parser, Statement statement, String tableName, String[] pkMappings, PreparedStatement prep) throws Exception {
        HashMap<String, Map<String, String>> columnsMap = new HashMap<String, Map<String, String>>();
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            if (parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
            HashMap<String, String> column = new HashMap<String, String>();
            columnsMap.put(parser.getCurrentName(), column);
            parser.nextToken();
            while (parser.nextToken() != JsonToken.END_OBJECT) {
                if (parser.getCurrentToken() != JsonToken.FIELD_NAME) continue;
                parser.nextToken();
                column.put(parser.getCurrentName(), parser.getText());
            }
        }
        if (DataImportor.ExistPolicy.exception == this.getExistPolicy()) {
            this.insert(columnsMap, tableName, statement);
        } else {
            int num = 0;
            String msg = "table " + tableName + " {}, {}";
            for (int i = 0; i < pkMappings.length; ++i) {
                String pkName = pkMappings[i];
                String value = (String)((Map)columnsMap.get(pkName)).get("value");
                JdbcUtils.setParameter(prep, i + 1, (Object)value);
            }
            ResultSet res = prep.executeQuery();
            if (res.next()) {
                if (res.getLong(1) > 0L) {
                    this.logger.debug(msg, (Object)"exits", (Object)num++);
                    if (DataImportor.ExistPolicy.update == this.getExistPolicy()) {
                        this.update(columnsMap, tableName, statement, pkMappings);
                    }
                } else {
                    this.logger.debug(msg, (Object)"not exits", (Object)num++);
                    this.insert(columnsMap, tableName, statement);
                }
            }
        }
    }

    private void update(Map<String, Map<String, String>> columnsMap, String tableName, Statement statement, String[] pkMappings) throws SQLException {
        StringBuilder updateSql = new StringBuilder();
        StringBuilder condition = new StringBuilder();
        StringBuilder values = new StringBuilder();
        if (columnsMap.size() == pkMappings.length) {
            this.logger.trace("\u5217\u6570\u91cf\u4e0e\u4e3b\u952e\u5217\u6570\u91cf\u4e00\u81f4\uff0c\u4e0d\u8fdb\u884c\u66f4\u65b0");
            return;
        }
        RecordModel recordModel = new RecordModel(tableName);
        for (Map.Entry<String, Map<String, String>> entry : columnsMap.entrySet()) {
            RecordModel.ValueModel valueModel = new RecordModel.ValueModel(entry.getKey(), this.getType(entry.getValue().get("type")), entry.getValue().get("value"));
            recordModel.add(valueModel);
        }
        if (this.filtdate(recordModel, statement.getConnection())) {
            return;
        }
        recordModel = this.transform(recordModel);
        for (Map.Entry<String, Map<String, String>> entry : columnsMap.entrySet()) {
            String columnName = entry.getKey();
            RecordModel.ValueModel vm = recordModel.getValueMode(columnName);
            int type = vm.getType();
            String value = vm.getValue();
            boolean isPkColumn = false;
            for (int i = 0; i < pkMappings.length; ++i) {
                String pkName = pkMappings[i];
                if (!columnName.equals(pkName)) continue;
                if (condition.length() > 0) {
                    condition.append(" and ");
                }
                condition.append(this.getDialect().wrapName(columnName.toUpperCase())).append(" = ").append(this.getValueToSql(value, type, entry.getValue().get("null")));
                isPkColumn = true;
            }
            if (isPkColumn) continue;
            values.append(" ").append(this.getDialect().wrapName(columnName.toUpperCase())).append(" = ").append(this.getValueToSql(value, type, entry.getValue().get("null"))).append(",");
        }
        if (values.length() > 0 && values.lastIndexOf(",") + 1 == values.length()) {
            values.deleteCharAt(values.length() - 1);
        }
        if (condition.length() > 0 && condition.lastIndexOf(",") + 1 == condition.length()) {
            condition.deleteCharAt(condition.length() - 1);
        }
        updateSql.append("UPDATE ").append(this.getDialect().wrapName(tableName.toUpperCase())).append(" SET ").append((CharSequence)values).append(" WHERE ").append((CharSequence)condition);
        this.logger.trace("update sql : {}", (Object)updateSql.toString());
        statement.addBatch(updateSql.toString());
    }

    private void insert(Map<String, Map<String, String>> columnsMap, String tableName, Statement statement) throws SQLException {
        RecordModel recordModel = new RecordModel(tableName);
        for (Map.Entry<String, Map<String, String>> entry : columnsMap.entrySet()) {
            RecordModel.ValueModel valueModel = new RecordModel.ValueModel(entry.getKey(), this.getType(entry.getValue().get("type")), entry.getValue().get("value"));
            recordModel.add(valueModel);
        }
        if (this.filtdate(recordModel, statement.getConnection())) {
            return;
        }
        recordModel = this.transform(recordModel);
        StringBuilder insertSql = new StringBuilder();
        StringBuilder columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        values.append(" VALUES ( ");
        columns.append(" ( ");
        for (Map.Entry<String, Map<String, String>> entry : columnsMap.entrySet()) {
            String columnName = entry.getKey();
            RecordModel.ValueModel vm = recordModel.getValueMode(columnName);
            int type = vm.getType();
            String value = vm.getValue();
            columns.append(this.getDialect().wrapName(columnName.toUpperCase())).append(",");
            values.append(this.getValueToSql(value, type, entry.getValue().get("null"))).append(",");
        }
        if (columns.lastIndexOf(",") + 1 == columns.length()) {
            columns.deleteCharAt(columns.length() - 1);
        }
        columns.append(" )");
        if (values.lastIndexOf(",") + 1 == values.length()) {
            values.deleteCharAt(values.length() - 1);
        }
        values.append(" )");
        columns.append(values.toString());
        insertSql.append("INSERT INTO ").append(this.getDialect().wrapName(tableName.toUpperCase())).append((CharSequence)columns).append(";");
        this.logger.trace("insert sql : {}", (Object)insertSql.toString());
        statement.addBatch(insertSql.toString());
    }
}

