/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db.builder.ddl;

import cn.featherfly.common.db.metadata.Column;
import cn.featherfly.common.db.metadata.Table;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TableModel
implements Table {
    private String type;
    private String name;
    private String remark;
    private String catalog;
    private List<Column> primaryColumns = new ArrayList<Column>(1);
    private Map<String, Column> columnMap = new LinkedHashMap<String, Column>(0);

    @Override
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getRemark() {
        return this.remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    @Override
    public String getCatalog() {
        return this.catalog;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    @Override
    public Column getColumn(String columnName) {
        return this.columnMap.get(columnName.toUpperCase());
    }

    @Override
    public Collection<Column> getColumns() {
        return this.columnMap.values();
    }

    @Override
    public Map<String, Column> getColumnMap() {
        return this.columnMap;
    }

    public void addColumn(Column column) {
        if (column.isPrimaryKey()) {
            this.primaryColumns.add(column);
        }
        this.columnMap.put(column.getName().toUpperCase(), column);
    }

    public void addColumn(Column ... columns) {
        for (Column columnMetadata : columns) {
            this.addColumn(columnMetadata);
        }
    }

    public void addColumn(Collection<Column> columns) {
        for (Column columnMetadata : columns) {
            this.addColumn(columnMetadata);
        }
    }

    @Override
    public List<Column> getPrimaryColumns() {
        return this.primaryColumns;
    }
}

