/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.db;

import cn.featherfly.common.lang.LangUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SqlUtils {
    private static final Pattern SELECT_PATTERN = Pattern.compile("((select )(distinct [\\w-_.]+)?,?.+)(from .+)", 2);

    private SqlUtils() {
    }

    public static String convertSelectToCount(String sql) {
        Matcher m = SELECT_PATTERN.matcher(sql = sql.trim());
        if (!m.matches()) {
            throw new IllegalArgumentException("[" + sql + "] \u4e0d\u662f\u67e5\u8be2SQL , \u67e5\u8be2SQL\u5e94\u8be5\u662f\u8fd9\u6837?[select xx from xxx ...]");
        }
        StringBuilder countSql = new StringBuilder("SELECT COUNT(");
        String fromSql = sql.substring(m.group(1).length());
        String distinctColumn = null;
        int groupThree = 3;
        if (m.group(groupThree) != null) {
            distinctColumn = sql.substring(m.group(2).length(), m.group(2).length() + m.group(groupThree).length());
        }
        if (LangUtils.isEmpty(distinctColumn)) {
            countSql.append("*");
        } else {
            countSql.append(distinctColumn);
        }
        return countSql.append(") ").append(fromSql).toString();
    }

    public static String transferStringForSql(String str) {
        if (LangUtils.isEmpty((String)str)) {
            return str;
        }
        return str.replaceAll("[\\\\'\"]", "\\\\$0");
    }
}

