/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.validate;

import cn.featherfly.common.validate.ValidateCode;
import cn.featherfly.common.validate.ValidateCodeGenerator;
import java.util.Random;

public class SimpleValidateCodeGenerator
implements ValidateCodeGenerator {
    public static final String VERIFY_CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    private int size;

    public SimpleValidateCodeGenerator() {
    }

    public SimpleValidateCodeGenerator(int size) {
        this.size = size;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public String generate(int verifySize) {
        return this.generate(verifySize, VERIFY_CODES);
    }

    public String generate(int size, String sources) {
        if (sources == null || sources.length() == 0) {
            sources = VERIFY_CODES;
        }
        int codesLen = sources.length();
        Random rand = new Random(System.currentTimeMillis());
        StringBuilder verifyCode = new StringBuilder(size);
        for (int i = 0; i < size; ++i) {
            verifyCode.append(sources.charAt(rand.nextInt(codesLen - 1)));
        }
        return verifyCode.toString();
    }

    @Override
    public ValidateCode generate() {
        String code = this.generate(this.size);
        return new ValidateCode(code, code);
    }
}

