/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.string;

import cn.featherfly.common.lang.Lang;
import java.util.Map;

public class StringFormatter {
    private char startSymbol;
    private char endSymbol;

    public StringFormatter(char startSymbol, char endSymbol) {
        this.startSymbol = startSymbol;
        this.endSymbol = endSymbol;
    }

    public char getStartSymbol() {
        return this.startSymbol;
    }

    public char getEndSymbol() {
        return this.endSymbol;
    }

    public String format(String str, Object ... args) {
        return this.format(str, this.startSymbol, this.endSymbol, Lang.toMap2(args));
    }

    public String format(String str, Map<String, Object> args) {
        return this.format(str, this.startSymbol, this.endSymbol, args);
    }

    private String format(String str, char startSymbol, char endSymbol, Map<String, Object> args) {
        if (Lang.isEmpty(str)) {
            return str;
        }
        StringBuilder sql = new StringBuilder(str);
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        boolean isEnd = false;
        for (int index = 0; index < sql.length(); ++index) {
            char c = sql.charAt(index);
            boolean bl = isEnd = index == sql.length() - 1;
            if (nameStartIndex == -1) {
                if (startSymbol == c) {
                    if (!isEnd && sql.charAt(index + 1) == startSymbol) {
                        sql.deleteCharAt(index);
                        continue;
                    }
                    nameStartIndex = index;
                    continue;
                }
                if (c == endSymbol && !isEnd && sql.charAt(index + 1) == endSymbol) {
                    sql.deleteCharAt(index);
                }
            }
            if (nameStartIndex <= 0 || c != endSymbol && !isEnd) continue;
            nameEndIndex = index;
            String name = sql.substring(nameStartIndex + 1, nameEndIndex);
            sql.insert(++nameEndIndex, args.get(name));
            sql.delete(nameStartIndex, nameEndIndex);
            index -= nameEndIndex - nameStartIndex - 1;
            nameStartIndex = -1;
            nameEndIndex = -1;
        }
        return sql.toString();
    }
}

