/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bytecode;

import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ClassUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.ByteMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;

public class JavassistUtils {
    public static CtMethod createMethod(Method method, CtClass ctClass, ClassPool pool) throws NotFoundException {
        CtClass[] ctParamTypes = new CtClass[method.getParameterTypes().length];
        int i = 0;
        for (Parameter parameter : method.getParameters()) {
            ctParamTypes[i] = pool.getCtClass(parameter.getType().getName());
            ++i;
        }
        CtMethod ctMethod = new CtMethod(pool.getCtClass(method.getReturnType().getTypeName()), method.getName(), ctParamTypes, ctClass);
        return ctMethod;
    }

    public static List<AnnotationsAttribute> createAnnotations(Method method, CtClass ctClass) throws Exception {
        ConstPool constPool = ctClass.getClassFile().getConstPool();
        ArrayList<AnnotationsAttribute> list = new ArrayList<AnnotationsAttribute>();
        for (Annotation annotation : method.getAnnotations()) {
            AnnotationsAttribute attr = new AnnotationsAttribute(constPool, "RuntimeVisibleAnnotations");
            javassist.bytecode.annotation.Annotation ctAnnotation = new javassist.bytecode.annotation.Annotation(annotation.annotationType().getName(), constPool);
            for (Method m : annotation.annotationType().getDeclaredMethods()) {
                String memberName = m.getName();
                Object annotationMemberValue = m.invoke((Object)annotation, new Object[0]);
                MemberValue memberValue = JavassistUtils.createMemberValue(annotationMemberValue, constPool);
                ctAnnotation.addMemberValue(memberName, memberValue);
            }
            attr.addAnnotation(ctAnnotation);
            list.add(attr);
        }
        return list;
    }

    public static void copyAnnotations(Method method, CtMethod ctMethod, CtClass ctClass) throws Exception {
        JavassistUtils.createAnnotations(method, ctClass).forEach(a -> ctMethod.getMethodInfo().addAttribute((AttributeInfo)a));
    }

    public static MemberValue createMemberValue(Object value, ConstPool constPool) {
        if (value.getClass().isArray()) {
            ArrayMemberValue arrayMemberValue = new ArrayMemberValue(JavassistUtils.createObjectMemberValue(value.getClass().getComponentType(), constPool), constPool);
            int length = Array.getLength(value);
            MemberValue[] elements = new MemberValue[length];
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object v = Array.get(value, i);
                elements[i] = JavassistUtils.createObjectMemberValue(v, constPool);
            }
            arrayMemberValue.setValue(elements);
            return arrayMemberValue;
        }
        return JavassistUtils.createObjectMemberValue(value, constPool);
    }

    private static MemberValue createObjectMemberValue(Object value, ConstPool constPool) {
        if (value instanceof Annotation) {
            return new AnnotationMemberValue((javassist.bytecode.annotation.Annotation)value, constPool);
        }
        if (value instanceof Boolean || value.getClass() == Boolean.TYPE) {
            return new BooleanMemberValue(((Boolean)value).booleanValue(), constPool);
        }
        if (value instanceof Byte || value.getClass() == Byte.TYPE) {
            return new ByteMemberValue(((Byte)value).byteValue(), constPool);
        }
        if (value instanceof Character || value.getClass() == Character.TYPE) {
            return new CharMemberValue(((Character)value).charValue(), constPool);
        }
        if (value instanceof Class) {
            return new ClassMemberValue(((Class)value).getName(), constPool);
        }
        if (value instanceof Double || value.getClass() == Double.TYPE) {
            return new DoubleMemberValue(((Double)value).doubleValue(), constPool);
        }
        if (value instanceof Float || value.getClass() == Float.TYPE) {
            return new FloatMemberValue(((Float)value).floatValue(), constPool);
        }
        if (value instanceof Enum) {
            return null;
        }
        if (value instanceof Short || value.getClass() == Short.TYPE) {
            return new ShortMemberValue(((Short)value).shortValue(), constPool);
        }
        if (value instanceof Integer || value.getClass() == Integer.TYPE) {
            return new IntegerMemberValue(constPool, ((Integer)value).intValue());
        }
        if (value instanceof Long || value.getClass() == Long.TYPE) {
            return new LongMemberValue(((Long)value).longValue(), constPool);
        }
        if (value instanceof String) {
            return new StringMemberValue(value.toString(), constPool);
        }
        throw new UnsupportedException("not support type " + value.getClass().getName());
    }

    private static MemberValue createObjectMemberValue(Class<?> type, ConstPool constPool) {
        if (ClassUtils.isParent(Annotation.class, type)) {
            return new AnnotationMemberValue(constPool);
        }
        if (Boolean.class == type || type == Boolean.TYPE) {
            return new BooleanMemberValue(constPool);
        }
        if (Byte.class == type || type == Byte.TYPE) {
            return new ByteMemberValue(constPool);
        }
        if (Character.class == type || type == Character.TYPE) {
            return new CharMemberValue(constPool);
        }
        if (type == Class.class) {
            return new ClassMemberValue(constPool);
        }
        if (Double.class == type || type == Double.TYPE) {
            return new DoubleMemberValue(constPool);
        }
        if (type == Float.class || type == Float.TYPE) {
            return new FloatMemberValue(constPool);
        }
        if (ClassUtils.isParent(Enum.class, type)) {
            return null;
        }
        if (type == Short.class || type == Short.TYPE) {
            return new ShortMemberValue(constPool);
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return new IntegerMemberValue(constPool);
        }
        if (type == Long.class || type == Long.TYPE) {
            return new LongMemberValue(constPool);
        }
        if (type == String.class) {
            return new StringMemberValue(constPool);
        }
        throw new UnsupportedException("not support type " + type.getName());
    }
}

