/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.validate;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.RandomUtils;
import cn.featherfly.common.validate.ValidateCode;
import cn.featherfly.common.validate.ValidateCodeGenerator;
import java.util.ArrayList;
import java.util.List;

public class CountValidateCodeGenerator
implements ValidateCodeGenerator {
    private List<Integer> numbers = new ArrayList<Integer>();
    private List<String> operators = new ArrayList<String>();
    private int countTimes = 1;

    public CountValidateCodeGenerator() {
        this(1);
    }

    public CountValidateCodeGenerator(int countTimes) {
        this.countTimes = countTimes;
        for (int i = 1; i < 10; ++i) {
            this.numbers.add(i);
        }
        CollectionUtils.addAll(this.operators, "+", "-");
    }

    private ValidateCode count(int countTimes) {
        int result = RandomUtils.getRandom(this.numbers);
        String show = result + "";
        block8: for (int i = 0; i < countTimes; ++i) {
            String operator = RandomUtils.getRandom(this.operators);
            int nextNumber = RandomUtils.getRandom(this.numbers);
            show = show + operator + nextNumber;
            switch (operator) {
                case "+": {
                    result += nextNumber;
                    continue block8;
                }
                case "-": {
                    result -= nextNumber;
                }
            }
        }
        show = show + "=";
        return new ValidateCode(show, result + "");
    }

    @Override
    public ValidateCode generate() {
        return this.count(this.countTimes);
    }
}

