/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.locale;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.locale.ResourceBundle;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class JdkResourceBundleProxy
implements ResourceBundle {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.ISO_8859_1;
    private java.util.ResourceBundle bundle;
    private Charset charset;

    public JdkResourceBundleProxy(java.util.ResourceBundle bundle) {
        this.bundle = bundle;
    }

    public JdkResourceBundleProxy(java.util.ResourceBundle bundle, Charset charset) {
        this.bundle = bundle;
        this.charset = charset;
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object obj) {
        return this.bundle.equals(obj);
    }

    public String toString() {
        return this.encode(this.bundle.toString());
    }

    @Override
    public final String getString(String key) {
        return this.encode(this.bundle.getString(key));
    }

    @Override
    public final String[] getStringArray(String key) {
        return Stream.of(this.bundle.getStringArray(key)).map(value -> this.encode((String)value)).collect(Collectors.toList()).toArray(new String[0]);
    }

    @Override
    public Locale getLocale() {
        return this.bundle.getLocale();
    }

    @Override
    public Enumeration<String> getKeys() {
        return this.bundle.getKeys();
    }

    @Override
    public boolean containsKey(String key) {
        return this.bundle.containsKey(key);
    }

    @Override
    public Set<String> keySet() {
        return this.bundle.keySet();
    }

    private String encode(String str) {
        if (Lang.isNotEmpty(str) && this.charset != null) {
            return Strings.encode(str, DEFAULT_CHARSET.displayName(), this.charset.displayName());
        }
        return str;
    }
}

