/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.lang.ClassUtils;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;

public class LambdaUtils {
    private static final Map<SerializedLambda, SerializedLambdaInfo> CACHE_LAMBDA_INFO = new ConcurrentHashMap<SerializedLambda, SerializedLambdaInfo>(8);

    public static SerializedLambdaInfo getLambdaInfo(Serializable lambda) {
        SerializedLambda serializedLambda = LambdaUtils.getSerializedLambda(lambda);
        SerializedLambdaInfo info = CACHE_LAMBDA_INFO.get(serializedLambda);
        if (null != info) {
            return info;
        }
        SerializedLambdaInfo info2 = new SerializedLambdaInfo();
        info2.serializedLambda = serializedLambda;
        info2.methodDeclaredClassName = serializedLambda.getImplClass().replaceAll("/", ".");
        info2.methodName = serializedLambda.getImplMethodName();
        info2.method = ClassUtils.findMethod(ClassUtils.forName(info2.methodDeclaredClassName), o -> serializedLambda.getCapturedArgCount() == o.getParameterCount() && o.getName().equals(info2.methodName));
        info2.propertyName = LambdaUtils.methodToPropertyName(info2.methodName);
        if (lambda instanceof Function) {
            info2.methodInstanceClassName = StringUtils.substringBefore((String)serializedLambda.getInstantiatedMethodType(), (String)";").substring(2).replaceAll("/", ".");
        } else {
            info2.methodInstanceClassName = lambda.getClass().getDeclaredMethods()[2].getParameterTypes()[0].getName();
        }
        CACHE_LAMBDA_INFO.put(serializedLambda, info2);
        return info2;
    }

    public static SerializedLambda getSerializedLambda(Serializable lambda) {
        return LambdaUtils.computeSerializedLambda(lambda);
    }

    public static Method getLambdaMethod(SerializedLambda lambda) {
        String className = lambda.getImplClass().replaceAll("/", ".");
        String methodName = lambda.getImplMethodName();
        Method method = ClassUtils.findMethod(ClassUtils.forName(className), o -> lambda.getCapturedArgCount() == o.getParameterCount() && o.getName().equals(methodName));
        return method;
    }

    public static Method getLambdaMethod(Serializable lambda) {
        return LambdaUtils.getLambdaMethod(LambdaUtils.getSerializedLambda(lambda));
    }

    public static String getLambdaMethodName(Serializable lambda) {
        return LambdaUtils.getLambdaMethodName(LambdaUtils.computeSerializedLambda(lambda));
    }

    public static String getLambdaMethodName(SerializedLambda lambda) {
        return lambda.getImplMethodName();
    }

    public static String getLambdaPropertyName(Serializable lambda) {
        return LambdaUtils.getLambdaPropertyName(LambdaUtils.computeSerializedLambda(lambda));
    }

    public static String getLambdaPropertyName(SerializedLambda lambda) {
        return LambdaUtils.methodToPropertyName(LambdaUtils.getLambdaMethodName(lambda));
    }

    private static SerializedLambda computeSerializedLambda(Serializable lambda) {
        try {
            Class<?> cl = lambda.getClass();
            Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
            m.setAccessible(true);
            Object replacement = m.invoke((Object)lambda, new Object[0]);
            if (!(replacement instanceof SerializedLambda)) {
                return null;
            }
            return (SerializedLambda)replacement;
        }
        catch (Exception e) {
            throw new ReflectException("get SerializedLambda fail", (Throwable)e);
        }
    }

    private static String methodToPropertyName(String methodName) {
        String name = null;
        name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : methodName);
        if (name != null) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static class SerializedLambdaInfo {
        private String methodName;
        private String methodDeclaredClassName;
        private String methodInstanceClassName;
        private String propertyName;
        private Method method;
        private SerializedLambda serializedLambda;

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDeclaredClassName() {
            return this.methodDeclaredClassName;
        }

        public String getMethodInstanceClassName() {
            return this.methodInstanceClassName;
        }

        public SerializedLambda getSerializedLambda() {
            return this.serializedLambda;
        }

        public Method getMethod() {
            return this.method;
        }

        public String toString() {
            return "SerializedLambdaInfo [methodName=" + this.methodName + ", methodDeclaredClassName=" + this.methodDeclaredClassName + ", methodInstanceClassName=" + this.methodInstanceClassName + ", propertyName=" + this.propertyName + ", method=" + this.method + ", serializedLambda=" + this.serializedLambda + "]";
        }
    }
}

