/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.string;

import cn.featherfly.common.lang.Lang;
import java.util.Map;

public class StringFormatter {
    private char startSymbol;
    private char endSymbol;

    public StringFormatter(char startSymbol, char endSymbol) {
        this.startSymbol = startSymbol;
        this.endSymbol = endSymbol;
    }

    public char getStartSymbol() {
        return this.startSymbol;
    }

    public char getEndSymbol() {
        return this.endSymbol;
    }

    public String format(String str, Object ... args) {
        return this.format(str, this.startSymbol, this.endSymbol, Lang.toMapStringKey(args));
    }

    public String format(String str, Map<String, Object> args) {
        return this.format(str, this.startSymbol, this.endSymbol, args);
    }

    private String format(String str, char startSymbol, char endSymbol, Map<String, Object> args) {
        if (Lang.isEmpty(str)) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str);
        int nameStartIndex = -1;
        int nameEndIndex = -1;
        boolean isEnd = false;
        boolean sameStartEnd = startSymbol == endSymbol;
        for (int index = 0; index < sb.length(); ++index) {
            char c = sb.charAt(index);
            boolean bl = isEnd = index == sb.length() - 1;
            if (nameStartIndex == -1) {
                if (startSymbol == c) {
                    if (!isEnd && sb.charAt(index + 1) == startSymbol) {
                        sb.deleteCharAt(index);
                        continue;
                    }
                    nameStartIndex = index;
                    continue;
                }
                if (c == endSymbol && !isEnd && sb.charAt(index + 1) == endSymbol) {
                    sb.deleteCharAt(index);
                }
            }
            if (nameStartIndex < 0) continue;
            if (startSymbol == c && !sameStartEnd) {
                if (!isEnd && sb.charAt(index + 1) == startSymbol) {
                    sb.deleteCharAt(index);
                    continue;
                }
                nameStartIndex = index;
                continue;
            }
            if (c != endSymbol && !isEnd) continue;
            nameEndIndex = index;
            String name = sb.substring(nameStartIndex + 1, nameEndIndex);
            sb.insert(++nameEndIndex, args.get(name));
            sb.delete(nameStartIndex, nameEndIndex);
            index -= nameEndIndex - nameStartIndex - 1;
            nameStartIndex = -1;
            nameEndIndex = -1;
        }
        return sb.toString();
    }
}

