/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.function.SerializableConsumer;
import cn.featherfly.common.lang.function.SerializableSupplier;
import java.io.Serializable;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.StringUtils;

public class LambdaUtils {
    private static final Map<SerializedLambda, SerializedLambdaInfo> CACHE_LAMBDA_INFO = new ConcurrentHashMap<SerializedLambda, SerializedLambdaInfo>(8);

    public static SerializedLambdaInfo getLambdaInfo(Serializable lambda) {
        SerializedLambda serializedLambda = LambdaUtils.getSerializedLambda(lambda);
        SerializedLambdaInfo info = CACHE_LAMBDA_INFO.get(serializedLambda);
        if (null != info) {
            return info;
        }
        SerializedLambdaInfo info2 = new SerializedLambdaInfo();
        info2.serializedLambda = serializedLambda;
        info2.methodDeclaredClassName = serializedLambda.getImplClass().replaceAll("/", ".");
        info2.methodName = serializedLambda.getImplMethodName();
        info2.propertyName = LambdaUtils.methodToPropertyName(info2.methodName);
        if (lambda instanceof Function || lambda instanceof BiConsumer || lambda instanceof BiFunction) {
            Object[] pts = LambdaUtils.getParamaeterTypes(serializedLambda.getImplMethodSignature());
            info2.method = ClassUtils.getMethod(ClassUtils.forName(info2.methodDeclaredClassName), info2.methodName, pts);
            if (Lang.isEmpty(pts)) {
                info2.propertyType = info2.method.getReturnType();
            } else {
                info2.propertyType = (Class)pts[0];
            }
            info2.methodInstanceClassName = StringUtils.substringBefore((String)serializedLambda.getInstantiatedMethodType(), (String)";").substring(2).replaceAll("/", ".");
        } else if (lambda instanceof Supplier) {
            Class<?> obj = serializedLambda.getCapturedArg(0).getClass();
            info2.methodInstanceClassName = obj.getName();
            info2.method = ClassUtils.getMethod(ClassUtils.forName(info2.methodDeclaredClassName), info2.methodName, ArrayUtils.EMPTY_CLASS_ARRAY);
            info2.propertyType = info2.method.getReturnType();
        } else if (lambda instanceof Consumer) {
            info2.methodInstanceClassName = serializedLambda.getCapturedArg(0).getClass().getName();
            Class<?>[] pts = LambdaUtils.getParamaeterTypes(serializedLambda.getImplMethodSignature());
            info2.method = ClassUtils.getMethod(ClassUtils.forName(info2.methodDeclaredClassName), info2.methodName, pts);
            info2.propertyType = pts[0];
        } else {
            throw new UnsupportedException("unsupported for " + lambda.getClass().getName());
        }
        CACHE_LAMBDA_INFO.put(serializedLambda, info2);
        return info2;
    }

    private static Class<?>[] getParamaeterTypes(String methodSignature) {
        String str = StringUtils.substringAfter((String)methodSignature, (String)"(");
        if (Lang.isEmpty(str = StringUtils.substringBefore((String)str, (String)")"))) {
            return ArrayUtils.EMPTY_CLASS_ARRAY;
        }
        ArrayList types = new ArrayList();
        block0: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == 'L') {
                int start;
                for (int j = start = i + 1; j < str.length(); ++j) {
                    char e = str.charAt(j);
                    if (e != ';') continue;
                    String type = str.substring(start, j);
                    type = type.replaceAll("/", ".");
                    types.add(ClassUtils.forName(type));
                    i = j;
                    continue block0;
                }
                continue;
            }
            if (c == 'I') {
                types.add(Integer.TYPE);
                continue;
            }
            if (c == 'J') {
                types.add(Long.TYPE);
                continue;
            }
            if (c == 'F') {
                types.add(Float.TYPE);
                continue;
            }
            if (c == 'D') {
                types.add(Double.TYPE);
                continue;
            }
            if (c == 'Z') {
                types.add(Boolean.TYPE);
                continue;
            }
            if (c == 'B') {
                types.add(Byte.TYPE);
                continue;
            }
            if (c == 'S') {
                types.add(Short.TYPE);
                continue;
            }
            if (c != 'C') continue;
            types.add(Character.TYPE);
        }
        return types.toArray(new Class[types.size()]);
    }

    public static <T> SerializableSupplierLambdaInfo<T> getSerializableSupplierLambdaInfo(SerializableSupplier<T> lambda) {
        SerializedLambdaInfo info = LambdaUtils.getLambdaInfo(lambda);
        return new SerializableSupplierLambdaInfo(info, (Supplier)lambda);
    }

    public static <T> SerializableConsumerLambdaInfo<T> getSerializableConsumerLambdaInfo(SerializableConsumer<T> lambda) {
        SerializedLambdaInfo info = LambdaUtils.getLambdaInfo(lambda);
        return new SerializableConsumerLambdaInfo(info, (Consumer)lambda);
    }

    public static SerializedLambda getSerializedLambda(Serializable lambda) {
        return LambdaUtils.computeSerializedLambda(lambda);
    }

    public static Method getLambdaMethod(SerializedLambda lambda) {
        String className = lambda.getImplClass().replaceAll("/", ".");
        String methodName = lambda.getImplMethodName();
        Method method = ClassUtils.findMethod(ClassUtils.forName(className), o -> lambda.getCapturedArgCount() == o.getParameterCount() && o.getName().equals(methodName));
        return method;
    }

    public static Method getLambdaMethod(Serializable lambda) {
        return LambdaUtils.getLambdaMethod(LambdaUtils.getSerializedLambda(lambda));
    }

    public static String getLambdaMethodName(Serializable lambda) {
        return LambdaUtils.getLambdaMethodName(LambdaUtils.computeSerializedLambda(lambda));
    }

    public static String getLambdaMethodName(SerializedLambda lambda) {
        return lambda.getImplMethodName();
    }

    public static String getLambdaPropertyName(Serializable lambda) {
        return LambdaUtils.getLambdaPropertyName(LambdaUtils.computeSerializedLambda(lambda));
    }

    public static String getLambdaPropertyName(SerializedLambda lambda) {
        return LambdaUtils.methodToPropertyName(LambdaUtils.getLambdaMethodName(lambda));
    }

    private static SerializedLambda computeSerializedLambda(Serializable lambda) {
        try {
            Class<?> cl = lambda.getClass();
            Method m = cl.getDeclaredMethod("writeReplace", new Class[0]);
            m.setAccessible(true);
            Object replacement = m.invoke((Object)lambda, new Object[0]);
            if (!(replacement instanceof SerializedLambda)) {
                return null;
            }
            return (SerializedLambda)replacement;
        }
        catch (Exception e) {
            throw new ReflectException("get SerializedLambda fail", (Throwable)e);
        }
    }

    private static String methodToPropertyName(String methodName) {
        String name = null;
        name = methodName.startsWith("get") ? methodName.substring(3) : (methodName.startsWith("is") ? methodName.substring(2) : methodName);
        if (name != null) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static class SerializableSupplierLambdaInfo<T>
    extends InstanceLambdaInfo
    implements Supplier<T> {
        private T value;
        private Supplier<T> supplier;
        private boolean init;

        private SerializableSupplierLambdaInfo(SerializedLambdaInfo serializedLambdaInfo, Supplier<T> supplier) {
            super(serializedLambdaInfo, serializedLambdaInfo.getSerializedLambda().getCapturedArg(0));
            this.supplier = supplier;
        }

        public T getValue() {
            if (!this.init) {
                this.value = this.get();
                this.init = true;
            }
            return this.value;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + " [value=" + this.getValue() + ", serializedLambdaInfo=" + this.getSerializedLambdaInfo() + ", instance=" + this.getInstance() + "]";
        }

        @Override
        public T get() {
            return this.supplier.get();
        }
    }

    public static class SerializableConsumerLambdaInfo<T>
    extends InstanceLambdaInfo
    implements Consumer<T> {
        private Consumer<T> consumer;

        private SerializableConsumerLambdaInfo(SerializedLambdaInfo serializedLambdaInfo, Consumer<T> consumer) {
            super(serializedLambdaInfo, serializedLambdaInfo.getSerializedLambda().getCapturedArg(0));
            this.consumer = consumer;
        }

        @Override
        public void accept(T t) {
            this.consumer.accept(t);
        }
    }

    public static abstract class InstanceLambdaInfo {
        private SerializedLambdaInfo serializedLambdaInfo;
        private Object instance;

        public InstanceLambdaInfo(SerializedLambdaInfo serializedLambdaInfo, Object instance) {
            this.serializedLambdaInfo = serializedLambdaInfo;
            this.instance = instance;
        }

        public SerializedLambdaInfo getSerializedLambdaInfo() {
            return this.serializedLambdaInfo;
        }

        public Object getInstance() {
            return this.instance;
        }

        public String toString() {
            return this.getClass().getSimpleName() + " [serializedLambdaInfo=" + this.serializedLambdaInfo + ", instance=" + this.instance + "]";
        }
    }

    public static class SerializedLambdaInfo {
        private String methodName;
        private String methodDeclaredClassName;
        private String methodInstanceClassName;
        private String propertyName;
        private Class<?> propertyType;
        private Method method;
        private SerializedLambda serializedLambda;

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getMethodDeclaredClassName() {
            return this.methodDeclaredClassName;
        }

        public String getMethodInstanceClassName() {
            return this.methodInstanceClassName;
        }

        public SerializedLambda getSerializedLambda() {
            return this.serializedLambda;
        }

        public Method getMethod() {
            return this.method;
        }

        public Class<?> getPropertyType() {
            return this.propertyType;
        }

        public String toString() {
            return "SerializedLambdaInfo [methodName=" + this.methodName + ", methodDeclaredClassName=" + this.methodDeclaredClassName + ", methodInstanceClassName=" + this.methodInstanceClassName + ", propertyName=" + this.propertyName + ", method=" + this.method + ", serializedLambda=" + this.serializedLambda + "]";
        }
    }
}

