/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.lang.matcher.FieldMatcher;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import cn.featherfly.common.lang.reflect.Modifier;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClassUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassUtils.class);
    private static final String DOT = ".";
    private static final String SET = "set";
    private static final String GET = "get";
    private static final String IS = "is";

    private ClassUtils() {
    }

    public static Class<?> forName(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isParent(Class<?> parentType, Class<?> childType) {
        if (parentType == null) {
            return false;
        }
        return parentType.isAssignableFrom(childType);
    }

    public static Class<?> parentClass(Class<?> c1, Class<?> c2) {
        if (c1 == c2) {
            return c1;
        }
        if (c1 == Object.class || c1.isAssignableFrom(c2)) {
            return c1;
        }
        if (c2.isAssignableFrom(c1)) {
            return c2;
        }
        if (c1.isPrimitive() || c2.isPrimitive()) {
            throw new IllegalArgumentException("incompatible types " + c1 + " and " + c2);
        }
        return Object.class;
    }

    private static Field _getField(Class<?> type, String fieldName) {
        try {
            return type.getField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReflectException(e);
        }
    }

    public static Field getField(Class<?> type, String fieldName) {
        try {
            if (fieldName.contains(DOT)) {
                String currentFieldName = fieldName.substring(0, fieldName.indexOf(DOT));
                String innerFieldName = fieldName.substring(fieldName.indexOf(DOT) + 1);
                return ClassUtils.getField(type.getDeclaredField(currentFieldName).getType(), innerFieldName);
            }
            return type.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new ReflectException(e);
        }
    }

    public static Object getFieldValue(Class<?> type, String fieldName) {
        try {
            return ClassUtils.getField(type, fieldName).get(type);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectException(e);
        }
    }

    public static Object getFieldValue(Object object, String fieldName) {
        try {
            return ClassUtils.getField(object.getClass(), fieldName).get(object);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectException(e);
        }
    }

    public static void setFieldValue(Class<?> type, String fieldName, Object value) {
        try {
            ClassUtils.getField(type, fieldName).set(type, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectException(e);
        }
    }

    public static void setFieldValue(Object object, String fieldName, Object value) {
        try {
            ClassUtils.getField(object.getClass(), fieldName).set(object, value);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new ReflectException(e);
        }
    }

    public static Method getMethod(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        try {
            return type.getMethod(methodName, parameterTypes);
        }
        catch (Exception e) {
            throw new ReflectException(e);
        }
    }

    public static Object invokeMethod(Class<?> type, String methodName) {
        return ClassUtils.invokeMethod(type, methodName, new Object[0]);
    }

    public static Object invokeMethod(Class<?> type, String methodName, Object ... args) {
        return ClassUtils.invokeMethod(type, (Method)ClassUtils.match(args, type, true), args);
    }

    public static Object invokeMethod(Class<?> type, Method method, Object ... args) {
        try {
            return method.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static Object invokeMethod(Object object, String methodName) {
        return ClassUtils.invokeMethod(object, methodName, new Object[0]);
    }

    public static Object invokeMethod(Object object, String methodName, Object ... args) {
        return ClassUtils.invokeMethod(object, (Method)ClassUtils.match(args, object.getClass(), true), args);
    }

    public static Object invokeMethod(Object object, Method method, Object ... args) {
        try {
            return method.invoke(object, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new ReflectException(e);
        }
    }

    public static <A1 extends Annotation, A2 extends Annotation> A2 getAnnotation(A1 annotation, Class<A2> annotationPresent) {
        return ClassUtils.getAnnotation(annotation.annotationType(), annotationPresent, false);
    }

    public static <A extends Annotation> A getAnnotation(Class<?> objectType, Class<A> annotationType) {
        return ClassUtils.getAnnotation(objectType, annotationType, true);
    }

    public static <A extends Annotation> A getAnnotation(Class<?> objectType, Class<A> annotationType, boolean fromSuper) {
        if (objectType != null && objectType != Object.class) {
            A a = objectType.getAnnotation(annotationType);
            if (a == null && fromSuper) {
                return ClassUtils.getAnnotation(objectType.getSuperclass(), annotationType, fromSuper);
            }
            return a;
        }
        return null;
    }

    public static <A1 extends Annotation, A2 extends Annotation> A2[] getAnnotations(A1 annotation, Class<A2> annotationPresent) {
        return ClassUtils.getAnnotations(annotation.annotationType(), annotationPresent, (boolean)false);
    }

    public static <A extends Annotation> A[] getAnnotations(Class<?> objectType, Class<A> annotationType) {
        return ClassUtils.getAnnotations(objectType, annotationType, (boolean)true);
    }

    public static <A extends Annotation> A[] getAnnotations(Class<?> objectType, Class<A> annotationType, boolean fromSuper) {
        if (objectType != null && objectType != Object.class) {
            Annotation[] a = objectType.getAnnotationsByType(annotationType);
            if (a == null && fromSuper) {
                return ClassUtils.getAnnotations(objectType.getSuperclass(), annotationType, (boolean)fromSuper);
            }
            return a;
        }
        return null;
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Class<?> objectType, Class<A> annotationType) {
        return ClassUtils.getAnnotatedFields(objectType, annotationType, true);
    }

    public static <A extends Annotation> List<Field> getAnnotatedFields(Class<?> objectType, Class<A> annotationType, boolean fromSuper) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        ClassUtils.getAnnotatedFields(objectType, fieldList, annotationType, fromSuper);
        return fieldList;
    }

    private static <A extends Annotation> void getAnnotatedFields(Class<?> objectType, List<Field> fieldList, Class<A> annotationType, boolean fromSuper) {
        if (objectType != null && objectType != Object.class) {
            Field[] fields;
            for (Field field : fields = objectType.getDeclaredFields()) {
                if (field.getAnnotation(annotationType) == null) continue;
                fieldList.add(field);
            }
            if (fromSuper) {
                ClassUtils.getAnnotatedFields(objectType.getSuperclass(), fieldList, annotationType, fromSuper);
            }
        }
    }

    public static <A extends Annotation> List<Method> getAnnotatedMethods(Class<?> objectType, Class<A> annotationType) {
        Method[] methods;
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Method method : methods = objectType.getMethods()) {
            if (method.getAnnotation(annotationType) == null) continue;
            methodList.add(method);
        }
        return methodList;
    }

    public static String getPropertyName(Method method) {
        String name = null;
        if (ClassUtils.isSetter(method)) {
            name = method.getName().substring(SET.length());
        }
        if (ClassUtils.isGetter(method)) {
            name = method.getName();
            if (name.startsWith(IS)) {
                name = name.substring(IS.length());
            } else if (name.startsWith(GET)) {
                name = name.substring(GET.length());
            }
        }
        if (name != null) {
            name = name.substring(0, 1).toLowerCase() + name.substring(1);
        }
        return name;
    }

    public static boolean isSetter(Method method) {
        String set = SET;
        String name = method.getName();
        return name.startsWith(set) && !set.equals(name) && method.getParameterTypes().length == 1;
    }

    public static boolean isGetter(Method method) {
        String get = GET;
        String is = IS;
        String name = method.getName();
        if (name.startsWith(get) && !get.equals(name) && method.getReturnType() != Void.TYPE && method.getParameterCount() == 0) {
            return true;
        }
        return name.startsWith(is) && !is.equals(name) && method.getReturnType() != Void.TYPE && method.getParameterCount() == 0;
    }

    public static Method getGetter(Field field, Class<?> type) {
        Method method = null;
        String fieldName = field.getName();
        String get = GET + WordUtils.upperCaseFirst(fieldName);
        try {
            method = type.getMethod(get, new Class[0]);
        }
        catch (Exception e) {
            LOGGER.trace("\u6ca1\u6709\u627e\u5230get{}\u65b9\u6cd5, \u4f7f\u7528is{}\u67e5\u627e", (Object)field.getName(), (Object)field.getName());
            try {
                String is = IS + WordUtils.upperCaseFirst(fieldName);
                method = type.getMethod(is, new Class[0]);
            }
            catch (Exception e1) {
                LOGGER.trace("\u6ca1\u6709\u627e\u5230get{}\u548cis{}\u65b9\u6cd5", (Object)field.getName(), (Object)field.getName());
            }
        }
        return method;
    }

    public static Method getSetter(Field field, Class<?> type) {
        Method method = null;
        String fieldName = field.getName();
        String set = SET + WordUtils.upperCaseFirst(fieldName);
        try {
            method = type.getMethod(set, field.getType());
        }
        catch (Exception e) {
            LOGGER.trace("\u6ca1\u6709\u627e\u5230{}\u7684set\u65b9\u6cd5", (Object)field.getName(), (Object)field.getName());
        }
        return method;
    }

    public static boolean isBasicType(Class<?> type) {
        boolean isBasic = false;
        if (type.isPrimitive()) {
            isBasic = true;
        } else if (type == Byte.class) {
            isBasic = true;
        } else if (type == Character.class) {
            isBasic = true;
        } else if (type == Short.class) {
            isBasic = true;
        } else if (type == Integer.class) {
            isBasic = true;
        } else if (type == Long.class) {
            isBasic = true;
        } else if (type == Float.class) {
            isBasic = true;
        } else if (type == Double.class) {
            isBasic = true;
        } else if (type == Boolean.class) {
            isBasic = true;
        } else if (type == Integer.class) {
            isBasic = true;
        } else if (type == Integer.class) {
            isBasic = true;
        } else if (type == String.class) {
            isBasic = true;
        } else if (type == StringBuffer.class) {
            isBasic = true;
        } else if (type == StringBuilder.class) {
            isBasic = true;
        } else if (type == AtomicInteger.class) {
            isBasic = true;
        } else if (type == AtomicLong.class) {
            isBasic = true;
        } else if (type == BigDecimal.class) {
            isBasic = true;
        } else if (type == BigInteger.class) {
            isBasic = true;
        } else if (type == java.util.Date.class) {
            isBasic = true;
        } else if (type == Date.class) {
            isBasic = true;
        } else if (type == Time.class) {
            isBasic = true;
        } else if (type == Timestamp.class) {
            isBasic = true;
        }
        return isBasic;
    }

    public static boolean isCellection(Class<?> type) {
        return ClassUtils.isParent(Collection.class, type);
    }

    public static boolean isMap(Class<?> type) {
        return ClassUtils.isParent(Map.class, type);
    }

    public static boolean isAbstractClass(Class<?> type) {
        return Modifier.ABSTRACT.isModifier(type.getModifiers());
    }

    public static boolean isInstanceClass(Class<?> type) {
        return !ClassUtils.isAbstractClass(type);
    }

    public static <T> Class<T> castGenericType(Class<?> type, T castToType) {
        return type;
    }

    public static File getJar(Class<?> type) {
        return ClassUtils.getJar(type.getName());
    }

    public static File getJar(String className) {
        if (Lang.isEmpty(className)) {
            return null;
        }
        URL url = Thread.currentThread().getContextClassLoader().getResource(ClassUtils.packageToDir(className) + ".class");
        if (url != null && "jar".equalsIgnoreCase(url.getProtocol())) {
            String os;
            String excalmatoryMark = "!";
            String filePrefix = "file:";
            String path = url.getPath();
            url.getProtocol();
            path = path.startsWith(filePrefix) ? ((os = System.getProperty("os.name")).startsWith("Windows") ? StringUtils.substringBetween((String)path, (String)"file:/", (String)excalmatoryMark) : (os.startsWith("Linux") ? StringUtils.substringBetween((String)path, (String)filePrefix, (String)excalmatoryMark) : StringUtils.substringBetween((String)path, (String)filePrefix, (String)excalmatoryMark))) : StringUtils.substringBefore((String)path, (String)excalmatoryMark);
            return new File(path);
        }
        return null;
    }

    public static String packageToFile(Class<?> type) {
        if (type == null) {
            return null;
        }
        return ClassUtils.packageToFile(type, true);
    }

    public static String packageToFile(Class<?> type, boolean containExt) {
        if (type == null) {
            return null;
        }
        if (containExt) {
            return ClassUtils.packageToDir(type.getName()) + ".class";
        }
        return ClassUtils.packageToDir(type.getName());
    }

    public static String packageToDir(Class<?> type) {
        if (type == null) {
            return null;
        }
        return ClassUtils.packageToDir(type.getPackage());
    }

    public static String packageToDir(Package pack) {
        if (pack == null) {
            return null;
        }
        return ClassUtils.packageToDir(pack.getName());
    }

    public static String packageToDir(String packageString) {
        if (Lang.isEmpty(packageString)) {
            return null;
        }
        return packageString.replace(DOT, "/");
    }

    @Deprecated
    public static <T> Class<T> getSuperClassGenricType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    @Deprecated
    public static <T> Class<T> getSuperClassGenricType(Class<?> clazz) {
        return ClassUtils.getSuperClassGenricType(clazz, 0);
    }

    @Deprecated
    public static Map<String, Type> getSuperClassGenricTypeMap(Class<?> clazz) {
        HashMap<String, Type> typeGenericParams = new HashMap<String, Type>(0);
        Type genType = clazz.getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genType;
            Type[] types = pt.getActualTypeArguments();
            TypeVariable<Class<?>>[] tvs = clazz.getSuperclass().getTypeParameters();
            for (int i = 0; i < types.length; ++i) {
                typeGenericParams.put(tvs[i].getName(), types[i]);
            }
        }
        return typeGenericParams;
    }

    public static <T> Class<T> getSuperClassGenericType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        if (!(params[index] instanceof Class)) {
            return Object.class;
        }
        return (Class)params[index];
    }

    public static <T> Class<T> getSuperClassGenericType(Class<?> clazz) {
        return ClassUtils.getSuperClassGenericType(clazz, 0);
    }

    public static Map<String, Type> getSuperClassGenericTypeMap(Class<?> clazz) {
        HashMap<String, Type> typeGenericParams = new HashMap<String, Type>(0);
        Type genType = clazz.getGenericSuperclass();
        if (genType instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genType;
            Type[] types = pt.getActualTypeArguments();
            TypeVariable<Class<?>>[] tvs = clazz.getSuperclass().getTypeParameters();
            for (int i = 0; i < types.length; ++i) {
                typeGenericParams.put(tvs[i].getName(), types[i]);
            }
        }
        return typeGenericParams;
    }

    public static Map<Class<?>, Map<String, Type>> getSuperClassAllGenericTypeMap(Class<?> clazz) {
        return ClassUtils.getSuperClassAllGenericTypeMap(clazz, new HashMap());
    }

    private static Map<Class<?>, Map<String, Type>> getSuperClassAllGenericTypeMap(Class<?> clazz, Map<Class<?>, Map<String, Type>> typeGenericMap) {
        if (clazz.getSuperclass() == Object.class) {
            return typeGenericMap;
        }
        typeGenericMap.put(clazz.getSuperclass(), ClassUtils.getSuperClassGenericTypeMap(clazz));
        return ClassUtils.getSuperClassAllGenericTypeMap(clazz.getSuperclass(), typeGenericMap);
    }

    public static <T> Class<T> getInterfaceGenericType(Class<?> clazz, int index, Class<?> interfaceType) {
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != interfaceType) continue;
            Type[] params = parameterizedType.getActualTypeArguments();
            if (index >= params.length || index < 0) {
                throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
            }
            if (!(params[index] instanceof Class)) {
                return Object.class;
            }
            return (Class)params[index];
        }
        return Object.class;
    }

    public static <T> Class<T> getInterfaceGenericType(Class<?> clazz, Class<?> interfaceType) {
        return ClassUtils.getInterfaceGenericType(clazz, 0, interfaceType);
    }

    public static Map<String, Type> getInterfaceGenericTypeMap(Class<?> clazz, Class<?> interfaceType) {
        HashMap<String, Type> typeGenericParams = new HashMap<String, Type>(0);
        for (Type type : clazz.getGenericInterfaces()) {
            ParameterizedType parameterizedType;
            if (!(type instanceof ParameterizedType) || (parameterizedType = (ParameterizedType)type).getRawType() != interfaceType) continue;
            Type[] types = parameterizedType.getActualTypeArguments();
            TypeVariable<Class<?>>[] tvs = interfaceType.getTypeParameters();
            for (int i = 0; i < types.length; ++i) {
                typeGenericParams.put(tvs[i].getName(), types[i]);
            }
        }
        return typeGenericParams;
    }

    public static Map<Class<?>, Map<String, Type>> getInterfaceGenericTypeMap(Class<?> clazz) {
        HashMap result = new HashMap();
        for (Class<?> interfaceType : clazz.getInterfaces()) {
            result.put(interfaceType, ClassUtils.getInterfaceGenericTypeMap(clazz, interfaceType));
        }
        return result;
    }

    public static <T> Class<T> getMethodReturnType(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodReturnType(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static <T> Class<T> getMethodReturnType(Class<?> type, Method method) {
        return ClassUtils.getGenericInstanceType(type, method.getGenericReturnType());
    }

    public static <T> Class<T> getMethodReturnTypeGenericParameterType(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodReturnTypeGenericParameterType(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static <T> Class<T> getMethodReturnTypeGenericParameterType(Class<?> type, Method method) {
        return ClassUtils.getMethodReturnTypeGenericParameterType(type, method, 0);
    }

    public static <T> Class<T> getMethodReturnTypeGenericParameterType(Class<?> type, Method method, int index) {
        return ClassUtils.getGenericParameterType(type, method.getGenericReturnType(), index);
    }

    public static List<Class<?>> getMethodReturnTypeGenericParameterTypes(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodReturnTypeGenericParameterTypes(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static List<Class<?>> getMethodReturnTypeGenericParameterTypes(Class<?> type, Method method) {
        return ClassUtils.getGenericParameterTypes(type, method.getGenericReturnType());
    }

    public static <T> Class<T> getMethodParameterType(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodParameterType(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static <T> Class<T> getMethodParameterType(Class<?> type, Method method) {
        return ClassUtils.getMethodParameterType(type, method, 0);
    }

    public static <T> Class<T> getMethodParameterType(Class<?> type, Method method, int paramIndex) {
        Parameter[] ps = method.getParameters();
        if (paramIndex >= ps.length || paramIndex < 0) {
            throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (paramIndex < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570" + ps.length));
        }
        Parameter p = ps[paramIndex];
        return ClassUtils.getGenericInstanceType(type, p.getParameterizedType(), p.getType());
    }

    public static List<Class<?>> getMethodParameterTypes(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodParameterTypes(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static List<Class<?>> getMethodParameterTypes(Class<?> type, Method method) {
        ArrayList types = new ArrayList();
        for (Parameter p : method.getParameters()) {
            types.add(ClassUtils.getGenericInstanceType(type, p.getParameterizedType(), p.getType()));
        }
        return types;
    }

    public static Class<?> getMethodGenericParameterType(Class<?> type, String methodName, Class<?> ... parameterTypes) {
        return ClassUtils.getMethodGenericParameterType(type, ClassUtils.getMethod(type, methodName, parameterTypes));
    }

    public static Class<?> getMethodGenericParameterType(Class<?> type, Method method) {
        return ClassUtils.getMethodGenericParameterType(type, method, 0);
    }

    public static Class<?> getMethodGenericParameterType(Class<?> type, Method method, int index) {
        return ClassUtils.getMethodGenericParameterType(type, method, index, 0);
    }

    public static <T> Class<T> getMethodGenericParameterType(Class<?> type, Method method, int paramIndex, int genericTypeIndex) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (paramIndex >= genericParameterTypes.length || paramIndex < 0) {
            throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (paramIndex < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570" + genericParameterTypes.length));
        }
        return ClassUtils.getGenericParameterType(type, genericParameterTypes[paramIndex], genericTypeIndex);
    }

    public static List<List<Class<?>>> getMethodGenericParameterTypesAll(Class<?> type, Method method) {
        ArrayList list = new ArrayList();
        for (int i = 0; i < method.getParameters().length; ++i) {
            list.add(ClassUtils.getMethodGenericParameterTypes(type, method, i));
        }
        return list;
    }

    public static List<Class<?>> getMethodGenericParameterTypes(Class<?> type, Method method) {
        return ClassUtils.getMethodGenericParameterTypes(type, method, 0);
    }

    public static List<Class<?>> getMethodGenericParameterTypes(Class<?> type, Method method, int index) {
        Type[] genericParameterTypes = method.getGenericParameterTypes();
        if (index >= genericParameterTypes.length || index < 0) {
            throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u53c2\u6570\u7684\u603b\u6570"));
        }
        Type genericParameterType = genericParameterTypes[index];
        return ClassUtils.getGenericParameterTypes(type, genericParameterType);
    }

    public static <T> Class<T> getFieldType(Class<?> type, String fieldName) {
        return ClassUtils.getFieldType(type, ClassUtils._getField(type, fieldName));
    }

    public static <T> Class<T> getFieldType(Class<?> type, Field field) {
        return ClassUtils.getGenericInstanceType(type, field.getGenericType());
    }

    public static <T> Class<T> getFieldGenericParameterType(Class<?> type, String fieldName) {
        return ClassUtils.getFieldGenericParameterType(type, ClassUtils._getField(type, fieldName));
    }

    public static <T> Class<T> getFieldGenericParameterType(Class<?> type, String fieldName, int index) {
        return ClassUtils.getFieldGenericParameterType(type, ClassUtils._getField(type, fieldName), index);
    }

    public static <T> Class<T> getFieldGenericParameterType(Class<?> type, Field field) {
        return ClassUtils.getFieldGenericParameterType(type, field, 0);
    }

    public static <T> Class<T> getFieldGenericParameterType(Class<?> type, Field field, int index) {
        return ClassUtils.getGenericParameterType(type, field.getGenericType(), index);
    }

    public static List<Class<?>> getFieldGenericParameterTypes(Class<?> type, String fieldName) {
        return ClassUtils.getFieldGenericParameterTypes(type, ClassUtils._getField(type, fieldName));
    }

    public static List<Class<?>> getFieldGenericParameterTypes(Class<?> type, Field field) {
        return ClassUtils.getGenericParameterTypes(type, field.getGenericType());
    }

    private static <T> Class<T> getGenericInstanceType(Class<?> clazz, TypeVariable<?> typeVariable) {
        if (typeVariable.getGenericDeclaration() instanceof Class) {
            return ClassUtils.getGenericInstanceType(clazz, (Class)typeVariable.getGenericDeclaration(), typeVariable.getName());
        }
        if (typeVariable.getGenericDeclaration() instanceof Method) {
            return (Class)typeVariable.getBounds()[0];
        }
        if (typeVariable.getGenericDeclaration() instanceof Constructor) {
            return (Class)typeVariable.getBounds()[0];
        }
        return Object.class;
    }

    private static <T> Class<T> getGenericInstanceType(Class<?> clazz, Class<?> genericInstanceType, String genericName) {
        if (clazz == Object.class) {
            return Object.class;
        }
        if (clazz == genericInstanceType) {
            for (TypeVariable<Class<?>> tv : clazz.getTypeParameters()) {
                if (!genericName.equals(tv.getName())) continue;
                return (Class)tv.getBounds()[0];
            }
        }
        Type result = null;
        Map<String, Type> genericMap = null;
        if (clazz.getSuperclass() == genericInstanceType) {
            genericMap = ClassUtils.getSuperClassGenericTypeMap(clazz);
            result = genericMap.get(genericName);
        }
        if (result == null && (genericMap = ClassUtils.getInterfaceGenericTypeMap(clazz).get(genericInstanceType)) != null) {
            result = genericMap.get(genericName);
        }
        if (result == null) {
            return ClassUtils.getGenericInstanceType(clazz.getSuperclass(), genericInstanceType, genericName);
        }
        return ClassUtils.forName(result.getTypeName());
    }

    private static <T> Class<T> getGenericInstanceType(Class<?> clazz, Type type, Class<?> defaultType) {
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (tv.getGenericDeclaration() instanceof Class) {
                return ClassUtils.getGenericInstanceType(clazz, (Class)tv.getGenericDeclaration(), tv.getName());
            }
            if (tv.getGenericDeclaration() instanceof Method) {
                return (Class)tv.getBounds()[0];
            }
            if (tv.getGenericDeclaration() instanceof Constructor) {
                return (Class)tv.getBounds()[0];
            }
        } else {
            if (type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                return (Class)pt.getRawType();
            }
            if (type instanceof Class) {
                return (Class)type;
            }
        }
        return defaultType;
    }

    private static <T> Class<T> getGenericInstanceType(Class<?> clazz, Type type) {
        return ClassUtils.getGenericInstanceType(clazz, type, Object.class);
    }

    private static <T> Class<T> getGenericParameterType(Class<?> clazz, Type type, int index) {
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type[] fieldArgTypes = pt.getActualTypeArguments();
            if (index >= fieldArgTypes.length || index < 0) {
                throw new IllegalArgumentException("\u4f60\u8f93\u5165\u7684\u7d22\u5f15" + (index < 0 ? "\u4e0d\u80fd\u5c0f\u4e8e0" : "\u8d85\u51fa\u4e86\u6cdb\u578b\u53c2\u6570\u7684\u603b\u6570" + fieldArgTypes.length));
            }
            Type genericType = fieldArgTypes[index];
            if (genericType instanceof Class) {
                return (Class)genericType;
            }
            if (genericType instanceof WildcardType) {
                WildcardType w = (WildcardType)genericType;
                if (Lang.isNotEmpty(w.getLowerBounds())) {
                    return (Class)w.getLowerBounds()[0];
                }
                if (Lang.isNotEmpty(w.getUpperBounds())) {
                    return (Class)w.getUpperBounds()[0];
                }
            } else if (genericType instanceof TypeVariable) {
                TypeVariable tv = (TypeVariable)genericType;
                return ClassUtils.getGenericInstanceType(clazz, tv);
            }
        }
        return Object.class;
    }

    private static List<Class<?>> getGenericParameterTypes(Class<?> clazz, Type type) {
        ArrayList results = new ArrayList();
        if (type instanceof ParameterizedType) {
            Type[] fieldArgTypes;
            ParameterizedType aType = (ParameterizedType)type;
            for (Type genericType : fieldArgTypes = aType.getActualTypeArguments()) {
                if (genericType instanceof Class) {
                    results.add((Class)genericType);
                    continue;
                }
                if (genericType instanceof WildcardType) {
                    WildcardType w = (WildcardType)genericType;
                    if (Lang.isNotEmpty(w.getLowerBounds())) {
                        results.add((Class)w.getLowerBounds()[0]);
                        continue;
                    }
                    if (!Lang.isNotEmpty(w.getUpperBounds())) continue;
                    results.add((Class)w.getUpperBounds()[0]);
                    continue;
                }
                if (!(genericType instanceof TypeVariable)) continue;
                results.add(ClassUtils.getGenericInstanceType(clazz, (TypeVariable)genericType));
            }
        }
        return results;
    }

    public static <T> T newInstance(Class<T> clazz) {
        AssertIllegalArgument.isNotNull(clazz, "Class<T> clazz");
        AssertIllegalArgument.isNotInterface(clazz);
        try {
            return clazz.newInstance();
        }
        catch (InstantiationException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format("{0} \u6784\u9020\u5668\u662f\u5426\u4e3a\u79c1\u6709", new Object[]{clazz.getName()}));
        }
        catch (IllegalAccessException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format("{0} \u6784\u9020\u5668\u53c2\u6570\u4e0d\u5339\u914d", new Object[]{clazz.getName()}));
        }
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        AssertIllegalArgument.isNotNull(clazz, "Class<T> clazz");
        if (Lang.isNotEmpty(args)) {
            Constructor matchConstructor = (Constructor)ClassUtils.match(args, clazz, false);
            return ClassUtils.newInstance(matchConstructor, args);
        }
        return ClassUtils.newInstance(clazz);
    }

    private static <E extends Executable> E match(Object[] args, Class<?> type, boolean isMethod) {
        int i;
        Class<?>[] paramTypes;
        boolean matchAllParamType;
        ArrayList<Executable> matchs = new ArrayList<Executable>();
        if (isMethod) {
            for (Executable executable : type.getMethods()) {
                if (((Method)executable).getParameterCount() != args.length) continue;
                matchs.add(executable);
            }
        } else {
            for (Executable executable : type.getConstructors()) {
                if (((Constructor)executable).getParameterCount() != args.length) continue;
                matchs.add(executable);
            }
        }
        Class[] arguTypes = new Class[args.length];
        for (int i2 = 0; i2 < args.length; ++i2) {
            arguTypes[i2] = args[i2].getClass();
        }
        Executable matchExecutable = null;
        for (Executable executable : matchs) {
            matchAllParamType = true;
            paramTypes = executable.getParameterTypes();
            for (i = 0; i < arguTypes.length; ++i) {
                if (paramTypes[i] == arguTypes[i]) continue;
                matchAllParamType = false;
                break;
            }
            if (!matchAllParamType) continue;
            matchExecutable = executable;
            break;
        }
        if (matchExecutable == null) {
            for (Executable executable : matchs) {
                matchAllParamType = true;
                paramTypes = executable.getParameterTypes();
                for (i = 0; i < arguTypes.length; ++i) {
                    if (ClassUtils.isParent(paramTypes[i], arguTypes[i])) continue;
                    matchAllParamType = false;
                    break;
                }
                if (!matchAllParamType) continue;
                matchExecutable = executable;
                break;
            }
        }
        if (matchExecutable == null) {
            throw new ReflectException(Strings.format("{0}({1}) \u6b64{2}\u4e0d\u5b58\u5728", type.getName(), Arrays.asList(arguTypes).toString(), isMethod ? "\u65b9\u6cd5" : "\u6784\u9020\u5668"));
        }
        return (E)matchExecutable;
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        AssertIllegalArgument.isNotNull(constructor, "Constructor<T> constructor");
        if (!java.lang.reflect.Modifier.isPublic(constructor.getModifiers()) || !java.lang.reflect.Modifier.isPublic(constructor.getDeclaringClass().getModifiers())) {
            constructor.setAccessible(true);
        }
        try {
            return constructor.newInstance(args);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format(" {0} \u662f\u5426\u5b9a\u4e49\u6210\u62bd\u8c61\u7c7b\u4e86 \u4e0d\u80fd\u5b9e\u4f8b\u5316", (Object)constructor.getDeclaringClass().getName()));
        }
        catch (InstantiationException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format("{0} \u6784\u9020\u5668\u662f\u5426\u4e3a\u79c1\u6709", (Object)constructor.getDeclaringClass().getName()));
        }
        catch (IllegalAccessException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format("{0} \u6784\u9020\u5668\u53c2\u6570\u4e0d\u5339\u914d", (Object)constructor.getDeclaringClass().getName()));
        }
        catch (InvocationTargetException e) {
            LOGGER.debug(ExceptionUtils.getStackTrace((Throwable)e));
            throw new ReflectException(Strings.format("{0} \u6784\u9020\u5668\u629b\u51fa\u5f02\u5e38", (Object)constructor.getDeclaringClass().getName()));
        }
    }

    public static Field findField(Class<?> type, FieldMatcher matcher) {
        if (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (!matcher.match(field)) continue;
                return field;
            }
        }
        return null;
    }

    public static Collection<Field> findFields(Class<?> type, FieldMatcher matcher) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (type != null) {
            for (Field field : type.getDeclaredFields()) {
                if (!matcher.match(field)) continue;
                fields.add(field);
            }
        }
        return fields;
    }

    public static Method findMethod(Class<?> type, MethodMatcher matcher) {
        if (type != null) {
            for (Method method : type.getDeclaredMethods()) {
                if (!matcher.match(method)) continue;
                return method;
            }
        }
        return null;
    }

    public static Collection<Method> findMethods(Class<?> type, MethodMatcher matcher) {
        ArrayList<Method> methods = new ArrayList<Method>();
        if (type != null) {
            for (Method method : type.getDeclaredMethods()) {
                if (!matcher.match(method)) continue;
                methods.add(method);
            }
        }
        return methods;
    }

    public static Class<?> getPrimitiveWrapped(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
            if (type == Void.TYPE) {
                return Void.class;
            }
        }
        return type;
    }

    public static String getPrimitiveClassValueMethodName(Class<?> type) {
        if (type == Boolean.TYPE || type == Boolean.class) {
            return "booleanValue";
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return "byteValue";
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return "intValue";
        }
        if (type == Long.TYPE || type == Long.class) {
            return "longValue";
        }
        if (type == Float.TYPE || type == Float.class) {
            return "floatValue";
        }
        if (type == Double.TYPE || type == Double.class) {
            return "doubleValue";
        }
        if (type == Character.TYPE || type == Character.class) {
            return "charValue";
        }
        if (type == Short.TYPE || type == Short.class) {
            return "shortValue";
        }
        return null;
    }

    public static Type getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            return parameterizedType.getRawType();
        }
        return type;
    }
}

