/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io.file.rename;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.io.file.RenamePolicy;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import org.apache.commons.lang3.StringUtils;

public class VersionRenamePolicy
implements RenamePolicy {
    private String version;

    public VersionRenamePolicy(String version) {
        AssertIllegalArgument.isNotEmpty(version, "version");
        this.version = version;
    }

    @Override
    public String rename(String fileName) {
        String extName = FileUtils.getFileExtName(fileName);
        String name = StringUtils.substringBeforeLast((String)extName, (String)".");
        if (Lang.isNotEmpty(extName)) {
            return name + "-" + this.version + "." + extName;
        }
        return name + "-" + this.version;
    }

    public String getVersion() {
        return this.version;
    }
}

