/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io;

import cn.featherfly.common.exception.IOException;
import cn.featherfly.common.io.WatchListener;
import cn.featherfly.common.lang.LogUtils;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Watcher {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private WatchListener listener;
    private Path directory;
    private WatchKey watchKey;
    private WatchEvent.Kind<?>[] events;

    public Watcher() {
    }

    public Watcher(Path directory, WatchListener listener, WatchEvent.Kind<?> ... events) {
        this.listener = listener;
        this.directory = directory;
        this.events = events;
    }

    public WatchListener getListener() {
        return this.listener;
    }

    public void setListener(WatchListener listener) {
        this.listener = listener;
    }

    public Path getDirectory() {
        return this.directory;
    }

    public void setDirectory(Path directory) {
        this.directory = directory;
    }

    public WatchEvent.Kind<?>[] getEvents() {
        return this.events;
    }

    public void setEvents(WatchEvent.Kind<?>[] events) {
        this.events = events;
    }

    public void watch() {
        try {
            WatchService watchService = FileSystems.getDefault().newWatchService();
            this.directory.register(watchService, this.events);
            Thread thread = new Thread(() -> {
                try {
                    while (true) {
                        this.watchKey = watchService.take();
                        List<WatchEvent<?>> watchEvents = this.watchKey.pollEvents();
                        for (WatchEvent<Path> watchEvent : watchEvents) {
                            this.listener.onEvent(watchEvent, this.directory);
                        }
                        this.watchKey.reset();
                    }
                }
                catch (InterruptedException e) {
                    LogUtils.error(e, this.logger);
                    return;
                }
            });
            thread.setDaemon(false);
            thread.start();
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    watchService.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }));
        }
        catch (java.io.IOException e) {
            throw new IOException(e);
        }
    }
}

