/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.number;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.number.LocaleNumber;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class ChineseNumber
implements LocaleNumber {
    private boolean simple = false;
    private static final String[] GROUP_UNITS = new String[]{"", "\u4e07", "\u4ebf", "\u5146", "\u4eac", "\u5793", "\u677c", "\u7a70", "\u6c9f", "\u6da7", "\u6b63", "\u8f7d", "\u6781"};
    private static final String[] SIMPLE_CHINESE_UNITS = new String[]{"", "\u5341", "\u767e", "\u5343"};
    private static final String[] TRADITIONAL_CHINESE_UNITS = new String[]{"", "\u62fe", "\u4f70", "\u4edf"};
    private static final String[] SIMPLE_CHINESE_NUMBERS = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d"};
    private static final String[] TRADITIONAL_CHINESE_NUMBERS = new String[]{"\u96f6", "\u58f9", "\u8d30", "\u53c1", "\u8086", "\u4f0d", "\u9646", "\u67d2", "\u634c", "\u7396"};
    private static final String YUAN = "\u5706";
    private static final String JIAO = "\u89d2";
    private static final String FEN = "\u5206";
    private static final String ZHENG = "\u6574";

    public ChineseNumber() {
        this(false);
    }

    public ChineseNumber(boolean simple) {
        this.simple = simple;
    }

    public String getGroupUnit(int groupPosition) {
        AssertIllegalArgument.isLt(groupPosition, GROUP_UNITS.length, "groupPosition");
        return GROUP_UNITS[groupPosition];
    }

    public String getUnit(int position) {
        AssertIllegalArgument.isLt(position, SIMPLE_CHINESE_UNITS.length, "position");
        if (this.simple) {
            return SIMPLE_CHINESE_UNITS[position];
        }
        return TRADITIONAL_CHINESE_UNITS[position];
    }

    public String getChineseNumber(int number) {
        AssertIllegalArgument.isLt(number, SIMPLE_CHINESE_NUMBERS.length, "number");
        if (this.simple) {
            return SIMPLE_CHINESE_NUMBERS[number];
        }
        return TRADITIONAL_CHINESE_NUMBERS[number];
    }

    private String toChineseNumber(String number) {
        if (LangUtils.isEmpty(number)) {
            return "";
        }
        String result = "";
        int groupSize = 4;
        int groupAmount = (number.length() - 1) / groupSize + 1;
        int start = -1;
        int end = -1;
        for (int groupNo = 0; groupNo < groupAmount; ++groupNo) {
            String groupUnit = this.getGroupUnit(groupAmount - groupNo - 1);
            if (start == -1) {
                start = 0;
            }
            if (end == -1) {
                end = number.length() - groupSize * (groupAmount - groupNo - 1);
            }
            int pre = -1;
            while (start < end) {
                String unit = this.getUnit(end - start - 1);
                int num = number.charAt(start) - 48;
                if (!((start + 1) % groupSize == 0 && groupNo == groupAmount - 1 && num == 0 || num == 0 && pre == 0)) {
                    result = result + this.getChineseNumber(num);
                }
                if (num != 0) {
                    result = result + unit;
                }
                pre = num;
                ++start;
            }
            while (result.length() > 1 && result.endsWith(this.getChineseNumber(0))) {
                result = result.substring(0, result.length() - 1);
            }
            result = result + groupUnit;
            start = end;
            end = start + groupSize;
        }
        return result;
    }

    @Override
    public String toNumberWord(int number) {
        return this.toChineseNumber(String.valueOf(number));
    }

    @Override
    public String toNumberWord(long number) {
        return this.toChineseNumber(String.valueOf(number));
    }

    @Override
    public String toMoneyNumberWord(double number) {
        BigDecimal value = BigDecimal.valueOf(number);
        String money = this.toNumberWord(value.longValue());
        money = money + YUAN;
        if (value.scale() != 0) {
            if (value.scale() == 1) {
                String scaleValue = StringUtils.substringAfter((String)value.toString(), (String)".");
                if (Integer.valueOf(scaleValue) != 0) {
                    money = money + this.toChineseNumber(scaleValue) + JIAO;
                }
            } else if (value.scale() == 2) {
                String scaleValue = StringUtils.substringAfter((String)value.toString(), (String)".");
                money = money + this.toChineseNumber(scaleValue.substring(0, 1)) + JIAO;
                money = money + this.toChineseNumber(scaleValue.substring(1, 2)) + FEN;
            }
        }
        money = money + ZHENG;
        return money;
    }
}

