/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.matcher;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodParamTypeMatcher
implements MethodMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodParamTypeMatcher.class);
    private Class<?>[] parameterTypes;
    private boolean matchSubType;

    public MethodParamTypeMatcher(Class<?> ... parameterTypes) {
        this.parameterTypes = parameterTypes;
    }

    @Override
    public boolean match(Method method) {
        if (LangUtils.isEmpty(this.parameterTypes) || method == null) {
            return false;
        }
        Class<?>[] types = method.getParameterTypes();
        if (this.parameterTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (!(this.matchSubType ? !ClassUtils.isParent(this.parameterTypes[i], types[i]) : !types[i].equals(this.parameterTypes[i]))) continue;
            return false;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("parameterTypes {} match {} ", (Object)ArrayUtils.toString(this.parameterTypes), (Object)ArrayUtils.toString(types));
        }
        return true;
    }
}

