/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.AssertIllegalArgument;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 7;
    public static final int COMPARE_LT = -1;
    public static final int COMPARE_EQ = 0;
    public static final int COMPARE_GT = 1;
    private static final String FORMART_DATE = "yyyy-MM-dd";
    private static final String FORMART_TIME = "yyyy-MM-dd HH:mm:ss";
    private static final String MSG_START_AFTER_END = "\u5f00\u59cb\u65e5\u671fstartDate\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671fendDate";

    private DateUtils() {
    }

    public static String formartDate(Date date) {
        return DateUtils.formart(date, FORMART_DATE);
    }

    public static String formartTime(Date date) {
        return DateUtils.formart(date, FORMART_TIME);
    }

    public static String formart(Date date, String formart) {
        LOGGER.debug("formartDate: formart={} ||| date={}", new Object[]{formart, date});
        if (date != null) {
            SimpleDateFormat format = new SimpleDateFormat(formart);
            return format.format(date);
        }
        return "";
    }

    public static Date parseDate(String strDate) {
        return DateUtils.parse(strDate, FORMART_DATE);
    }

    public static Date parseTime(String strDate) {
        return DateUtils.parse(strDate, FORMART_TIME);
    }

    public static Date parse(String strDate, String formart) {
        LOGGER.debug("parse: formart={} ||| strDate={}", new Object[]{formart, strDate});
        AssertIllegalArgument.isNotBlank(strDate, "String strDate");
        AssertIllegalArgument.isNotBlank(formart, "String formart");
        SimpleDateFormat format = new SimpleDateFormat(formart);
        try {
            return format.parse(strDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Date parse(String strDate) {
        LOGGER.debug("parse: strDate={}", (Object)strDate);
        AssertIllegalArgument.isNotBlank(strDate, "String strDate");
        return new Date(strDate);
    }

    public static Date getDate(int year, int month, int day) {
        Calendar c = Calendar.getInstance();
        c.set(year, DateUtils.toDateMonth(month), day);
        return c.getTime();
    }

    public static Date getTime(int year, int month, int day, int hour, int minute, int second) {
        Calendar c = Calendar.getInstance();
        c.set(year, DateUtils.toDateMonth(month), day, hour, minute, second);
        return c.getTime();
    }

    public static int getCurrentYear() {
        Calendar c = Calendar.getInstance();
        return c.get(1);
    }

    public static int getCurrentMonth() {
        Calendar c = Calendar.getInstance();
        return DateUtils.fromDateMonth(c.get(2));
    }

    public static int getCurrentDayOfMonth() {
        Calendar c = Calendar.getInstance();
        return c.get(5);
    }

    public static int getCurrentDayOfWeek() {
        Calendar c = Calendar.getInstance();
        return c.get(7);
    }

    public static int getCurrentHour() {
        Calendar c = Calendar.getInstance();
        return c.get(11);
    }

    public static int getCurrentMinute() {
        Calendar c = Calendar.getInstance();
        return c.get(12);
    }

    public static int getCurrentSecond() {
        Calendar c = Calendar.getInstance();
        return c.get(13);
    }

    public static int getYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(1);
    }

    public static int getMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateUtils.fromDateMonth(c.get(2));
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int dayOfWeek = c.get(7);
        dayOfWeek = dayOfWeek == 1 ? 7 : --dayOfWeek;
        return dayOfWeek;
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(6);
    }

    public static int getWeekOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        return c.get(3);
    }

    public static int getHour(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(11);
    }

    public static int getMinute(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(12);
    }

    public static int getSecond(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(13);
    }

    public static long getTime(Date date, TimeType type) {
        long result = 0L;
        if (date != null) {
            switch (type) {
                case millisecond: {
                    result = date.getTime();
                    break;
                }
                case second: {
                    result = date.getTime() / 1000L;
                    break;
                }
                case minute: {
                    result = date.getTime() / 1000L / 60L;
                    break;
                }
                case hour: {
                    result = date.getTime() / 1000L / 60L / 60L;
                    break;
                }
                case day: {
                    result = date.getTime() / 1000L / 60L / 60L / 24L;
                    break;
                }
                default: {
                    result = date.getTime();
                }
            }
        }
        return result;
    }

    public static int compareYear(Date firstDate, Date secondDate) {
        String formart = "yyyy";
        return DateUtils.compare(firstDate, secondDate, "yyyy");
    }

    public static int compareMonth(Date firstDate, Date secondDate) {
        String formart = "yyyyMM";
        return DateUtils.compare(firstDate, secondDate, "yyyyMM");
    }

    public static int compareDay(Date firstDate, Date secondDate) {
        String formart = "yyyyMMdd";
        return DateUtils.compare(firstDate, secondDate, "yyyyMMdd");
    }

    public static int compareHour(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHH";
        return DateUtils.compare(firstDate, secondDate, "yyyyMMddHH");
    }

    public static int compareMinute(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHHmm";
        return DateUtils.compare(firstDate, secondDate, "yyyyMMddHHmm");
    }

    public static int compareSecond(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHHmmss";
        return DateUtils.compare(firstDate, secondDate, "yyyyMMddHHmmss");
    }

    public static boolean beforeYear(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareYear(firstDate, secondDate);
    }

    public static boolean equalsYear(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareYear(firstDate, secondDate);
    }

    public static boolean afterYear(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareYear(firstDate, secondDate);
    }

    public static boolean beforeMonth(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareMonth(firstDate, secondDate);
    }

    public static boolean equalsMonth(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareMonth(firstDate, secondDate);
    }

    public static boolean afterMonth(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareMonth(firstDate, secondDate);
    }

    public static boolean beforeDay(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareDay(firstDate, secondDate);
    }

    public static boolean equalsDay(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareDay(firstDate, secondDate);
    }

    public static boolean afterDay(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareDay(firstDate, secondDate);
    }

    public static boolean beforeHour(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareHour(firstDate, secondDate);
    }

    public static boolean equalsHour(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareHour(firstDate, secondDate);
    }

    public static boolean afterHour(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareHour(firstDate, secondDate);
    }

    public static boolean beforeMinute(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareMinute(firstDate, secondDate);
    }

    public static boolean equalsMinute(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareMinute(firstDate, secondDate);
    }

    public static boolean afterMinute(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareMinute(firstDate, secondDate);
    }

    public static boolean beforeSecond(Date firstDate, Date secondDate) {
        return -1 == DateUtils.compareSecond(firstDate, secondDate);
    }

    public static boolean equalsSecond(Date firstDate, Date secondDate) {
        return 0 == DateUtils.compareSecond(firstDate, secondDate);
    }

    public static boolean afterSecond(Date firstDate, Date secondDate) {
        return 1 == DateUtils.compareSecond(firstDate, secondDate);
    }

    public static int getMaxDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.get(5);
    }

    public static int getMaxDayOfMonth(int year, int month) {
        int lastMonth = 12;
        AssertIllegalArgument.isInRange(month, 1, 12, "month");
        return DateUtils.getMaxDayOfMonth(DateUtils.getDate(year, month, 1));
    }

    public static int getYearNumber(Date startDate, Date endDate) {
        return DateUtils.getYearNumber(startDate, endDate, true, true);
    }

    public static int getYearNumber(Date startDate, Date endDate, boolean computeMonth, boolean computeDay) {
        DateUtils.checkNull(startDate, endDate);
        int startYear = DateUtils.getYear(startDate);
        int endYear = DateUtils.getYear(endDate);
        DateUtils.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int years = endYear - startYear;
        if (computeMonth) {
            int endDay;
            int startDay;
            int endMonth;
            int startMonth = DateUtils.getMonth(startDate);
            if (startMonth > (endMonth = DateUtils.getMonth(endDate))) {
                --years;
            } else if (startMonth == endMonth && computeDay && (startDay = DateUtils.getDayOfMonth(startDate)) > (endDay = DateUtils.getDayOfMonth(endDate))) {
                --years;
            }
        }
        return years;
    }

    public static int getMonthNumber(Date startDate, Date endDate) {
        return DateUtils.getMonthNumber(startDate, endDate, true);
    }

    public static int getMonthNumber(Date startDate, Date endDate, boolean computeDay) {
        DateUtils.checkNull(startDate, endDate);
        int startYear = DateUtils.getYear(startDate);
        int startMonth = DateUtils.getMonth(startDate);
        int endYear = DateUtils.getYear(endDate);
        int endMonth = DateUtils.getMonth(endDate);
        DateUtils.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int months = 0;
        for (int i = startYear; i <= endYear; ++i) {
            if (i == startYear) {
                months += 12 - startMonth;
                continue;
            }
            if (i == endYear) {
                months += endMonth;
                continue;
            }
            months += 12;
        }
        int startDay = DateUtils.getDayOfMonth(startDate);
        int endDay = DateUtils.getDayOfMonth(endDate);
        if (computeDay && startDay > endDay) {
            --months;
        }
        return months;
    }

    public static int getDayNumber(Date startDate, Date endDate) {
        int endDay;
        DateUtils.checkNull(startDate, endDate);
        int startYear = DateUtils.getYear(startDate);
        int endYear = DateUtils.getYear(endDate);
        DateUtils.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int days = 0;
        for (int i = 0; i < endYear - startYear; ++i) {
            int maxDayOfMonth = DateUtils.getMaxDayOfMonth(startYear, 2);
            if (maxDayOfMonth == 28) {
                days += 365;
                continue;
            }
            days += 366;
        }
        int startDay = DateUtils.getDayOfYear(startDate);
        DateUtils.isTrue(startDay <= (endDay = DateUtils.getDayOfYear(endDate)), MSG_START_AFTER_END);
        return days + endDay - startDay + 1;
    }

    public static int getWorkDayNumber(Date startDate, Date endDate) {
        DateUtils.checkNull(startDate, endDate);
        int startDay = DateUtils.getDayOfYear(startDate);
        int endDay = DateUtils.getDayOfYear(endDate);
        DateUtils.isTrue(startDay <= endDay, MSG_START_AFTER_END);
        int days = 0;
        Calendar cal = null;
        while (startDate.before(endDate) || startDate.equals(endDate)) {
            cal = Calendar.getInstance();
            cal.setTime(startDate);
            if (cal.get(7) != 7 && cal.get(7) != 1) {
                ++days;
            }
            cal.add(5, 1);
            startDate = cal.getTime();
        }
        return days;
    }

    public static int getAge(Date birthday) {
        AssertIllegalArgument.isNotNull(birthday, "Date birthday");
        return DateUtils.getAge(birthday, new Date());
    }

    public static int getAge(Date birthday, Date compareDay) {
        AssertIllegalArgument.isNotNull(birthday, "Date birthday");
        AssertIllegalArgument.isNotNull(compareDay, "Date compareDay");
        DateUtils.isTrue(DateUtils.beforeDay(birthday, compareDay) || DateUtils.equalsDay(birthday, compareDay), "birthday\u4e0d\u80fd\u665a\u4e8ecompareDay");
        int age = DateUtils.getYear(compareDay) - DateUtils.getYear(birthday);
        if (DateUtils.compare(compareDay, birthday, "MMdd") == -1) {
            --age;
        }
        return age;
    }

    private static int toDateMonth(int month) {
        return month - 1;
    }

    private static int fromDateMonth(int month) {
        return month + 1;
    }

    private static int compare(Date firstDate, Date secondDate, String formart) {
        DateUtils.checkNull(firstDate, secondDate);
        long first = Long.parseLong(DateUtils.formart(firstDate, formart));
        long second = Long.parseLong(DateUtils.formart(secondDate, formart));
        if (first < second) {
            return -1;
        }
        if (first == second) {
            return 0;
        }
        return 1;
    }

    private static void checkNull(Date firstDate, Date secondDate) {
        AssertIllegalArgument.isNotNull(firstDate, "Date firstDate");
        AssertIllegalArgument.isNotNull(secondDate, "Date secondDate");
    }

    private static void isTrue(boolean exp, String msg) {
        if (!exp) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static enum TimeType {
        millisecond,
        second,
        minute,
        hour,
        day;

    }
}

