/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.Set;

public final class ClassLoaderUtils {
    private static final String ENTER = "\n";
    private static final String TAB = "\t";

    private ClassLoaderUtils() {
    }

    public static Iterator<URL> getResources(String resourceName, boolean aggregate) throws IOException {
        ClassLoader cl;
        AggregateIterator<URL> iterator = new AggregateIterator<URL>();
        iterator.addEnumeration(Thread.currentThread().getContextClassLoader().getResources(resourceName));
        if (!iterator.hasNext() || aggregate) {
            iterator.addEnumeration(ClassLoaderUtils.class.getClassLoader().getResources(resourceName));
        }
        Class<?> callingClass = ClassUtils.forName(LangUtils.getInvoker().getClassName());
        if ((!iterator.hasNext() || aggregate) && (cl = callingClass.getClassLoader()) != null) {
            iterator.addEnumeration(cl.getResources(resourceName));
        }
        if (!iterator.hasNext() && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + resourceName, callingClass, aggregate);
        }
        return iterator;
    }

    public static Iterator<URL> getResources(String resourceName, Class<?> callingClass, boolean aggregate) throws IOException {
        ClassLoader cl;
        AggregateIterator<URL> iterator = new AggregateIterator<URL>();
        iterator.addEnumeration(Thread.currentThread().getContextClassLoader().getResources(resourceName));
        if (!iterator.hasNext() || aggregate) {
            iterator.addEnumeration(ClassLoaderUtils.class.getClassLoader().getResources(resourceName));
        }
        if ((!iterator.hasNext() || aggregate) && (cl = callingClass.getClassLoader()) != null) {
            iterator.addEnumeration(cl.getResources(resourceName));
        }
        if (!iterator.hasNext() && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResources('/' + resourceName, callingClass, aggregate);
        }
        return iterator;
    }

    public static URL getResource(String resourceName) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ClassLoaderUtils.class.getClassLoader().getResource(resourceName);
        }
        if (url != null) {
            return url;
        }
        Class<?> callingClass = ClassUtils.forName(LangUtils.getInvoker().getClassName());
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName) {
        URL url = ClassLoaderUtils.getResource(resourceName);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static URL getResource(String resourceName, Class<?> callingClass) {
        ClassLoader cl;
        URL url = Thread.currentThread().getContextClassLoader().getResource(resourceName);
        if (url == null) {
            url = ClassLoaderUtils.class.getClassLoader().getResource(resourceName);
        }
        if (url == null && (cl = callingClass.getClassLoader()) != null) {
            url = cl.getResource(resourceName);
        }
        if (url == null && resourceName != null && resourceName.charAt(0) != '/') {
            return ClassLoaderUtils.getResource('/' + resourceName, callingClass);
        }
        return url;
    }

    public static InputStream getResourceAsStream(String resourceName, Class<?> callingClass) {
        URL url = ClassLoaderUtils.getResource(resourceName, callingClass);
        try {
            return url != null ? url.openStream() : null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Class<?> loadClass(String className, Class<?> callingClass) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException ex) {
                try {
                    return ClassLoaderUtils.class.getClassLoader().loadClass(className);
                }
                catch (ClassNotFoundException exc) {
                    return callingClass.getClassLoader().loadClass(className);
                }
            }
        }
    }

    public static void printClassLoader() {
        System.out.println("ClassLoaderUtils.printClassLoader");
        ClassLoaderUtils.printClassLoader(Thread.currentThread().getContextClassLoader());
    }

    public static void printClassLoader(ClassLoader cl) {
        System.out.println("ClassLoaderUtils.printClassLoader(cl = " + cl + ")");
        if (cl != null) {
            ClassLoaderUtils.printClassLoader(cl.getParent());
        }
    }

    public static String showClassLoaderHierarchy(Object obj, String role) {
        return ClassLoaderUtils.showClassLoaderHierarchy(obj, role, ENTER, TAB);
    }

    public static String showClassLoaderHierarchy(Object obj, String role, String lineBreak, String tabText) {
        String s = "object of " + obj.getClass() + ": role is " + role + lineBreak;
        return s + ClassLoaderUtils.showClassLoaderHierarchy(obj.getClass().getClassLoader(), lineBreak, tabText, 0);
    }

    public static String showClassLoaderHierarchy(ClassLoader cl) {
        return ClassLoaderUtils.showClassLoaderHierarchy(cl, ENTER, TAB);
    }

    public static String showClassLoaderHierarchy(ClassLoader cl, String lineBreak, String tabText) {
        return ClassLoaderUtils.showClassLoaderHierarchy(cl, lineBreak, tabText, 0);
    }

    private static String showClassLoaderHierarchy(ClassLoader cl, String lineBreak, String tabText, int indent) {
        if (cl == null) {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            return "context class loader=[" + ccl + " ] hashCode=" + ccl.hashCode();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < indent; ++i) {
            buf.append(tabText);
        }
        buf.append("[").append(cl).append("] hashCode=").append(cl.hashCode()).append(lineBreak);
        ClassLoader parent = cl.getParent();
        return buf.toString() + ClassLoaderUtils.showClassLoaderHierarchy(parent, lineBreak, tabText, indent + 1);
    }

    protected static class AggregateIterator<E>
    implements Iterator<E> {
        LinkedList<Enumeration<E>> enums = new LinkedList();
        Enumeration<E> cur = null;
        E next = null;
        Set<E> loaded = new HashSet();

        protected AggregateIterator() {
        }

        public AggregateIterator addEnumeration(Enumeration<E> e) {
            if (e.hasMoreElements()) {
                if (this.cur == null) {
                    this.cur = e;
                    this.next = e.nextElement();
                    this.loaded.add(this.next);
                } else {
                    this.enums.add(e);
                }
            }
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public E next() {
            if (this.next != null) {
                E prev = this.next;
                this.next = this.loadNext();
                return prev;
            }
            throw new NoSuchElementException();
        }

        private Enumeration<E> determineCurrentEnumeration() {
            if (this.cur != null && !this.cur.hasMoreElements()) {
                this.cur = this.enums.size() > 0 ? this.enums.removeLast() : null;
            }
            return this.cur;
        }

        private E loadNext() {
            if (this.determineCurrentEnumeration() != null) {
                E tmp = this.cur.nextElement();
                while (this.loaded.contains(tmp) && (tmp = this.loadNext()) != null) {
                }
                if (tmp != null) {
                    this.loaded.add(tmp);
                }
                return tmp;
            }
            return null;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

