/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Collection;

public interface Properties {
    public String setProperty(String var1, String var2);

    public String setProperty(String var1, String var2, String var3);

    public Property setProperty(Property var1);

    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    public Property getPropertyPart(String var1);

    public Collection<Property> getPropertyParts();

    public Collection<String> getPropertyNames();

    public Collection<Part> listAll();

    public Charset getCharset();

    public void store(OutputStream var1) throws IOException;

    public void load(InputStream var1) throws IOException;

    public java.util.Properties toJdkProperties();

    public static class Property
    implements Part {
        private String key;
        private String value;
        private String comment;

        public Property() {
        }

        public Property(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public Property(String key, String value, String comment) {
            this.key = key;
            this.value = value;
            this.comment = comment;
        }

        public String getKey() {
            return this.key;
        }

        public void setKey(String key) {
            this.key = key;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public String toPart() {
            String result = "";
            if (this.comment != null) {
                result = result + new Comment(this.comment).toPart() + "\n";
            }
            result = result + this.key + "=" + this.value;
            return result;
        }

        public String toString() {
            return "Property [key=" + this.key + ", value=" + this.value + ", comment=" + this.comment + "]";
        }
    }

    public static class CharsetComment
    extends Comment {
        private Charset charset;

        public static CharsetComment createIfCan(String comment) {
            String[] tokens = comment.split("=");
            if (tokens.length == 2 && "charset".equalsIgnoreCase(tokens[0].trim())) {
                return new CharsetComment(Charset.forName(tokens[1].trim()));
            }
            return null;
        }

        public CharsetComment(Charset charset) {
            super("charset=" + charset.displayName());
            this.charset = charset;
        }

        public Charset getCharset() {
            return this.charset;
        }

        public void setCharset(Charset charset) {
            this.charset = charset;
        }
    }

    public static class Comment
    implements Part {
        String comment;

        public Comment() {
        }

        public Comment(String comment) {
            this.comment = comment;
        }

        public String getComment() {
            return this.comment;
        }

        public void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public String toPart() {
            return "#" + this.comment.replaceAll("\n", " ");
        }

        public String toString() {
            return this.comment;
        }
    }

    public static interface Part {
        public String toPart();
    }
}

