/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.storage.file;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.io.file.RenamePolicy;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.UriUtils;
import cn.featherfly.common.storage.StorageException;
import cn.featherfly.common.storage.file.FileStorage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileLocalDirStorage
implements FileStorage {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String baseDir;
    private String relativeDir;
    private RenamePolicy renamePolicy;

    public FileLocalDirStorage() {
        this.setBaseDirDefault();
    }

    @Override
    public String store(File file) {
        ASSERT.isNotNull(file, "param file  ");
        try {
            String extDir = this.getExtDir();
            File targetFile = this.createTargetFile(file.getName(), extDir);
            FileUtils.copyFile((File)file, (File)targetFile);
            return this.getId(targetFile, extDir);
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public File retrieve(String id) {
        ASSERT.isNotEmpty(id, "id");
        this.logger.debug("\u6587\u4ef6\u5b58\u50a8\u552f\u4e00\u6807\u793a\uff1a{}", (Object)id);
        File file = this.createRelativeDir();
        file = new File(UriUtils.linkUri(file.getAbsolutePath(), id));
        this.logger.debug("\u83b7\u53d6\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        return file;
    }

    @Override
    public boolean delete(String id) {
        File file = this.retrieve(id);
        return FileUtils.delete(file);
    }

    protected abstract String getExtDir();

    protected String getId(File targetFile, String extDir) {
        if (Lang.isEmpty(extDir)) {
            return targetFile.getName();
        }
        return extDir + "/" + targetFile.getName();
    }

    private File createRelativeDir() {
        ASSERT.isNotEmpty(this.getBaseDir(), "baseDir");
        File file = null;
        String finalDir = this.getBaseDir();
        String relativeDir = this.getRelativeDir();
        if (Lang.isNotEmpty(relativeDir)) {
            finalDir = UriUtils.linkUri(finalDir, relativeDir);
        }
        file = new File(finalDir);
        this.logger.debug("\u6587\u4ef6\u5b58\u50a8\u76f8\u5bf9\u76ee\u5f55\uff1a{}", (Object)file.getAbsolutePath());
        FileUtils.createDirectory(file);
        return file;
    }

    private File createTargetDir(String extDir) {
        File file = this.createRelativeDir();
        String finalDir = file.getAbsolutePath();
        if (Lang.isNotEmpty(extDir)) {
            finalDir = UriUtils.linkUri(finalDir, extDir);
        }
        file = new File(finalDir);
        this.logger.debug("\u6587\u4ef6\u5b58\u50a8\u76ee\u6807\u76ee\u5f55\uff1a{}", (Object)file.getAbsolutePath());
        FileUtils.createDirectory(file);
        return file;
    }

    private File createTargetFile(String fileName, String extDir) {
        File file = new File(UriUtils.linkUri(this.createTargetDir(extDir).getAbsolutePath(), this.rename(fileName)));
        this.logger.debug("\u6587\u4ef6\u5b58\u50a8\u76ee\u6807\u4f4d\u7f6e\uff1a{}", (Object)file.getAbsolutePath());
        FileUtils.createDirectory(file.getParentFile());
        return file;
    }

    private String rename(String fileName) {
        if (this.renamePolicy != null) {
            this.logger.debug("\u91cd\u547d\u540d\u7b56\u7565\u4e3a\uff1a{}", (Object)this.renamePolicy.getClass().getName());
            return this.renamePolicy.rename(fileName);
        }
        this.logger.debug("\u91cd\u547d\u540d\u7b56\u7565\u4e3a\u7a7a\uff0c\u4f7f\u7528\u539f\u59cb\u6587\u4ef6\u540d\uff1a{}" + fileName);
        return fileName;
    }

    private void setBaseDirDefault() {
        if (Lang.isEmpty(this.baseDir)) {
            URL resource = this.getClass().getResource("/");
            if (resource == null) {
                resource = Thread.currentThread().getContextClassLoader().getResource(".");
            }
            this.baseDir = FileUtils.getRootDir(new File(resource.getPath())).getAbsolutePath();
            this.logger.debug("baseDir\u4e3a\u7a7a\uff0c\u4f7f\u7528\u6839\u76ee\u5f55 -> {}", (Object)this.baseDir);
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public void setBaseDir(String baseDir) {
        this.logger.debug("set baseDir -> {}", (Object)baseDir);
        this.baseDir = baseDir;
    }

    public String getRelativeDir() {
        return this.relativeDir;
    }

    public void setRelativeDir(String relativeDir) {
        this.relativeDir = relativeDir;
    }

    public RenamePolicy getRenamePolicy() {
        return this.renamePolicy;
    }

    public void setRenamePolicy(RenamePolicy renamePolicy) {
        this.renamePolicy = renamePolicy;
    }
}

