/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.locale;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.ServiceLoaderUtils;
import cn.featherfly.common.locale.DefaultLocaleManager;
import cn.featherfly.common.locale.JdkResourceBundleFactory;
import cn.featherfly.common.locale.LocaleManager;
import cn.featherfly.common.locale.ResourceBundle;
import cn.featherfly.common.locale.ResourceBundleFactory;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBundleUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceBundleUtils.class);
    private static final ResourceBundleFactory RESOURCE_BUNDLE_FACTORY = ServiceLoaderUtils.load(ResourceBundleFactory.class, new JdkResourceBundleFactory());
    private static final LocaleManager LOCALE_MANAGER = ServiceLoaderUtils.load(LocaleManager.class, new DefaultLocaleManager());
    public static final char RESOURCE_SIGN = '@';
    public static final char KEY_SIGN = '#';

    private ResourceBundleUtils() {
    }

    public static Locale getLocale() {
        return LOCALE_MANAGER.getLocale();
    }

    public static ResourceBundle getBundle(String baseName) {
        return ResourceBundleUtils.getBundle(baseName, LOCALE_MANAGER.getLocale());
    }

    public static ResourceBundle getBundle(String baseName, Charset charset) {
        return ResourceBundleUtils.getBundle(baseName, LOCALE_MANAGER.getLocale(), charset);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale) {
        return RESOURCE_BUNDLE_FACTORY.getBundle(baseName, locale);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, Charset charset) {
        return RESOURCE_BUNDLE_FACTORY.getBundle(baseName, locale, charset);
    }

    public static String getString(String pattern) {
        return ResourceBundleUtils.getString(pattern, new Object[0]);
    }

    public static String getString(String pattern, Charset charset) {
        return ResourceBundleUtils.getString(pattern, new Object[0], charset);
    }

    public static String getString(String pattern, Object[] argus) {
        return ResourceBundleUtils.getString(pattern, argus, LOCALE_MANAGER.getLocale());
    }

    public static String getString(String pattern, Object[] argus, Charset charset) {
        return ResourceBundleUtils.getString(pattern, argus, LOCALE_MANAGER.getLocale(), charset);
    }

    public static String getString(String pattern, Object[] argus, Locale locale) {
        return ResourceBundleUtils.getString(pattern, argus, locale, null);
    }

    public static String getString(String pattern, Object[] argus, Locale locale, Charset charset) {
        String baseName = null;
        String key = null;
        int keyIndex = pattern.indexOf(35);
        char firstChar = pattern.charAt(0);
        if (firstChar == '@' && keyIndex != -1) {
            baseName = pattern.substring(1, pattern.indexOf(35));
            key = pattern.substring(pattern.indexOf(35) + 1);
            return ResourceBundleUtils.getStringFromBundle(pattern, baseName, key, argus, locale, charset);
        }
        throw new IllegalArgumentException("argu code must start with @ and split bundle baseName and key with #, example: @bundleBaseName#key");
    }

    public static String getString(String baseName, String key, Object[] argus, Locale locale) {
        return ResourceBundleUtils.getString(baseName, key, argus, locale, null);
    }

    public static String getString(String baseName, String key, Object[] argus, Locale locale, Charset charset) {
        return ResourceBundleUtils.getStringFromBundle(baseName, key, argus, locale, charset);
    }

    public static String getString(Class<?> type, String key) {
        return ResourceBundleUtils.getString(type, key, ResourceBundleUtils.getLocale());
    }

    public static String getString(Class<?> type, String key, Charset charset) {
        return ResourceBundleUtils.getString(type, key, ResourceBundleUtils.getLocale(), charset);
    }

    public static String getString(Class<?> type, String key, Locale locale) {
        return ResourceBundleUtils.getString(type, key, new Object[0], locale);
    }

    public static String getString(Class<?> type, String key, Locale locale, Charset charset) {
        return ResourceBundleUtils.getString(type, key, new Object[0], locale, charset);
    }

    public static String getString(Class<?> type, String key, Object[] argus) {
        return ResourceBundleUtils.getString(type, key, argus, ResourceBundleUtils.getLocale());
    }

    public static String getString(Class<?> type, String key, Object[] argus, Charset charset) {
        return ResourceBundleUtils.getString(type, key, argus, ResourceBundleUtils.getLocale(), charset);
    }

    public static String getString(Class<?> type, String key, Object[] argus, Locale locale) {
        return ResourceBundleUtils.getString(type, key, argus, locale, null);
    }

    public static String getString(Class<?> type, String key, Object[] argus, Locale locale, Charset charset) {
        try {
            return ResourceBundleUtils.getString(type.getName(), key, argus, locale, charset);
        }
        catch (MissingResourceException e) {
            return ResourceBundleUtils.getString(type.getSimpleName(), key, argus, locale, charset);
        }
    }

    private static String getStringFromBundle(String baseName, String key, Object[] argus, Locale locale, Charset charset) {
        if (locale == null) {
            locale = ResourceBundleUtils.getLocale();
        }
        String string = ResourceBundleUtils.format(ResourceBundleUtils.getBundle(baseName, locale, charset).getString(key), argus);
        return string;
    }

    private static String getStringFromBundle(String code, String baseName, String key, Object[] argus, Locale locale, Charset charset) {
        if (locale == null) {
            locale = ResourceBundleUtils.getLocale();
        }
        String string = ResourceBundleUtils.format(ResourceBundleUtils.getBundle(baseName, locale, charset).getString(key), argus);
        LOGGER.debug("match ResourceBundle pattern -> [{}] : baseName[{}] and key[{}], message -> {}", new Object[]{code, baseName, key, string});
        return string;
    }

    private static String format(String string, Object[] argus) {
        if (Lang.isNotEmpty(argus)) {
            return MessageFormat.format(string, argus);
        }
        return string;
    }
}

