/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.tree.util;

import cn.featherfly.common.structure.tree.Tree;
import cn.featherfly.common.structure.tree.TreeNode;
import java.io.PrintStream;
import java.util.Iterator;

public final class TreeNodeTestUtils {
    private static final PrintStream DEFAULT_PRINT = System.out;

    private TreeNodeTestUtils() {
    }

    public static <E> String constract(Tree<E> tree) {
        return TreeNodeTestUtils.constract(tree.getRootNode());
    }

    public static <E> String constract(TreeNode<E> treeNode) {
        StringBuilder sb = new StringBuilder();
        TreeNodeTestUtils.constract(treeNode, sb);
        return sb.toString();
    }

    private static <E> void constract(TreeNode<E> treeNode, StringBuilder sb) {
        StringBuffer space = new StringBuffer("");
        for (int i = 0; i < treeNode.getDepth(); ++i) {
            space = i == treeNode.getDepth() - 1 ? space.append("|_") : space.append(" ");
        }
        sb.append(space + treeNode.getId().toString() + "\n");
        if (!treeNode.isLeaf()) {
            Iterator iter = treeNode.getChildNodes().iterator();
            TreeNode node = null;
            while (iter.hasNext()) {
                node = (TreeNode)iter.next();
                TreeNodeTestUtils.constract(node, sb);
            }
        }
    }

    public static <E> void show(Tree<E> tree) {
        TreeNodeTestUtils.show(tree, DEFAULT_PRINT);
    }

    public static <E> void show(TreeNode<E> node) {
        TreeNodeTestUtils.show(node, DEFAULT_PRINT);
    }

    public static <E> void show(Tree<E> tree, PrintStream print) {
        TreeNodeTestUtils.show(tree.getRootNode(), print);
    }

    public static <E> void show(TreeNode<E> node, PrintStream print) {
        TreeNodeTestUtils.show(0, node, print);
    }

    private static <E> void show(int level, TreeNode<E> treeNode, PrintStream print) {
        StringBuffer space = new StringBuffer();
        for (int i = 0; i < level; ++i) {
            space = space.append(" ");
        }
        print.println("level:" + level + " " + space + treeNode.getId() + "  ");
        if (!treeNode.isLeaf()) {
            Iterator iter = treeNode.getChildNodes().iterator();
            TreeNode node = null;
            while (iter.hasNext()) {
                node = (TreeNode)iter.next();
                TreeNodeTestUtils.show(level + 1, node, print);
            }
        }
    }
}

