/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.policy;

import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.policy.BlackListPolicy;
import cn.featherfly.common.policy.WhiteListPolicy;
import java.util.Collection;
import java.util.HashSet;

public abstract class WhiteBlackListPolicy<T>
implements WhiteListPolicy<T, WhiteBlackListPolicy<T>>,
BlackListPolicy<T, WhiteBlackListPolicy<T>> {
    private Collection<T> blackList = new HashSet<T>();
    private Collection<T> whiteList = new HashSet<T>();
    private boolean enableBlackList = true;
    private boolean enableWhiteList = true;

    @Override
    public WhiteBlackListPolicy<T> addBlack(T t) {
        this.blackList.add(t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> addBlack(T ... t) {
        CollectionUtils.addAll(this.blackList, t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> removeBlack(T t) {
        this.blackList.remove(t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> clearBlackList() {
        this.blackList.clear();
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> addWhite(T t) {
        this.whiteList.add(t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> addWhite(T ... t) {
        CollectionUtils.addAll(this.whiteList, t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> removeWhite(T t) {
        this.whiteList.remove(t);
        return this;
    }

    @Override
    public WhiteBlackListPolicy<T> clearWhiteList() {
        this.whiteList.clear();
        return this;
    }

    public WhiteBlackListPolicy<T> clear() {
        this.blackList.clear();
        this.whiteList.clear();
        return this;
    }

    @Override
    public Collection<T> getBlackList() {
        return new HashSet<T>(this.blackList);
    }

    @Override
    public WhiteBlackListPolicy<T> setBlackList(Collection<T> blackList) {
        this.blackList = blackList;
        return this;
    }

    @Override
    public Collection<T> getWhiteList() {
        return new HashSet<T>(this.whiteList);
    }

    @Override
    public void setWhiteList(Collection<T> whiteList) {
        this.whiteList = whiteList;
    }

    public boolean isEnableBlackList() {
        return this.enableBlackList;
    }

    public WhiteBlackListPolicy<T> setEnableBlackList(boolean enableBlackList) {
        this.enableBlackList = enableBlackList;
        return this;
    }

    public boolean isEnableWhiteList() {
        return this.enableWhiteList;
    }

    public WhiteBlackListPolicy<T> setEnableWhiteList(boolean enableWhiteList) {
        this.enableWhiteList = enableWhiteList;
        return this;
    }

    @Override
    public boolean isAllow(T target) {
        if (this.isEnableBlackList() && this.isInBlackList(target)) {
            return false;
        }
        if (this.isEnableWhiteList()) {
            return this.isInWhiteList(target);
        }
        return true;
    }

    protected abstract boolean isEquals(T var1, T var2);

    protected boolean isInBlackList(T target) {
        for (T t : this.blackList) {
            if (!this.isEquals(target, t)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInWhiteList(T target) {
        for (T t : this.whiteList) {
            if (!this.isEquals(target, t)) continue;
            return true;
        }
        return false;
    }
}

