/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.asserts;

import cn.featherfly.common.bean.BeanUtils;
import cn.featherfly.common.exception.LocalizedExceptionUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LambdaUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import cn.featherfly.common.lang.asserts.ILocalizedAssert;
import cn.featherfly.common.lang.function.SerializableSupplier;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class LocalizedAssert<E extends RuntimeException>
implements ILocalizedAssert<E> {
    private Class<E> exceptionType;

    public LocalizedAssert(Class<E> exceptionType) {
        this.exceptionType = exceptionType;
    }

    @Override
    public void isNotNull(Object object, String arg) {
        if (object == null) {
            this.throwException("#isNotNull", arg);
        }
    }

    @Override
    public void isNotBlank(String text, String arg) {
        if (!Strings.isNotBlank(text)) {
            this.throwException("#isNotBlank", arg);
        }
    }

    @Override
    public void isNotEmpty(Object obj, String args) {
        if (!Lang.isNotEmpty(obj)) {
            this.throwException("#isNotEmpty", args);
        }
    }

    @Override
    public void isNotEmpty(String text, String arg) {
        if (!Lang.isNotEmpty(text)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Object[] array, String arg) {
        if (Lang.isEmpty(array)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Collection<?> collection, String arg) {
        if (Lang.isEmpty(collection)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isNotEmpty(Map<?, ?> map, String arg) {
        if (Lang.isEmpty(map)) {
            this.throwException("#isNotEmpty", arg);
        }
    }

    @Override
    public void isExists(File file, String args) {
        if (file == null) {
            this.throwException("#isExists", args, "null");
        } else if (!file.exists()) {
            this.throwException("#isExists", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isFile(File file, String args) {
        if (file == null) {
            this.throwException("#isFile", args, "null");
        } else if (!file.isFile()) {
            this.throwException("#isFile", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isDirectory(File file, String args) {
        if (file == null) {
            this.throwException("#isDirectory", args, "null");
        } else if (!file.isDirectory()) {
            this.throwException("#isDirectory", args, file.getAbsolutePath());
        }
    }

    @Override
    public void isInstanceOf(Class<?> clazz, Object obj) {
        Object[] args = new Object[]{clazz == null ? "null" : clazz.getName(), obj == null ? "null" : obj.getClass().getName()};
        if (clazz == null || !clazz.isInstance(obj)) {
            this.throwException("#isInstanceOf", args);
        }
    }

    @Override
    public void isParent(Class<?> parentType, Class<?> subType) {
        Object[] args = new Object[]{parentType == null ? "null" : parentType.getName(), subType == null ? "null" : subType.getName()};
        if (!ClassUtils.isParent(parentType, subType)) {
            this.throwException("#isParent", args);
        }
    }

    @Override
    public void isNotInterface(Class<?> classType) {
        if (classType != null && classType.isInterface()) {
            this.throwException("#isNotInterface", classType.getName());
        }
    }

    private void throwException(String msg, Object ... args) {
        msg = "@assert" + (String)msg;
        LocalizedExceptionUtils.throwException(this.exceptionType, (String)msg, args);
    }

    @Override
    public void isInRange(int value, int min, int max, String arguDescp) {
        if (value < min || value > max) {
            this.throwException("#isInRange", value, min, max, arguDescp);
        }
    }

    @Override
    public void isGt(int value, int min, String arguDescp) {
        if (value <= min) {
            this.throwException("#isGt", value, min, arguDescp);
        }
    }

    @Override
    public void isGe(int value, int min, String arguDescp) {
        if (value < min) {
            this.throwException("#isGe", value, min, arguDescp);
        }
    }

    @Override
    public void isLt(int value, int max, String arguDescp) {
        if (value >= max) {
            this.throwException("#isLt", value, max, arguDescp);
        }
    }

    @Override
    public void isLe(int value, int max, String arguDescp) {
        if (value > max) {
            this.throwException("#isLe", value, max, arguDescp);
        }
    }

    @Override
    public <T> void isNotNull(SerializableSupplier<T> propertySupplier) {
        LambdaUtils.SerializedLambdaInfo info = LambdaUtils.getLambdaInfo(propertySupplier);
        Object value = BeanUtils.getProperty(info.getSerializedLambda().getCapturedArg(0), info.getPropertyName());
        this.isNotNull(value, this.createDescp(info));
    }

    @Override
    public void isNotBlank(SerializableSupplier<String> propertySupplier) {
        LambdaUtils.SerializedLambdaInfo info = LambdaUtils.getLambdaInfo(propertySupplier);
        Object value = BeanUtils.getProperty(info.getSerializedLambda().getCapturedArg(0), info.getPropertyName());
        String descp = this.createDescp(info);
        this.isNotNull(value, descp);
        this.isNotBlank(value.toString(), descp);
    }

    @Override
    public <T> void isNotEmpty(SerializableSupplier<T> propertySupplier) {
        LambdaUtils.SerializedLambdaInfo info = LambdaUtils.getLambdaInfo(propertySupplier);
        Object value = BeanUtils.getProperty(info.getSerializedLambda().getCapturedArg(0), info.getPropertyName());
        this.isNotEmpty(value, this.createDescp(info));
    }

    private String createDescp(LambdaUtils.SerializedLambdaInfo info) {
        return StringUtils.substringAfterLast((String)info.getMethodInstanceClassName(), (String)".") + "." + info.getPropertyName();
    }
}

