/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.number.ChineseNumber;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public final class WordUtils {
    private WordUtils() {
    }

    public static String upperCaseFirst(String word) {
        if (StringUtils.isBlank((CharSequence)word)) {
            return word;
        }
        if ((word = word.trim()).length() == 1) {
            return "" + Character.toUpperCase(word.charAt(0));
        }
        return Character.toUpperCase(word.charAt(0)) + word.substring(1);
    }

    public static String parseToUpperFirst(String word, char sign) {
        if (Lang.isEmpty(word)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        boolean isSign = false;
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (c == sign) {
                isSign = true;
                continue;
            }
            if (isSign) {
                sb.append(Character.toUpperCase(c));
            } else {
                sb.append(c);
            }
            isSign = false;
        }
        if (sb.length() > 0) {
            sb.replace(0, 1, "" + Character.toLowerCase(sb.charAt(0)));
        }
        return sb.toString();
    }

    public static String addSignBeforeUpper(String word, char sign, boolean upperToLower) {
        if (Lang.isEmpty(word)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < word.length(); ++i) {
            char c = word.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append(sign);
                }
                if (upperToLower) {
                    c = Character.toLowerCase(c);
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static String parseUnit(long total) {
        String dotNumber;
        BigDecimal bd;
        double dm;
        long mod;
        Object strUnit = "";
        double unitSize = 1024.0;
        long max = 1024L;
        strUnit = total + " B";
        if (total >= 1024L) {
            mod = total % 1024L;
            dm = (double)mod / 1024.0;
            bd = new BigDecimal(dm);
            bd = bd.setScale(2, 1);
            dotNumber = bd.toString();
            strUnit = (total /= 1024L) + dotNumber.substring(1, dotNumber.length()) + " KB";
        }
        if (total >= 1024L) {
            mod = total % 1024L;
            dm = (double)mod / 1024.0;
            bd = new BigDecimal(dm);
            bd = bd.setScale(2, 1);
            dotNumber = bd.toString();
            strUnit = (total /= 1024L) + dotNumber.substring(1, dotNumber.length()) + " MB";
        }
        if (total >= 1024L) {
            mod = total % 1024L;
            dm = (double)mod / 1024.0;
            bd = new BigDecimal(dm);
            bd = bd.setScale(2, 1);
            dotNumber = bd.toString();
            strUnit = (total /= 1024L) + dotNumber.substring(1, dotNumber.length()) + " GB";
        }
        return strUnit;
    }

    public static String parseToPercent(double num, int precision) {
        BigDecimal bd = BigDecimal.valueOf(num);
        bd = bd.multiply(BigDecimal.valueOf(100L));
        bd = bd.setScale(precision, 1);
        String result = "%" + bd.toString();
        return result;
    }

    public static String parseToPercent(double num) {
        return WordUtils.parseToPercent(num, 0);
    }

    public static String toChineseMoneyNumber(BigDecimal value) {
        return WordUtils.toChineseMoneyNumber(value.doubleValue());
    }

    public static String toChineseMoneyNumber(double value) {
        return new ChineseNumber(false).toMoneyNumberWord(value);
    }

    public static String toChineseNumber(long number) {
        return WordUtils.toChineseNumber(number, false);
    }

    public static String toChineseNumber(long number, boolean simple) {
        return new ChineseNumber(simple).toNumberWord(number);
    }

    public static String toChineseNumber(int number) {
        return WordUtils.toChineseNumber(number, false);
    }

    public static String toChineseNumber(int number, boolean simple) {
        return new ChineseNumber(simple).toNumberWord(number);
    }
}

