/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.LangUtils;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated
public final class StringUtils
extends org.apache.commons.lang3.StringUtils {
    private static final Pattern UNICODE_PATTERN = Pattern.compile("(\\\\u(\\p{XDigit}{4}))");
    public static final String NULL_STRING = "null";

    private StringUtils() {
    }

    public static String pickNotEmpty(String target, String defaultTarget) {
        return StringUtils.isEmpty(target) ? defaultTarget : target;
    }

    public static String pickNotBlank(String target, String defaultTarget) {
        return StringUtils.isBlank((CharSequence)target) ? defaultTarget : target;
    }

    public static String pickFirst(String ... pickedItems) {
        if (pickedItems != null) {
            for (String s : pickedItems) {
                if (!StringUtils.isNotBlank(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static String pickLast(String ... pickedItems) {
        if (pickedItems != null) {
            for (int i = pickedItems.length - 1; i >= 0; --i) {
                String s = pickedItems[i];
                if (!StringUtils.isNotBlank(s)) continue;
                return s;
            }
        }
        return null;
    }

    public static String getString(String str) {
        return StringUtils.getString(str, "");
    }

    public static String getString(String str, String defValue) {
        return StringUtils.getString(str, defValue, true);
    }

    public static String getString(String str, String defValue, boolean ignoreCaseNullStr) {
        if (str == null || "".equals(str)) {
            return defValue;
        }
        if (!ignoreCaseNullStr && (NULL_STRING.equals(str) || NULL_STRING.toUpperCase().equals(str))) {
            return defValue;
        }
        return str;
    }

    public static boolean isEmpty(String[] strs) {
        for (String str : strs) {
            if (!LangUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(Collection<String> strs) {
        for (String str : strs) {
            if (!LangUtils.isNotEmpty(str)) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(String str) {
        return LangUtils.isEmpty(str);
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank((CharSequence)str);
    }

    public static boolean isNull(String str) {
        return StringUtils.isEmpty(str) || "NULL".equalsIgnoreCase(str.trim());
    }

    public static String trim(String str) {
        if (str == null) {
            return str;
        }
        return str.trim();
    }

    public static String trim(String str, String defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        return str.trim();
    }

    public static String trimStart(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        char[] c = str.toCharArray();
        int offset = 0;
        for (int i = 0; i < c.length; ++i) {
            if (Character.isWhitespace(c[i])) continue;
            offset = i;
            break;
        }
        return new String(c, offset, c.length - offset);
    }

    public static String trimEnd(String str) {
        if (StringUtils.isBlank((CharSequence)str)) {
            return "";
        }
        char[] c = str.toCharArray();
        int end = 0;
        for (int i = c.length; i > 0; --i) {
            if (Character.isWhitespace(c[i - 1])) continue;
            end = i;
            break;
        }
        return new String(c, 0, end);
    }

    public static boolean isInteger(String str) {
        int numberUnit = 10;
        return StringUtils.isInteger(str, 10);
    }

    public static boolean isInteger(String str, int radio) {
        str = StringUtils.trim(str);
        try {
            Integer.parseInt(str, radio);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static String toUpperCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        return str.toLowerCase();
    }

    public static String format(String str, String ... args) {
        if (StringUtils.isNotBlank(str) && str.indexOf(35) > -1) {
            StringBuilder sb = new StringBuilder();
            boolean isArg = false;
            for (int x = 0; x < str.length(); ++x) {
                char c = str.charAt(x);
                if (isArg) {
                    int val;
                    isArg = false;
                    if (Character.isDigit(c) && (val = Character.getNumericValue(c)) >= 1 && val <= args.length) {
                        sb.append(args[val - 1]);
                        continue;
                    }
                    sb.append('#');
                }
                if (c == '#') {
                    isArg = true;
                    continue;
                }
                sb.append(c);
            }
            if (isArg) {
                sb.append('#');
            }
            return sb.toString();
        }
        return str;
    }

    public static String format(String content, Map<String, String> params) {
        Set<Map.Entry<String, String>> sets = params.entrySet();
        for (Map.Entry<String, String> entry : sets) {
            String regex = "\\{" + entry.getKey() + "\\}";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(content);
            content = matcher.replaceAll(entry.getValue());
        }
        return content;
    }

    public static String replace(String text, String searchString, String replacement) {
        return StringUtils.replace((String)text, (String)searchString, (String)replacement, (int)-1);
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 != null) {
            return str1.equals(str2);
        }
        if (str2 != null) {
            return str2.equals(str1);
        }
        return true;
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (str1 != null) {
            return str1.equalsIgnoreCase(str2);
        }
        if (str2 != null) {
            return str2.equalsIgnoreCase(str1);
        }
        return true;
    }

    public static String join(Collection<String> collection, String delim) {
        if (LangUtils.isEmpty(collection)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        Iterator<String> iter = collection.iterator();
        while (iter.hasNext()) {
            String strTemp = StringUtils.pickFirst(iter.next(), "");
            sb.append(strTemp);
            if (!iter.hasNext()) continue;
            sb.append(delim);
        }
        return sb.toString();
    }

    public static String join(String[] array, String delim) {
        if (LangUtils.isEmpty(array)) {
            return "";
        }
        int length = array.length - 1;
        if (delim == null) {
            delim = "";
        }
        StringBuilder result = new StringBuilder(length * 10);
        for (int i = 0; i < length; ++i) {
            result.append(array[i]);
            result.append(delim);
        }
        result.append(array[length]);
        return result.toString();
    }

    public static List<String> splitToList(String source, String delim) {
        ArrayList<String> list = new ArrayList<String>();
        Collections.addAll(list, StringUtils.split(source, delim));
        return list;
    }

    public static String[] split(String source, String delim) {
        if (source == null || delim == null) {
            String[] wordLists = new String[]{source};
            return wordLists;
        }
        StringTokenizer st = new StringTokenizer(source, delim);
        int total = st.countTokens();
        String[] wordLists = new String[total];
        for (int i = 0; i < total; ++i) {
            wordLists[i] = st.nextToken();
        }
        return wordLists;
    }

    public static String[] split(String source) {
        return StringUtils.split(source, ",");
    }

    public static String[] objectArrayToStringArray(Object[] array) {
        String[] strArray = null;
        if (array != null) {
            if (array.length < 1) {
                strArray = new String[]{};
            } else if (array instanceof String[]) {
                strArray = (String[])array;
            } else {
                strArray = new String[array.length];
                for (int i = 0; i < array.length; ++i) {
                    Object object = array[i];
                    strArray[i] = object == null ? null : object.toString();
                }
            }
        }
        return strArray;
    }

    public static String removeSpaces(String str) {
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == ' ') continue;
            newString.append(str.charAt(i));
        }
        return newString.toString();
    }

    public static boolean contains(String text, String searchString) {
        return text.indexOf(searchString) != -1;
    }

    public static int contains(String[] texts, String searchString) {
        return StringUtils.contains(texts, searchString, true);
    }

    public static int containsIgnoreCase(String[] texts, String searchString) {
        return StringUtils.contains(texts, searchString, false);
    }

    private static int contains(String[] texts, String searchString, boolean caseSensitive) {
        for (int i = 0; i < texts.length; ++i) {
            if (!(caseSensitive ? texts[i].equals(searchString) : texts[i].equalsIgnoreCase(searchString))) continue;
            return i;
        }
        return -1;
    }

    public static String encode(String str) {
        return StringUtils.encode(str, StandardCharsets.UTF_8.displayName());
    }

    public static String encode(String str, Charset charset) {
        return StringUtils.encode(str, StandardCharsets.ISO_8859_1, charset);
    }

    public static String encode(String str, Charset fromCharset, Charset toCharset) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if ((fromCharset = LangUtils.pick(fromCharset, StandardCharsets.UTF_8)).equals(toCharset = LangUtils.pick(toCharset, StandardCharsets.UTF_8))) {
            return str;
        }
        return new String(str.getBytes(fromCharset), toCharset);
    }

    public static String encode(String str, String charsetName) {
        Charset charset = LangUtils.ifEmpty(charsetName, () -> StandardCharsets.UTF_8, () -> Charset.forName(charsetName));
        return StringUtils.encode(str, charset);
    }

    public static String encode(String str, String fromCharsetName, String toCharsetName) {
        Charset fromCharset = LangUtils.ifEmpty(fromCharsetName, () -> StandardCharsets.UTF_8, () -> Charset.forName(fromCharsetName));
        Charset toCharset = LangUtils.ifEmpty(toCharsetName, () -> StandardCharsets.UTF_8, () -> Charset.forName(toCharsetName));
        return StringUtils.encode(str, fromCharset, toCharset);
    }

    public static String stringToUnicode(String string) {
        StringBuffer unicode = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            unicode.append("\\u" + Integer.toHexString(c));
        }
        return unicode.toString();
    }

    public static String unicodeToString(String unicode) {
        Matcher matcher = UNICODE_PATTERN.matcher(unicode);
        while (matcher.find()) {
            char ch = (char)Integer.parseInt(matcher.group(2), 16);
            unicode = unicode.replace(matcher.group(1), "" + ch);
        }
        return unicode;
    }

    public static String toUTF8(String str) {
        return StringUtils.encode(str, StandardCharsets.UTF_8);
    }

    public static String toUTF8(String str, String fromEncode) {
        return StringUtils.encode(str, fromEncode, StandardCharsets.UTF_8.displayName());
    }

    public static int toInt(String str, int defaultValue) {
        int returnInt = defaultValue;
        try {
            returnInt = Integer.parseInt(str);
        }
        catch (Exception e) {
            returnInt = defaultValue;
        }
        return returnInt;
    }

    public static long toLong(String str, long defaultValue) {
        long returnInt = defaultValue;
        try {
            returnInt = Long.parseLong(str);
        }
        catch (Exception e) {
            returnInt = defaultValue;
        }
        return returnInt;
    }

    public static double toDouble(String str, double defaultValue) {
        double returnInt = defaultValue;
        try {
            returnInt = Double.parseDouble(str);
        }
        catch (Exception e) {
            returnInt = defaultValue;
        }
        return returnInt;
    }

    public static float toFloat(String str, float defaultValue) {
        float returnInt = defaultValue;
        try {
            returnInt = Float.parseFloat(str);
        }
        catch (Exception e) {
            returnInt = defaultValue;
        }
        return returnInt;
    }

    public static int getLength(String str) {
        return StringUtils.getLength(str, false);
    }

    public static int getLength(String str, boolean needDeleteSpace) {
        if (str == null) {
            return 0;
        }
        if (needDeleteSpace) {
            str = StringUtils.removeSpaces(str);
            return str.length();
        }
        return str.length();
    }

    public static String substringBefore(String str, int index) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        if (str.length() <= index) {
            return str;
        }
        return str.substring(0, index);
    }

    public static String substringAfter(String str, int index) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int length = str.length();
        if (length <= index) {
            return str;
        }
        return str.substring(index + 1, length);
    }

    public static String substringLast(String str, int length) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        int len = str.length();
        if (len <= length) {
            return str;
        }
        return str.substring(len - length);
    }

    public static boolean startsWith(String sourceString, String keyString) {
        if (sourceString == null) {
            return false;
        }
        return sourceString.startsWith(keyString);
    }

    public static boolean endWith(String sourceString, String keyString) {
        if (sourceString == null) {
            return false;
        }
        return sourceString.endsWith(keyString);
    }

    public static String append(String str1, String str2) {
        if (str1 == null) {
            return str2;
        }
        if (str2 == null) {
            return str1;
        }
        return str1 + str2;
    }

    public static String trimBeginEnd(String str, String ts) {
        if (str == null) {
            return "";
        }
        while (str.startsWith(ts)) {
            str = str.substring(ts.length(), str.length());
        }
        while (str.endsWith(ts)) {
            str = str.substring(0, str.length() - ts.length());
        }
        return str;
    }

    public static String trimBeginEndBlank(String str) {
        if (str == null) {
            return "";
        }
        str = str.trim();
        str = StringUtils.trimBeginEnd(str, " ");
        str = StringUtils.trimBeginEnd(str, "\u3000");
        return str;
    }

    public static String getReplaceString(String source, String ... values) {
        return StringUtils.getReplaceString("%", source, values);
    }

    public static String getReplaceString(String prefix, String source, String[] values) {
        Object result = source;
        if (source == null || values == null || values.length < 1) {
            return source;
        }
        if (prefix == null) {
            prefix = "%";
        }
        for (int i = 0; i < values.length; ++i) {
            String argument = prefix + Integer.toString(i + 1);
            int index = ((String)result).indexOf(argument);
            if (index == -1) continue;
            Object temp = ((String)result).substring(0, index);
            temp = i < values.length ? (String)temp + values[i] : (String)temp + values[values.length - 1];
            result = temp = (String)temp + ((String)result).substring(index + 2);
        }
        return result;
    }

    public static String filterHtml(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        StringBuilder html = new StringBuilder();
        block7: for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '&': {
                    html.append("&amp;");
                    continue block7;
                }
                case '<': {
                    html.append("&lt;");
                    continue block7;
                }
                case '>': {
                    html.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    html.append("&#39;");
                    continue block7;
                }
                case '\"': {
                    html.append("&quot;");
                    continue block7;
                }
                default: {
                    html.append(c);
                }
            }
        }
        return html.toString();
    }

    public static String toHtml(String str) {
        if (str == null) {
            return null;
        }
        if (str.length() == 0) {
            return str;
        }
        str = str.replaceAll("&amp;", "&");
        str = str.replaceAll("&lt;", "<");
        str = str.replaceAll("&gt;", ">");
        str = str.replaceAll("&#39;", "'");
        str = str.replaceAll("&quot;", "\"");
        return str;
    }

    public static String appendRequestParams(String uri, String name, String value) {
        if (LangUtils.isNotEmpty((String)uri)) {
            uri = ((String)uri).contains("?") ? (String)uri + "&" : (String)uri + "?";
            uri = (String)uri + name + "=" + value;
        }
        return uri;
    }
}

