/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.number.Radix;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;

public final class NumberUtils {
    private static final char[] LETTERS62;
    private static final char[] LETTERS64;
    private static final char[] LETTERS128;
    private static final int NUMBER_TEN = 10;
    private static final int NUMBER_THREETY_SIX = 36;
    private static final Map<Character, Integer> LETTERS128_DIGITS_MAP;

    private NumberUtils() {
    }

    public static <T extends Number> T convert(Number number, Class<T> targetClass) {
        return NumberUtils.value(number, targetClass);
    }

    public static <T extends Number> T value(Number number, Class<T> toType) {
        if (number == null) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = new Integer(number.intValue());
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = new Long(number.longValue());
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = new Double(number.doubleValue());
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = new Float(number.floatValue());
        } else if (toType == BigInteger.class) {
            value = new BigInteger(number.toString());
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(number.toString());
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = new Byte(number.byteValue());
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = new Short(number.shortValue());
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static <T extends Number> T parse(String source, Class<T> toType) {
        if (Lang.isEmpty(source)) {
            return null;
        }
        Number value = null;
        if (toType == Integer.class || toType == Integer.TYPE) {
            value = new Integer(Integer.parseInt(source));
        } else if (toType == Long.class || toType == Long.TYPE) {
            value = new Long(Long.parseLong(source));
        } else if (toType == Double.class || toType == Double.TYPE) {
            value = new Double(Double.parseDouble(source));
        } else if (toType == Float.class || toType == Float.TYPE) {
            value = new Float(Float.parseFloat(source));
        } else if (toType == BigInteger.class) {
            value = new BigInteger(source);
        } else if (toType == BigDecimal.class) {
            value = new BigDecimal(source);
        } else if (toType == Byte.class || toType == Byte.TYPE) {
            value = new Byte(Byte.parseByte(source));
        } else if (toType == Short.class || toType == Short.TYPE) {
            value = new Short(Short.parseShort(source));
        }
        if (value != null) {
            return (T)value;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u76ee\u6807\u7c7b\u578b\uff1a" + toType.getName());
    }

    public static Byte parse(String target, Byte defaultValue) {
        try {
            return Byte.parseByte(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer parse(String target, Integer defaultValue) {
        try {
            return Integer.parseInt(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long parse(String target, Long defaultValue) {
        try {
            return Long.parseLong(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double parse(String target, Double defaultValue) {
        try {
            return Double.parseDouble(target);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float parse(String target, Float defaultValue) {
        try {
            return Float.valueOf(Float.parseFloat(target));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static <N extends Number> String fillingAtStart(N number, int minLength, char sign) {
        AssertIllegalArgument.isNotNull(number, "N number");
        int requiredLength = minLength - number.toString().length();
        if (requiredLength > 0) {
            StringBuilder pattern = new StringBuilder("'");
            for (int i = 0; i < requiredLength; ++i) {
                pattern.append(sign);
            }
            pattern.append("'#");
            return new DecimalFormat(pattern.toString()).format(number);
        }
        return number.toString();
    }

    public static byte[] toByteArray(int intSource) {
        byte[] bLocalArr = new byte[4];
        for (int i = 0; i < 4 && i < 4; ++i) {
            bLocalArr[i] = (byte)(intSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static int toInt(byte[] bytes) {
        int iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome += (bLoop & 0xFF) << 8 * i;
        }
        return iOutcome;
    }

    public static byte[] toByteArray(short shortSource) {
        byte[] bLocalArr = new byte[2];
        for (int i = 0; i < 4 && i < 2; ++i) {
            bLocalArr[i] = (byte)(shortSource >> 8 * i & 0xFF);
        }
        return bLocalArr;
    }

    public static short toShort(byte[] bytes) {
        short iOutcome = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte bLoop = bytes[i];
            iOutcome = (short)(iOutcome + ((bLoop & 0xFF) << 8 * i));
        }
        return iOutcome;
    }

    public static String toString(byte number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(short number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(int number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(long number, Radix radix) {
        return NumberUtils.toString(BigInteger.valueOf(number), radix);
    }

    public static String toString(BigInteger number, Radix radix) {
        switch (radix) {
            case RADIX62: {
                return NumberUtils.toString62Unit(number);
            }
            case RADIX64: {
                return NumberUtils.toString64Unit(number);
            }
        }
        return number.toString(radix.value());
    }

    public static String toString62Unit(byte number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(short number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(int number) {
        return NumberUtils.toString62Unit((long)number);
    }

    public static String toString62Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS62[(int)(number % (long)Radix.RADIX62.value())]);
            number /= (long)Radix.RADIX62.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString62Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS62[number.mod(BigInteger.valueOf(Radix.RADIX62.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX62.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString64Unit(byte number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(short number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(int number) {
        return NumberUtils.toString64Unit((long)number);
    }

    public static String toString64Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS64[(int)(number % (long)Radix.RADIX64.value())]);
            number /= (long)Radix.RADIX64.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString64Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS64[number.mod(BigInteger.valueOf(Radix.RADIX64.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX64.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString128Unit(byte number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(short number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(int number) {
        return NumberUtils.toString128Unit((long)number);
    }

    public static String toString128Unit(long number) {
        boolean reverse = false;
        if (number < 0L) {
            reverse = true;
            number = 0L - number;
        } else if (number == 0L) {
            return "0";
        }
        StringBuilder buf = new StringBuilder();
        while (number != 0L) {
            buf.append(LETTERS128[(int)(number % (long)Radix.RADIX128.value())]);
            number /= (long)Radix.RADIX128.value();
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static String toString128Unit(BigInteger number) {
        if (number.equals(BigInteger.ZERO)) {
            return "0";
        }
        boolean reverse = false;
        BigInteger abs = number.abs();
        boolean bl = reverse = !abs.equals(number);
        if (reverse) {
            number = abs;
        }
        StringBuilder buf = new StringBuilder();
        while (!number.equals(BigInteger.ZERO)) {
            buf.append(LETTERS128[number.mod(BigInteger.valueOf(Radix.RADIX128.value())).intValue()]);
            number = number.divide(BigInteger.valueOf(Radix.RADIX128.value()));
        }
        if (reverse) {
            buf.append('-');
        }
        return buf.reverse().toString();
    }

    public static BigInteger parse(String numberStr, Radix radix) {
        switch (radix) {
            case RADIX62: {
                return NumberUtils.parse62Unit(numberStr);
            }
            case RADIX64: {
                return NumberUtils.parse64Unit(numberStr);
            }
            case RADIX128: {
                return NumberUtils.parse128Unit(numberStr);
            }
        }
        return new BigInteger(numberStr, radix.value());
    }

    public static int parse62UnitToInt(String numberStr) {
        return NumberUtils.parse62Unit(numberStr).intValue();
    }

    public static long parse62UnitToLong(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        long result = 0L;
        long multiplier = 1L;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX62);
            result += (long)index * multiplier;
            multiplier *= (long)Radix.RADIX62.value();
        }
        if (reverse) {
            return 0L - result;
        }
        return result;
    }

    public static BigInteger parse62Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX62);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX62.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    public static int parse64UnitToInt(String numberStr) {
        return NumberUtils.parse64Unit(numberStr).intValue();
    }

    public static long parse64UnitToLong(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        long result = 0L;
        long multiplier = 1L;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX64);
            result += (long)index * multiplier;
            multiplier *= (long)Radix.RADIX64.value();
        }
        if (reverse) {
            return 0L - result;
        }
        return result;
    }

    public static BigInteger parse64Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX64);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX64.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    public static int parse128UnitToInt(String numberStr) {
        return NumberUtils.parse128Unit(numberStr).intValue();
    }

    public static long parse128UnitToLong(String numberStr) {
        return NumberUtils.parse128Unit(numberStr).longValue();
    }

    public static BigInteger parse128Unit(String numberStr) {
        boolean reverse = false;
        if (numberStr.charAt(0) == '-') {
            reverse = true;
            numberStr = numberStr.substring(1);
        }
        BigInteger result = BigInteger.ZERO;
        BigInteger multiplier = BigInteger.ONE;
        for (int pos = numberStr.length() - 1; pos >= 0; --pos) {
            int index = NumberUtils.getIndex(numberStr, pos, Radix.RADIX128);
            result = result.add(multiplier.multiply(BigInteger.valueOf(index)));
            multiplier = multiplier.multiply(BigInteger.valueOf(Radix.RADIX128.value()));
        }
        if (reverse) {
            return BigInteger.ZERO.subtract(result);
        }
        return result;
    }

    private static int getIndex(String s, int pos, Radix radix) {
        char c = s.charAt(pos);
        Integer value = LETTERS128_DIGITS_MAP.get(Character.valueOf(c));
        switch (radix) {
            case RADIX62: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit62 " + c);
            }
            case RADIX64: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit64 " + c);
            }
            case RADIX128: {
                if (value != null) break;
                throw new IllegalArgumentException("Unknow character for unit128 " + c);
            }
            default: {
                throw new IllegalArgumentException("not support for the radix -> " + radix);
            }
        }
        return value;
    }

    static {
        int i;
        LETTERS128_DIGITS_MAP = new HashMap<Character, Integer>();
        LETTERS62 = new char[Radix.RADIX62.value()];
        LETTERS64 = new char[Radix.RADIX64.value()];
        LETTERS128 = new char[Radix.RADIX128.value()];
        for (i = 0; i < 10; ++i) {
            NumberUtils.LETTERS62[i] = (char)(48 + i);
            NumberUtils.LETTERS64[i] = (char)(48 + i);
        }
        for (i = 10; i < 36; ++i) {
            NumberUtils.LETTERS62[i] = (char)(97 + i - 10);
            NumberUtils.LETTERS64[i] = (char)(97 + i - 10);
        }
        for (i = 36; i < Radix.RADIX62.value(); ++i) {
            NumberUtils.LETTERS62[i] = (char)(65 + i - 36);
            NumberUtils.LETTERS64[i] = (char)(65 + i - 36);
        }
        NumberUtils.LETTERS64[Radix.RADIX62.value()] = 95;
        NumberUtils.LETTERS64[Radix.RADIX62.value() + 1] = 126;
        char max = '\u0000';
        for (char c : LETTERS64) {
            if (c <= max) continue;
            max = c;
        }
        ArrayUtils.fillAll(LETTERS128, LETTERS64);
        ArrayUtils.fillAll(LETTERS128, Radix.RADIX64.value(), new char[]{'\u00a9', '\u00df', '\u00bf', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00b5', '\u00b6', '\u00c0', '\u00c1', '\u00c2', '\u00c4', '\u00c5', '\u00c6', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00e0', '\u00e1', '\u00e2', '\u00e4', '\u00e5', '\u00e6', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00af', '\u00ae'});
        for (int i2 = 0; i2 < LETTERS128.length; ++i2) {
            LETTERS128_DIGITS_MAP.put(Character.valueOf(LETTERS128[i2]), i2);
        }
    }
}

