/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.function.BiConsumer;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return Lang.isEmpty(collection);
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> boolean addAll(Collection<T> collection, T ... elements) {
        if (collection == null) {
            return false;
        }
        if (Lang.isEmpty(elements)) {
            return false;
        }
        return Collections.addAll(collection, elements);
    }

    public static <A> A[] toArray(Collection<A> collection, Class<A> type) {
        AssertIllegalArgument.isNotNull(type, "Class<A> type");
        if (collection == null) {
            collection = new ArrayList<A>();
        }
        return CollectionUtils.doToArray(collection, type);
    }

    public static <A> A[] toArray(Collection<A> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return null;
        }
        Class<?> type = null;
        for (A a : collection) {
            if (a == null) continue;
            type = a.getClass();
        }
        if (type == null) {
            return null;
        }
        return CollectionUtils.doToArray(collection, type);
    }

    private static <A> A[] doToArray(Collection<A> collection, Class<A> type) {
        A[] results = ArrayUtils.create(type, collection.size());
        int i = 0;
        for (A a : collection) {
            results[i] = a;
            ++i;
        }
        return results;
    }

    public static <C extends Collection<E>, E> C newInstance(Class<?> type) {
        AssertIllegalArgument.isParent(Collection.class, type);
        if (ClassUtils.isInstanceClass(type)) {
            return (C)((Collection)ClassUtils.newInstance(type));
        }
        AbstractCollection collection = null;
        if (type == Collection.class) {
            collection = new ArrayList();
        } else if (ClassUtils.isParent(type, ArrayList.class)) {
            collection = new ArrayList();
        } else if (ClassUtils.isParent(type, HashSet.class)) {
            collection = new HashSet();
        } else if (ClassUtils.isParent(type, ArrayDeque.class)) {
            collection = new ArrayDeque();
        }
        if (collection != null) {
            return (C)collection;
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + type.getName());
    }

    public static <K, V> Map<K, V> newMap(Class<?> type) {
        AssertIllegalArgument.isParent(Map.class, type);
        if (ClassUtils.isInstanceClass(type)) {
            return (Map)ClassUtils.newInstance(type);
        }
        if (type == Map.class) {
            return new HashMap();
        }
        throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u7c7b\u578b\uff1a" + type.getName());
    }

    public static <T> void each(Iterable<T> iterable, BiConsumer<T, Integer> consumer) {
        if (iterable != null) {
            int i = 0;
            for (T t : iterable) {
                consumer.accept(t, i);
                ++i;
            }
        }
    }
}

