/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean.matcher;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.common.enums.Logic;

public class BeanPropertyAnnotationMatcher
implements BeanPropertyMatcher {
    private Class<?>[] annotationClasses;
    private Logic logic = Logic.AND;

    public BeanPropertyAnnotationMatcher(Class<?> ... annotationClasses) {
        for (Class<?> annotationClass : annotationClasses) {
            if (annotationClass.isAnnotation()) continue;
            throw new IllegalArgumentException(String.format("\u7c7b%s\u4e0d\u662f\u6ce8\u89e3", annotationClass.getName()));
        }
        this.annotationClasses = annotationClasses;
    }

    public BeanPropertyAnnotationMatcher(Logic logic, Class<?> ... annotationClasses) {
        this(annotationClasses);
        this.logic = logic;
    }

    @Override
    public boolean match(BeanProperty<?> beanProperty) {
        boolean result = false;
        if (this.logic == Logic.AND) {
            for (Class<?> annotationClass : this.annotationClasses) {
                if (beanProperty.hasAnnotation(annotationClass)) continue;
                return false;
            }
            result = true;
        } else {
            for (Class<?> annotationClass : this.annotationClasses) {
                if (!beanProperty.hasAnnotation(annotationClass)) continue;
                return true;
            }
            result = false;
        }
        return result;
    }
}

