/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.tree;

import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.structure.tree.NodeExecutor;
import cn.featherfly.common.structure.tree.TreeNode;
import cn.featherfly.common.structure.tree.TreeNodeMatcher;
import cn.featherfly.common.structure.tree.TreeNodeModel;
import cn.featherfly.common.structure.tree.matcher.TreeNodeEqualsMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleTreeNode<E>
implements Cloneable,
TreeNode<E> {
    private static final Logger LOGGER = LoggerFactory.getLogger(TreeNode.class);
    protected static final int ROOT_DEPTH = 0;
    private String id;
    private TreeNode<E> parentNode;
    private E nodeObject;
    private int depth = 0;
    private List<TreeNode<E>> childNodes = new ArrayList<TreeNode<E>>();

    public SimpleTreeNode(String id) {
        this.id = id;
    }

    @Override
    public List<TreeNode<E>> getAncestors() {
        return this.getAncestors(new ArrayList<TreeNode<E>>(), this);
    }

    private List<TreeNode<E>> getAncestors(List<TreeNode<E>> ancestor, TreeNode<E> node) {
        TreeNode parentNode = (TreeNode)node.getParent();
        if (parentNode != null) {
            ancestor.add(parentNode);
            return this.getAncestors(ancestor, parentNode);
        }
        return ancestor;
    }

    @Override
    public boolean hasAncestor(TreeNode<E> ancestor) {
        TreeNodeModel parentNode = this.getParent();
        if (parentNode == null || ancestor == null) {
            return false;
        }
        boolean is = parentNode.equals(ancestor);
        if (is) {
            return true;
        }
        return parentNode.hasAncestor(ancestor);
    }

    @Override
    public boolean isProgeny(TreeNode<E> ancestor) {
        return this.hasAncestor(ancestor);
    }

    @Override
    public List<TreeNode<E>> getEveryNode() {
        ArrayList<TreeNode<SimpleTreeNode>> nodeList = new ArrayList<TreeNode<SimpleTreeNode>>();
        nodeList.add(this);
        this.getProgenys(nodeList, this);
        return nodeList;
    }

    @Override
    public List<TreeNode<E>> getProgenys() {
        ArrayList<TreeNode<E>> nodeList = new ArrayList<TreeNode<E>>();
        this.getProgenys(nodeList, this);
        return nodeList;
    }

    private void getProgenys(List<TreeNode<E>> nodeList, TreeNode<E> node) {
        if (!node.isLeaf()) {
            for (TreeNode childNode : node.getChildNodes()) {
                nodeList.add(childNode);
                this.getProgenys(nodeList, childNode);
            }
        }
    }

    @Override
    public boolean hasProgeny(TreeNode<E> progeny) {
        if (progeny == null) {
            return false;
        }
        List<TreeNode<E>> childs = this.getChildNodes();
        for (TreeNode<E> child : childs) {
            boolean is = progeny.equals(child);
            if (is) {
                return true;
            }
            is = child.hasProgeny(progeny);
            if (!is) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAncestor(TreeNode<E> progeny) {
        return this.hasProgeny(progeny);
    }

    @Override
    public TreeNode<E> findProgeny(TreeNode<E> progeny) {
        if (progeny == null) {
            return null;
        }
        TreeNodeEqualsMatcher<TreeNode<E>> matcher = new TreeNodeEqualsMatcher<TreeNode<E>>(progeny);
        return this.findTreeNode(matcher, this.getChildNodes());
    }

    @Override
    public TreeNode<E> findProgeny(String progenyId) {
        Iterator<TreeNode<E>> it = this.getChildNodes().iterator();
        while (it.hasNext()) {
            TreeNode node = (TreeNode)it.next().findTreeNode(progenyId);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    @Override
    public TreeNode<E> findTreeNode(TreeNodeMatcher<TreeNode<E>> matcher) {
        if (matcher == null) {
            return null;
        }
        return this.findTreeNode(matcher, this);
    }

    private TreeNode<E> findTreeNode(TreeNodeMatcher<TreeNode<E>> matcher, TreeNode<E> treeNode) {
        if (matcher.match(treeNode)) {
            return treeNode;
        }
        this.findTreeNode(matcher, treeNode.getChildNodes());
        return null;
    }

    private TreeNode<E> findTreeNode(TreeNodeMatcher<TreeNode<E>> matcher, Collection<TreeNode<E>> treeNodes) {
        if (Lang.isNotEmpty(treeNodes)) {
            for (TreeNode<E> child : treeNodes) {
                TreeNode<E> result = null;
                result = ((SimpleTreeNode)child).findTreeNode(matcher, child);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public TreeNode<E> findTreeNode(TreeNode<E> node) {
        if (node == null) {
            return null;
        }
        TreeNodeEqualsMatcher<TreeNode<E>> matcher = new TreeNodeEqualsMatcher<TreeNode<E>>(node);
        return this.findTreeNode((TreeNodeMatcher)matcher);
    }

    @Override
    public TreeNode<E> findTreeNode(String nodeId) {
        if (nodeId == null || "".equals(nodeId)) {
            return null;
        }
        if (nodeId.equals(this.getId())) {
            return this;
        }
        List<TreeNode<E>> childs = this.getChildNodes();
        for (TreeNode<E> child : childs) {
            TreeNode result = null;
            result = (TreeNode)child.findTreeNode(nodeId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public void each(NodeExecutor<TreeNode<E>> executor) {
        executor.execute(this);
        if (!this.isLeaf()) {
            Iterator<TreeNode<E>> iter = this.getChildNodes().iterator();
            while (iter.hasNext()) {
                iter.next().each(executor);
            }
        }
    }

    public void changeDepth(int depth) {
        this.depth = depth;
        if (!this.isLeaf()) {
            for (TreeNode<E> node : this.getChildNodes()) {
                ((SimpleTreeNode)node).changeDepth(depth + 1);
            }
        }
    }

    @Override
    public int indexOf(TreeNode<E> childNode) {
        return this.getChildNodes().indexOf(childNode);
    }

    @Override
    public int getPosition() {
        if (this.getParent() == null || this.getParent().getChildSize() < 2) {
            return 0;
        }
        return this.getParent().indexOf(this);
    }

    @Override
    public boolean hasChildNode(TreeNode<E> childNode) {
        return this.indexOf(childNode) != -1;
    }

    @Override
    public boolean isParent(TreeNode<E> childNode) {
        return this.equals(childNode.getParent());
    }

    @Override
    public boolean isChildNode(TreeNode<E> parentNode) {
        if (parentNode == null) {
            return false;
        }
        return parentNode.hasChildNode(this);
    }

    @Override
    public int getChildSize() {
        return this.getChildNodes().size();
    }

    @Override
    public void addChildNode(TreeNode<E> childNode) {
        this.readyForAddChild(childNode);
        this.getChildNodes().add(childNode);
    }

    public void addChildNodes(TreeNode<E> ... childNodes) {
        if (childNodes == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570childNodes\u4e0d\u80fd\u4e3anull");
        }
        for (TreeNode<E> childNode : childNodes) {
            this.readyForAddChild(childNode);
            this.getChildNodes().add(childNode);
        }
    }

    @Override
    public void addChildNodes(List<TreeNode<E>> childNodes) {
        if (childNodes == null) {
            throw new IllegalArgumentException("\u4f20\u5165\u53c2\u6570childNodes\u4e0d\u80fd\u4e3anull");
        }
        for (TreeNode<E> childNode : childNodes) {
            this.readyForAddChild(childNode);
            this.getChildNodes().add(childNode);
        }
    }

    @Override
    public void insertChildNode(TreeNode<E> childNode, int index) {
        int size = this.getChildNodes().size();
        this.readyForAddChild(childNode);
        if (index > -1 && index < size) {
            this.getChildNodes().add(index, childNode);
        } else {
            this.getChildNodes().add(childNode);
        }
    }

    @Override
    public void insertChildNodeBefore(TreeNode<E> childNode, TreeNode<E> refChildNode) {
        this.readyForAddChild(childNode);
        int index = this.indexOf(refChildNode);
        this.insertChildNode(childNode, index);
    }

    @Override
    public void insertChildNodeAfter(TreeNode<E> childNode, TreeNode<E> refChildNode) {
        this.readyForAddChild(childNode);
        int index = this.indexOf(refChildNode);
        this.insertChildNode(childNode, index);
    }

    @Override
    public void removeChildNode(TreeNode<E> childNode) {
        this.readyForRemoveChild(childNode);
        this.getChildNodes().remove(childNode);
    }

    @Override
    public void removeChildNodes() {
        Iterator<TreeNode<E>> iter = this.getChildNodes().iterator();
        while (iter.hasNext()) {
            this.readyForRemoveChild(iter.next());
        }
        this.getChildNodes().clear();
    }

    @Override
    public void replaceChild(TreeNode<E> newChild, TreeNode<E> oldChild) {
        int index = this.indexOf(oldChild);
        if (index != -1) {
            this.removeChildNode(oldChild);
            this.insertChildNode(newChild, index);
        }
    }

    @Override
    public void mergeChild(TreeNode<E> child) {
        int index = this.indexOf(child);
        if (index != -1) {
            LOGGER.debug("node[{}].mergeChild(node[{}]) as replace", (Object)this.getId(), (Object)child.getId());
            this.removeChildNode(child);
            this.insertChildNode(child, index);
        } else {
            this.addChildNode(child);
        }
    }

    @Override
    public void remove() {
        TreeNodeModel parent = this.getParent();
        if (parent != null) {
            parent.removeChildNode(this);
        }
    }

    @Override
    public TreeNode<E> getFirstChild() {
        if (this.getChildSize() > 0) {
            return this.getChildNodes().get(0);
        }
        return null;
    }

    @Override
    public TreeNode<E> getLastChild() {
        if (this.getChildSize() > 0) {
            return this.getChildNodes().get(this.getChildSize() - 1);
        }
        return null;
    }

    @Override
    public TreeNode<E> getNextSibling() {
        TreeNodeModel parentNode = this.getParent();
        if (parentNode != null) {
            int size = parentNode.getChildSize();
            int index = parentNode.indexOf(this);
            if (size > 0 && size > index + 1) {
                return (TreeNode)parentNode.getChildNodes().get(index + 1);
            }
        }
        return null;
    }

    @Override
    public TreeNode<E> getPreviousSibling() {
        TreeNodeModel parentNode = this.getParent();
        if (parentNode != null) {
            int size = parentNode.getChildSize();
            int index = parentNode.indexOf(this);
            if (size > 0 && index > 0) {
                return (TreeNode)parentNode.getChildNodes().get(index - 1);
            }
        }
        return null;
    }

    @Override
    public boolean isFirst() {
        return this.getPreviousSibling() == null;
    }

    @Override
    public boolean isLast() {
        return this.getNextSibling() == null;
    }

    @Override
    public void sort(Comparator<TreeNode<E>> comparator) {
        Collections.sort(this.getChildNodes(), comparator);
    }

    @Override
    public void sort(Comparator<TreeNode<E>> comparator, boolean containProgeny) {
        if (containProgeny) {
            if (!this.isLeaf()) {
                this.sort(comparator);
                Iterator<TreeNode<E>> iter = this.getChildNodes().iterator();
                while (iter.hasNext()) {
                    iter.next().sort(comparator, containProgeny);
                }
            }
        } else {
            this.sort(comparator);
        }
    }

    private void readyForAddChild(TreeNode<E> childNode) {
        SimpleTreeNode stn = (SimpleTreeNode)childNode;
        stn.depth = this.getDepth() + 1;
        this.readyForSetParent(this, false);
    }

    private void readyForRemoveChild(TreeNode<E> childNode) {
        SimpleTreeNode stn = (SimpleTreeNode)childNode;
        stn.changeDepth(0);
        this.readyForSetParent(null, false);
    }

    private void readyForSetParent(TreeNode<E> parentNode, boolean autoAppendToParent) {
        if (this.parentNode != null) {
            this.parentNode.removeChildNode(this);
        }
        this.parentNode = parentNode;
        if (autoAppendToParent) {
            parentNode.addChildNode(this);
        }
    }

    @Override
    public TreeNode<E> clone() {
        SimpleTreeNode<E> node = new SimpleTreeNode<E>(this.getId());
        node.setNodeObject(this.getNodeObject());
        if (!this.isLeaf()) {
            Iterator<TreeNode<E>> iter = this.getChildNodes().iterator();
            while (iter.hasNext()) {
                Object cloneChild = ((SimpleTreeNode)iter.next()).clone();
                node.addChildNode((TreeNode<E>)cloneChild);
            }
        }
        return node;
    }

    @Override
    public TreeNode<E> cloneAsRoot() {
        SimpleTreeNode node = (SimpleTreeNode)this.clone();
        node.changeDepth(0);
        node.setParentNode(null);
        return node;
    }

    public boolean equals(Object object) {
        if (object == null || !(object instanceof TreeNode)) {
            return false;
        }
        if (Lang.isEmpty(this.getId())) {
            return false;
        }
        TreeNode treeNode = (TreeNode)object;
        return this.getId().equals(treeNode.getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "#" + this.getId().toString();
    }

    @Override
    public E getNodeObject() {
        return this.nodeObject;
    }

    @Override
    public void setNodeObject(E nodeObject) {
        this.nodeObject = nodeObject;
    }

    @Override
    public boolean isRoot() {
        return this.getParent() == null;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildSize() == 0;
    }

    @Override
    public List<TreeNode<E>> getChildNodes() {
        return this.childNodes;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public TreeNode<E> getParent() {
        return this.parentNode;
    }

    public void setParentNode(TreeNode<E> parentNode) {
        this.readyForSetParent(parentNode, true);
    }
}

