/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.page;

import cn.featherfly.common.structure.page.Limit;
import cn.featherfly.common.structure.page.Pagination;

public class SimplePagination
implements Pagination {
    private Integer total;
    private Integer size;
    private Integer number;

    public SimplePagination() {
    }

    public SimplePagination(Limit limit) {
        this(limit.getOffset(), limit.getLimit());
    }

    public SimplePagination(int offset, int limit) {
        this.size = limit;
        this.number = (offset + limit) / limit;
    }

    public SimplePagination setTotal(Integer total) {
        this.total = total;
        return this;
    }

    @Override
    public Integer getTotalPage() {
        return (this.getTotal() + this.size - 1) / this.size;
    }

    @Override
    public Integer getTotal() {
        return this.total;
    }

    public SimplePagination setSize(Integer size) {
        this.size = size;
        return this;
    }

    public SimplePagination setNumber(Integer number) {
        this.number = number;
        return this;
    }

    @Override
    public Integer getSize() {
        return this.size;
    }

    @Override
    public Integer getNumber() {
        return this.number;
    }

    @Deprecated
    public void setPageSize(Integer pageSize) {
        this.size = pageSize;
    }

    @Deprecated
    public void setPageNumber(Integer pageNumber) {
        this.number = pageNumber;
    }

    @Override
    @Deprecated
    public Integer getPageSize() {
        return this.size;
    }

    @Override
    @Deprecated
    public Integer getPageNumber() {
        return this.number;
    }
}

