/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.storage.stream;

import cn.featherfly.common.io.FileUtils;
import cn.featherfly.common.lang.UriUtils;
import cn.featherfly.common.storage.DateLocalDirStorage;
import cn.featherfly.common.storage.StorageException;
import cn.featherfly.common.storage.stream.StreamStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;

public class StreamDateLocalDirStorage
extends DateLocalDirStorage<InputStream>
implements StreamStorage {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String store(InputStream is) {
        ASSERT.isNotNull(is, "param InputStream");
        try {
            File targetFile = this.createTargetFile("stream has no name");
            if (!targetFile.getParentFile().exists()) {
                targetFile.getParentFile().mkdirs();
            }
            try (FileOutputStream os = new FileOutputStream(targetFile);){
                IOUtils.copy((InputStream)is, (OutputStream)os);
                String string = this.getId(targetFile);
                return string;
            }
        }
        catch (IOException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public InputStream retrieve(String id) {
        ASSERT.isNotEmpty(id, "id");
        this.logger.debug("\u5b58\u50a8\u552f\u4e00\u6807\u793a\uff1a{}", (Object)id);
        File file = this.createRelativeDir();
        file = new File(UriUtils.linkUri(file.getAbsolutePath(), id));
        this.logger.debug("\u83b7\u53d6\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw new StorageException(e);
        }
    }

    @Override
    public boolean delete(String id) {
        ASSERT.isNotEmpty(id, "id");
        this.logger.debug("\u5b58\u50a8\u552f\u4e00\u6807\u793a\uff1a{}", (Object)id);
        File file = this.createRelativeDir();
        file = new File(UriUtils.linkUri(file.getAbsolutePath(), id));
        this.logger.debug("\u83b7\u53d6\u6587\u4ef6\uff1a{}", (Object)file.getAbsolutePath());
        return FileUtils.delete(file);
    }
}

