/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.log;

import cn.featherfly.common.bytecode.JavassistUtils;
import cn.featherfly.common.exception.InitException;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.SystemPropertyUtils;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.log.Slf4jLogger;
import java.lang.reflect.Method;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

public class LoggerFactory {
    private static final String LOG4J = "org.slf4j.impl.Log4jLoggerAdapter";
    private static boolean init;

    public static Slf4jLogger getLogger() {
        String className = Lang.getInvoker().getClassName();
        return LoggerFactory.getLogger(className);
    }

    public static Slf4jLogger getLogger(String name) {
        LoggerFactory.init();
        return (Slf4jLogger)org.slf4j.LoggerFactory.getLogger((String)name);
    }

    public static Slf4jLogger getLogger(Class<?> clazz) {
        LoggerFactory.init();
        return (Slf4jLogger)org.slf4j.LoggerFactory.getLogger(clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void init() {
        if (init) return;
        String string = LOG4J;
        synchronized (LOG4J) {
            if (init) return;
            if (!SystemPropertyUtils.getJavaClassPath().contains("slf4j-log4j12")) throw new UnsupportedException("unsupported");
            ClassPool pool = ClassPool.getDefault();
            try {
                CtClass ctClass = pool.get(LOG4J);
                ctClass.addInterface(pool.get(Slf4jLogger.class.getName()));
                LoggerFactory.addMethods(ctClass, pool);
                ctClass.toClass();
                ctClass.detach();
                init = true;
            }
            catch (CannotCompileException | NotFoundException e) {
                throw new InitException(e);
            }
            return;
        }
    }

    private static void addMethods(CtClass ctClass, ClassPool pool) throws NotFoundException, CannotCompileException {
        for (Method method : Slf4jLogger.class.getDeclaredMethods()) {
            CtMethod ctMethod = JavassistUtils.createMethod(method, ctClass, pool);
            ctMethod.setBody(String.format("if (is%sEnabled()) {this.%s($1, $2.get());}", WordUtils.upperCaseFirst(ctMethod.getName()), ctMethod.getName()));
            ctClass.addMethod(ctMethod);
        }
    }
}

