/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.reflect;

import cn.featherfly.common.lang.reflect.MethodParameter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class MethodDescriptor {
    private Method method;
    private MethodParameter[] methodParameters;

    public MethodDescriptor(Method method) {
        this.method = method;
        Class<?>[] types = method.getParameterTypes();
        this.methodParameters = new MethodParameter[types.length];
        for (int i = 0; i < types.length; ++i) {
            Annotation[] as = method.getParameterAnnotations()[i];
            MethodParameter mp = new MethodParameter();
            mp.setAnnotations(as);
            mp.setType(types[i]);
            mp.setMethod(method);
            this.methodParameters[i] = mp;
        }
    }

    public String getName() {
        return this.method.getName();
    }

    public MethodParameter[] getMethodParameters() {
        return this.methodParameters;
    }

    public void setMethodParameters(MethodParameter[] methodParameters) {
        this.methodParameters = methodParameters;
    }

    public Class<?> getReturnType() {
        return this.method.getReturnType();
    }
}

