/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io;

import cn.featherfly.common.io.Properties;
import cn.featherfly.common.lang.Dates;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;

public class PropertiesImpl
implements Properties {
    private Charset charset = StandardCharsets.UTF_8;
    private Map<String, Properties.Part> partMap = new LinkedHashMap<String, Properties.Part>();
    private Properties defaults;
    private static final char[] hexDigit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public PropertiesImpl() {
    }

    public PropertiesImpl(Properties defaults) {
        this(defaults.getCharset());
        this.defaults = defaults;
        int i = 1;
        for (Properties.Part part : defaults.listAll()) {
            if (part instanceof Properties.Property) {
                this.partMap.put(((Properties.Property)part).getKey(), part);
                continue;
            }
            this.partMap.put("comments[" + i + "]", part);
            ++i;
        }
    }

    public PropertiesImpl(Charset charset) {
        if (charset != null) {
            this.charset = charset;
        }
    }

    public PropertiesImpl(java.util.Properties properties) {
        this(properties, null);
    }

    public PropertiesImpl(java.util.Properties properties, Charset charset) {
        this(charset);
        if (properties != null) {
            properties.stringPropertyNames().forEach(pn -> this.setProperty((String)pn, properties.getProperty((String)pn)));
        }
    }

    public String setProperty(String key, String value) {
        return this.setProperty(key, value, null);
    }

    public String setProperty(String key, String value, String comment) {
        Properties.Property property = this.setProperty(new Properties.Property(key, value, comment));
        return property == null ? null : property.getValue();
    }

    public Properties.Property setProperty(Properties.Property property) {
        return (Properties.Property)this.partMap.put(property.getKey(), (Properties.Part)property);
    }

    public String getProperty(String key) {
        Properties.Property p = this.getPropertyPart(key);
        if (Lang.isNotEmpty(p)) {
            return p.getValue();
        }
        return null;
    }

    public String getProperty(String key, String defaultValue) {
        String val = this.getProperty(key);
        return val == null ? defaultValue : val;
    }

    public Properties.Property getPropertyPart(String key) {
        Properties.Property p = (Properties.Property)this.partMap.get(key);
        if (p == null && this.defaults != null) {
            p = this.defaults.getPropertyPart(key);
        }
        return p;
    }

    public Collection<Properties.Property> getPropertyParts() {
        return this.partMap.values().stream().filter(p -> p instanceof Properties.Property).map(p -> (Properties.Property)p).collect(Collectors.toList());
    }

    public Collection<String> getPropertyNames() {
        return this.partMap.keySet();
    }

    private String addComment(String comment) {
        String key = System.currentTimeMillis() + "";
        this.partMap.put(key, (Properties.Part)new Properties.Comment(comment));
        return key;
    }

    public Collection<Properties.Part> listAll() {
        return this.partMap.values();
    }

    public Charset getCharset() {
        return this.charset;
    }

    public java.util.Properties toJdkProperties() {
        java.util.Properties properties = new java.util.Properties();
        this.getPropertyParts().forEach(p -> properties.put(p.getKey(), p.getValue()));
        return properties;
    }

    public void store(OutputStream out) throws IOException {
        this.store0(new BufferedWriter(new OutputStreamWriter(out, this.charset)), this.charset == StandardCharsets.ISO_8859_1, this.charset);
    }

    public void load(InputStream is) throws IOException {
        this.load0(new LineReader(is));
    }

    private void load0(LineReader lr) throws IOException {
        int limit;
        char[] convtBuf = new char[1024];
        String comment = null;
        String commentKey = null;
        boolean firstLine = true;
        while ((limit = lr.readLine()) >= 0) {
            int keyLen;
            char c = '\u0000';
            int valueStart = limit;
            boolean hasSep = false;
            boolean precedingBackslash = false;
            if (('#' == lr.lineBuf[0] || '!' == lr.lineBuf[0]) && Lang.isNotEmpty(comment = this.loadConvert(lr.lineBuf, 0, limit, convtBuf).substring(1))) {
                Properties.CharsetComment cc;
                comment = Strings.encode(comment, StandardCharsets.ISO_8859_1, this.charset);
                if (firstLine && (cc = Properties.CharsetComment.createIfCan((String)comment)) != null) {
                    this.charset = cc.getCharset();
                    firstLine = false;
                    continue;
                }
                commentKey = this.addComment(comment);
                firstLine = false;
                continue;
            }
            firstLine = false;
            for (keyLen = 0; keyLen < limit; ++keyLen) {
                c = lr.lineBuf[keyLen];
                if (!(c != '=' && c != ':' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    hasSep = true;
                    break;
                }
                if (!(c != ' ' && c != '\t' && c != '\f' || precedingBackslash)) {
                    valueStart = keyLen + 1;
                    break;
                }
                precedingBackslash = c == '\\' ? !precedingBackslash : false;
            }
            while (valueStart < limit) {
                c = lr.lineBuf[valueStart];
                if (c != ' ' && c != '\t' && c != '\f') {
                    if (hasSep || c != '=' && c != ':') break;
                    hasSep = true;
                }
                ++valueStart;
            }
            String key = this.loadConvert(lr.lineBuf, 0, keyLen, convtBuf);
            String value = this.loadConvert(lr.lineBuf, valueStart, limit - valueStart, convtBuf);
            this.setProperty(Strings.encode(key, StandardCharsets.ISO_8859_1, this.charset), Strings.encode(value, StandardCharsets.ISO_8859_1, this.charset), comment);
            this.partMap.remove(commentKey);
            comment = null;
        }
    }

    private String loadConvert(char[] in, int off, int len, char[] convtBuf) {
        if (convtBuf.length < len) {
            int newLen = len * 2;
            if (newLen < 0) {
                newLen = Integer.MAX_VALUE;
            }
            convtBuf = new char[newLen];
        }
        char[] out = convtBuf;
        int outLen = 0;
        int end = off + len;
        while (off < end) {
            int aChar;
            if ((aChar = in[off++]) == 92) {
                if ((aChar = in[off++]) == 117) {
                    int value = 0;
                    block6: for (int i = 0; i < 4; ++i) {
                        aChar = in[off++];
                        switch (aChar) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                value = (value << 4) + aChar - 48;
                                continue block6;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                value = (value << 4) + 10 + aChar - 97;
                                continue block6;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                value = (value << 4) + 10 + aChar - 65;
                                continue block6;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                    }
                    out[outLen++] = (char)value;
                    continue;
                }
                if (aChar == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                out[outLen++] = aChar;
                continue;
            }
            out[outLen++] = aChar;
        }
        return new String(out, 0, outLen);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store0(BufferedWriter bw, boolean escUnicode, Charset charset) throws IOException {
        bw.write("#charset=" + charset.displayName() + "\n");
        bw.write("#updated at " + Dates.formatTime(new Date()) + "\n");
        PropertiesImpl propertiesImpl = this;
        synchronized (propertiesImpl) {
            for (Properties.Part part : this.listAll()) {
                if (part instanceof Properties.Property) {
                    Properties.Property property = (Properties.Property)part;
                    String key = this.saveConvert(property.getKey(), true, escUnicode);
                    String val = this.saveConvert(property.getValue(), false, escUnicode);
                    Properties.Property np = new Properties.Property(key, val, Lang.ifNotEmpty(property.getComment(), comm -> this.saveConvert((String)comm, false, escUnicode), () -> ""));
                    bw.write(np.toPart());
                    bw.write("\n");
                    continue;
                }
                Properties.Comment nc = new Properties.Comment();
                if (charset == null || charset == StandardCharsets.ISO_8859_1) {
                    nc.setComment(Strings.stringToUnicode(((Properties.Comment)part).getComment()));
                } else {
                    nc.setComment(((Properties.Comment)part).getComment());
                }
                bw.write(nc.toPart());
                bw.write("\n");
            }
        }
        bw.flush();
    }

    private String saveConvert(String theString, boolean escapeSpace, boolean escapeUnicode) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if ((aChar < ' ' || aChar > '~') & escapeUnicode) {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesImpl.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesImpl.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesImpl.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesImpl.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return hexDigit[nibble & 0xF];
    }

    class LineReader {
        byte[] inByteBuf;
        char[] inCharBuf;
        char[] lineBuf = new char[1024];
        int inLimit = 0;
        int inOff = 0;
        InputStream inStream;
        Reader reader;

        public LineReader(InputStream inStream) {
            this.inStream = inStream;
            this.inByteBuf = new byte[8192];
        }

        public LineReader(Reader reader) {
            this.reader = reader;
            this.inCharBuf = new char[8192];
        }

        int readLine() throws IOException {
            int len = 0;
            char c = '\u0000';
            boolean skipWhiteSpace = true;
            boolean isCommentLine = false;
            boolean isNewLine = true;
            boolean appendedLineBegin = false;
            boolean precedingBackslash = false;
            boolean skipLF = false;
            while (true) {
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (len == 0 || isCommentLine) {
                            return -1;
                        }
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                c = this.inStream != null ? (char)(0xFF & this.inByteBuf[this.inOff++]) : this.inCharBuf[this.inOff++];
                if (skipLF) {
                    skipLF = false;
                    if (c == '\n') continue;
                }
                if (skipWhiteSpace) {
                    if (c == ' ' || c == '\t' || c == '\f' || !appendedLineBegin && (c == '\r' || c == '\n')) continue;
                    skipWhiteSpace = false;
                    appendedLineBegin = false;
                }
                if (isNewLine) {
                    isNewLine = false;
                    if (c == '#' || c == '!') {
                        // empty if block
                    }
                }
                if (c != '\n' && c != '\r') {
                    this.lineBuf[len++] = c;
                    if (len == this.lineBuf.length) {
                        int newLength = this.lineBuf.length * 2;
                        if (newLength < 0) {
                            newLength = Integer.MAX_VALUE;
                        }
                        char[] buf = new char[newLength];
                        System.arraycopy(this.lineBuf, 0, buf, 0, this.lineBuf.length);
                        this.lineBuf = buf;
                    }
                    if (c == '\\') {
                        precedingBackslash = !precedingBackslash;
                        continue;
                    }
                    precedingBackslash = false;
                    continue;
                }
                if (isCommentLine || len == 0) {
                    isCommentLine = false;
                    isNewLine = true;
                    skipWhiteSpace = true;
                    len = 0;
                    continue;
                }
                if (this.inOff >= this.inLimit) {
                    this.inLimit = this.inStream == null ? this.reader.read(this.inCharBuf) : this.inStream.read(this.inByteBuf);
                    this.inOff = 0;
                    if (this.inLimit <= 0) {
                        if (precedingBackslash) {
                            --len;
                        }
                        return len;
                    }
                }
                if (!precedingBackslash) break;
                --len;
                skipWhiteSpace = true;
                appendedLineBegin = true;
                precedingBackslash = false;
                if (c != '\r') continue;
                skipLF = true;
            }
            return len;
        }
    }
}

