/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.structure.page;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.structure.page.Page;

public class Limit {
    private Integer offset;
    private Integer limit;

    public Limit(Integer offset, Integer limit) {
        this.offset = offset == null ? Integer.valueOf(0) : offset;
        AssertIllegalArgument.isNotNull(limit, "Integer limit");
        this.limit = limit;
    }

    public Limit(Page page) {
        AssertIllegalArgument.isNotNull(page, "Page page");
        Integer pageNumber = page.getPageNumber();
        Integer pageSize = page.getPageSize();
        if (pageNumber == null) {
            pageNumber = 1;
        } else if (pageNumber < 1) {
            pageNumber = 1;
        }
        AssertIllegalArgument.isNotNull(pageSize, "page.pageSize");
        this.limit = pageSize;
        this.offset = (pageNumber - 1) * pageSize;
    }

    public Integer getOffset() {
        return this.offset;
    }

    public Integer getLimit() {
        return this.limit;
    }
}

