/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.exception;

import cn.featherfly.common.exception.BaseException;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.locale.ResourceBundleUtils;
import java.nio.charset.Charset;
import java.util.Locale;

public abstract class LocalizedException
extends BaseException {
    private static final long serialVersionUID = -580152334157640022L;
    private Object[] args;
    private Locale locale;
    private String localizedMessage;
    protected Charset charset;

    protected LocalizedException() {
    }

    protected LocalizedException(Throwable ex) {
        super(ex);
    }

    protected LocalizedException(String message, Throwable ex) {
        this(message, new Object[0], ex);
    }

    protected LocalizedException(String message, Object[] args, Locale locale, Throwable ex) {
        super(message, ex);
        this.args = args;
        this.locale = locale;
    }

    protected LocalizedException(String message, Locale locale, Throwable ex) {
        this(message, new Object[0], locale, ex);
    }

    protected LocalizedException(String message, Object[] args, Throwable ex) {
        this(message, args, null, ex);
    }

    protected LocalizedException(String message, Object[] args, Locale locale) {
        super(message);
        this.args = args;
        this.locale = locale;
    }

    protected LocalizedException(String message, Locale locale) {
        this(message, new Object[0], locale);
    }

    protected LocalizedException(String message, Object[] args) {
        super(message);
        this.args = args;
    }

    protected LocalizedException(String message) {
        this(message, new Object[0]);
    }

    @Override
    public String getLocalizedMessage() {
        if (LangUtils.isEmpty(this.localizedMessage)) {
            String message = this.getMessage();
            if (LangUtils.isEmpty(message)) {
                return message;
            }
            int keyIndex = message.indexOf(35);
            char firstChar = message.charAt(0);
            this.localizedMessage = firstChar == '@' && keyIndex != -1 ? ResourceBundleUtils.getString(message, this.args, this.locale, this.charset) : (firstChar == '#' ? ResourceBundleUtils.getString(this.getClass(), message.substring(1), this.args, this.locale, this.charset) : message);
        }
        return this.localizedMessage;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public LocalizedException setCharset(Charset charset) {
        this.charset = charset;
        return this;
    }
}

