/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.BeanPropertyFactory;
import cn.featherfly.common.bean.MapBeanDescriptor;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.bean.ReflectionBeanPropertyFactory;
import cn.featherfly.common.bean.matcher.BeanPropertyMatcher;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.ServiceLoaderUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections4.map.ListOrderedMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptor<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanDescriptor.class);
    private static final Map<Class<?>, BeanDescriptor<?>> BEAN_DESCRIPTORS = new ConcurrentHashMap();
    private static final BeanPropertyFactory FACTORY = ServiceLoaderUtils.load(BeanPropertyFactory.class, new ReflectionBeanPropertyFactory());
    private ListOrderedMap<String, BeanProperty<?>> beanProperties = new ListOrderedMap();
    private Map<String, Type> typeGenericParams = new HashMap<String, Type>(0);
    protected static final String DOT = ".";
    protected Class<T> type;

    protected BeanDescriptor(Class<T> type) {
        this.type = type;
        this.initTypeGenericParam(this.type);
        this.initFromField(this.type);
        this.initFromMethod(this.type);
    }

    protected void initTypeGenericParam(Class<T> type) {
        this.typeGenericParams = ClassUtils.getSuperClassGenricTypeMap(type);
    }

    private void initFromField(Class<?> parent) {
        Field[] fields;
        if (null == parent || parent == Object.class) {
            return;
        }
        for (Field field : fields = parent.getDeclaredFields()) {
            Type genericType = this.typeGenericParams.get(field.getGenericType().toString());
            Class fieldType = null;
            fieldType = genericType == null ? field.getType() : (Class)genericType;
            Method getter = ClassUtils.getGetter(field, this.type);
            Method setter = ClassUtils.getSetter(field, this.type);
            if (getter == null && setter == null) continue;
            BeanProperty prop = FACTORY.create(field.getName(), field, fieldType, setter, getter, this.type, field.getDeclaringClass());
            this.beanProperties.put((Object)prop.getName(), prop);
            if (!LOGGER.isTraceEnabled() || parent == this.type) continue;
            LOGGER.trace("\u7c7b{}\u4ece\u7236\u7c7b{}\u4e2d\u7ee7\u627f\u7684\u5c5e\u6027\uff1a[{}]", new Object[]{this.type.getName(), parent.getName(), prop.getName()});
        }
        this.initFromField(parent.getSuperclass());
    }

    private void initFromMethod(Class<?> type) {
        String propertyName;
        HashMap<String, Map<String, Object>> properties = new HashMap<String, Map<String, Object>>();
        for (Method method : type.getMethods()) {
            Map<String, Object> prop;
            if (method.getDeclaringClass() == Object.class) continue;
            if (ClassUtils.isGetter(method) && !this.hasBeanProperty(propertyName = ClassUtils.getPropertyName(method))) {
                prop = this.getProperty((Map<String, Map<String, Object>>)properties, propertyName);
                prop.put("get", method);
                prop.put("ownerType", type);
            }
            if (!ClassUtils.isSetter(method) || this.hasBeanProperty(propertyName = ClassUtils.getPropertyName(method))) continue;
            prop = this.getProperty((Map<String, Map<String, Object>>)properties, propertyName);
            prop.put("set", method);
            prop.put("ownerType", type);
        }
        for (Map prop : properties.values()) {
            Class<?> propertyType = null;
            Class<?> declaringType = null;
            propertyName = null;
            Method setter = null;
            Method getter = null;
            if (prop.get("get") != null) {
                getter = (Method)prop.get("get");
                declaringType = LangUtils.pick(declaringType, getter.getDeclaringClass());
                propertyType = LangUtils.pick(propertyType, this.getGenericType(getter.getGenericReturnType(), getter.getReturnType()));
                propertyName = LangUtils.pick(propertyName, ClassUtils.getPropertyName(getter));
            }
            if (prop.get("set") != null) {
                setter = (Method)prop.get("set");
                declaringType = LangUtils.pick(declaringType, setter.getDeclaringClass());
                propertyType = LangUtils.pick(propertyType, this.getGenericType(setter.getGenericParameterTypes()[0], setter.getParameterTypes()[0]));
                propertyName = LangUtils.pick(propertyName, ClassUtils.getPropertyName(setter));
            }
            BeanProperty property = FACTORY.create(propertyName, null, propertyType, setter, getter, type, declaringType);
            this.beanProperties.put((Object)property.getName(), property);
            if (!LOGGER.isTraceEnabled()) continue;
            LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027\uff1a[{}]\uff0c \u5b9a\u4e49\u5b50\u7c7b{}", new Object[]{property.getOwnerType().getName(), property.getName(), property.getDeclaringType().getName()});
        }
    }

    private Class<?> getGenericType(Type genericTypeDeclaring, Class<?> genericType) {
        Type gt = this.typeGenericParams.get(genericTypeDeclaring.toString());
        if (gt == null) {
            return genericType;
        }
        return (Class)gt;
    }

    private Map<String, Object> getProperty(Map<String, Map<String, Object>> properties, String propertyName) {
        Map<String, Object> prop = properties.get(propertyName);
        if (prop == null) {
            prop = new HashMap<String, Object>();
            properties.put(propertyName, prop);
        }
        return prop;
    }

    public Collection<BeanProperty<?>> getBeanProperties() {
        return this.beanProperties.values();
    }

    public <E> BeanProperty<E> getBeanProperty(int index) {
        return (BeanProperty)this.beanProperties.getValue(index);
    }

    public <E> BeanProperty<E> getBeanProperty(String name) {
        BeanProperty property = (BeanProperty)this.beanProperties.get((Object)name);
        if (property == null) {
            throw new NoSuchPropertyException(this.type, name);
        }
        return property;
    }

    public boolean hasBeanProperty(String name) {
        return this.beanProperties.get((Object)name) != null;
    }

    public BeanProperty<?> getChildBeanProperty(String name) {
        if (name.contains(DOT)) {
            String currentPropertyName = name.substring(0, name.indexOf(DOT));
            String innerPropertyName = name.substring(name.indexOf(DOT) + 1);
            BeanProperty property = this.getBeanProperty(currentPropertyName);
            BeanDescriptor propertyDescriptor = BeanDescriptor.getBeanDescriptor(property.getType());
            return propertyDescriptor.getChildBeanProperty(innerPropertyName);
        }
        return this.getBeanProperty(name);
    }

    public BeanProperty<?> findBeanProperty(BeanPropertyMatcher condition) {
        for (BeanProperty<?> beanProperty : this.getBeanProperties()) {
            if (!condition.match(beanProperty)) continue;
            return beanProperty;
        }
        return null;
    }

    public Collection<BeanProperty<?>> findBeanPropertys(BeanPropertyMatcher condition) {
        ArrayList coll = new ArrayList();
        for (BeanProperty<?> beanProperty : this.getBeanProperties()) {
            if (!condition.match(beanProperty)) continue;
            coll.add(beanProperty);
        }
        return coll;
    }

    public void setProperty(T obj, String name, Object value) {
        if (name.contains(DOT)) {
            String currentPropertyName = name.substring(0, name.indexOf(DOT));
            String innerPropertyName = name.substring(name.indexOf(DOT) + 1);
            BeanProperty property = this.getBeanProperty(currentPropertyName);
            Object propertyValue = property.getValue(obj);
            BeanDescriptor<Object> propertyDescriptor = null;
            if (propertyValue == null) {
                propertyDescriptor = BeanDescriptor.getBeanDescriptor(property.getType());
                try {
                    if (ClassUtils.isCellection(property.getType())) {
                        LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a\uff0c\u5bf9\u8c61\u4e3aCollection\u63a5\u53e3\u5b9e\u73b0\u7c7b\uff0c\u81ea\u52a8\u521b\u5efa\u8be5\u5c5e\u6027\u5bf9\u8c61", new Object[]{property.getOwnerType().getName(), property.getName()});
                        propertyValue = CollectionUtils.newInstance(property.getType());
                    } else if (ClassUtils.isMap(property.getType())) {
                        LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a\uff0c\u5bf9\u8c61\u4e3aMAP\u63a5\u53e3\uff0c\u81ea\u52a8\u521b\u5efa\u8be5\u5c5e\u6027\u5bf9\u8c61", new Object[]{property.getOwnerType().getName(), property.getName()});
                        propertyValue = CollectionUtils.newMap(property.getType());
                    } else if (property.getType() == Optional.class) {
                        LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a\uff0c\u5bf9\u8c61\u4e3aOptional\u5bb9\u5668\uff0c\u81ea\u52a8\u521b\u5efaOptional\u548c\u5176\u5bf9\u5e94\u7684\u6cdb\u578b\u5bf9\u8c61", new Object[]{property.getOwnerType().getName(), property.getName()});
                        propertyValue = Optional.of(property.getGenericType().newInstance());
                    } else {
                        LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a\uff0c\u81ea\u52a8\u521b\u5efa\u8be5\u5c5e\u6027\u5bf9\u8c61[\u4f7f\u7528newInstance()]", new Object[]{property.getOwnerType().getName(), property.getName()});
                        propertyValue = property.getType().newInstance();
                    }
                    property.setValue(obj, propertyValue);
                }
                catch (Exception e) {
                    throw new IllegalArgumentException(String.format("\u7c7b%s\u7f3a\u5c11\u6ca1\u6709\u53c2\u6570\u7684\u6784\u9020\u51fd\u6570", property.getType().getName()), e);
                }
            } else {
                propertyDescriptor = BeanDescriptor.getBeanDescriptor(propertyValue.getClass());
            }
            propertyDescriptor.setProperty(propertyValue, innerPropertyName, value);
        } else {
            BeanProperty p = this.getBeanProperty(name);
            p.setValue(obj, value);
        }
    }

    public void addProperty(T obj, String name, Object value) {
        BeanProperty<?> beanProperty = this.getChildBeanProperty(name);
        if (ClassUtils.isCellection(beanProperty.getType())) {
            Collection<Object> collection = (Collection)this.getProperty(obj, name);
            if (collection == null) {
                collection = CollectionUtils.newInstance(beanProperty.getType());
                this.setProperty(obj, name, collection);
            }
            collection.add(value);
        } else {
            this.setProperty(obj, name, value);
        }
    }

    public Object getProperty(T obj, String name) {
        if (name.contains(DOT)) {
            String currentPropertyName = name.substring(0, name.indexOf(DOT));
            String innerPropertyName = name.substring(name.indexOf(DOT) + 1);
            BeanProperty property = this.getBeanProperty(currentPropertyName);
            Object propertyValue = property.getValue(obj);
            BeanDescriptor<?> propertyDescriptor = null;
            if (propertyValue == null) {
                LOGGER.trace("\u7c7b{}\u7684\u5c5e\u6027[{}]\u4e3a\u7a7a", new Object[]{property.getOwnerType().getName(), property.getName()});
                return null;
            }
            propertyDescriptor = BeanDescriptor.getBeanDescriptor(propertyValue.getClass());
            return propertyDescriptor.getProperty(propertyValue, innerPropertyName);
        }
        BeanProperty p = this.getBeanProperty(name);
        return p.getValue(obj);
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        try {
            return this.type.getAnnotation(annotationClass);
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public Annotation[] getAnnotations() {
        return this.type.getAnnotations();
    }

    public static <T> BeanDescriptor<T> getBeanDescriptor(Class<T> type) {
        BeanDescriptor<Object> bd = BEAN_DESCRIPTORS.get(type);
        if (bd == null) {
            bd = ClassUtils.isParent(Map.class, type) ? new MapBeanDescriptor(type) : new BeanDescriptor<T>(type);
            BEAN_DESCRIPTORS.put(type, bd);
        }
        return bd;
    }

    public Class<T> getType() {
        return this.type;
    }
}

