/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.matcher;

import cn.featherfly.common.enums.Logic;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import java.lang.reflect.Method;

public class MethodAnnotationMatcher
implements MethodMatcher {
    private Class<?>[] annotationClasses;
    private Logic logic = Logic.AND;

    public MethodAnnotationMatcher(Class<?> ... annotationClasses) {
        for (Class<?> annotationClass : annotationClasses) {
            if (annotationClass.isAnnotation()) continue;
            throw new IllegalArgumentException(String.format("\u7c7b%s\u4e0d\u662f\u6ce8\u89e3", annotationClass.getName()));
        }
        this.annotationClasses = annotationClasses;
    }

    public MethodAnnotationMatcher(Logic logic, Class<?> ... annotationClasses) {
        this(annotationClasses);
        AssertIllegalArgument.isNotNull((Object)logic, "Logic logic");
        this.logic = logic;
    }

    @Override
    public boolean match(Method field) {
        if (LangUtils.isEmpty(this.annotationClasses) || field == null) {
            return false;
        }
        if (this.logic == Logic.AND) {
            return this.matchAnd(field);
        }
        return this.matchOr(field);
    }

    private boolean matchAnd(Method field) {
        for (Class<?> annotationClass : this.annotationClasses) {
            if (field.getAnnotation(annotationClass) != null) continue;
            return false;
        }
        return true;
    }

    private boolean matchOr(Method field) {
        for (Class<?> annotationClass : this.annotationClasses) {
            if (field.getAnnotation(annotationClass) == null) continue;
            return true;
        }
        return false;
    }
}

