/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.executor;

import cn.featherfly.common.lang.executor.Executable;
import cn.featherfly.common.lang.executor.Executor;
import java.util.concurrent.ExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoAsyncExecutor
implements Executor {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ExecutorService executorService;

    @Override
    public Executor execute(Executable executable) {
        if (this.executorService != null) {
            this.logger.debug("execute async");
            this.executorService.execute(() -> executable.execute());
        } else {
            this.logger.debug("execute sync");
            executable.execute();
        }
        return this;
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

