/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.log.LoggerEnabled;
import java.lang.reflect.Field;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);
    private int recursionLevel = 1;
    private boolean enabled = true;

    public static void trace(Logger logger, String msg, LoggerEnabled loggerEnabled) {
        if (logger.isTraceEnabled()) {
            logger.trace(msg, loggerEnabled.arguments());
        }
    }

    public static void debug(Logger logger, String msg, LoggerEnabled loggerEnabled) {
        if (logger.isDebugEnabled()) {
            logger.debug(msg, loggerEnabled.arguments());
        }
    }

    public static void info(Logger logger, String msg, LoggerEnabled loggerEnabled) {
        if (logger.isInfoEnabled()) {
            logger.info(msg, loggerEnabled.arguments());
        }
    }

    public static void warn(Logger logger, String msg, LoggerEnabled loggerEnabled) {
        if (logger.isWarnEnabled()) {
            logger.warn(msg, loggerEnabled.arguments());
        }
    }

    public static void error(Logger logger, String msg, LoggerEnabled loggerEnabled) {
        if (logger.isErrorEnabled()) {
            logger.error(msg, loggerEnabled.arguments());
        }
    }

    public static void debug(Exception e, Logger log) {
        if (log.isDebugEnabled()) {
            log.debug(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void warn(Exception e, Logger log) {
        if (log.isWarnEnabled()) {
            log.warn(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void error(Exception e, Logger log) {
        if (log.isErrorEnabled()) {
            log.error(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void info(Exception e, Logger log) {
        if (log.isInfoEnabled()) {
            log.info(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public static void trace(Exception e, Logger log) {
        if (log.isTraceEnabled()) {
            log.trace(ExceptionUtils.getStackTrace((Throwable)e));
        }
    }

    public void debugObject(Object target, Logger log) {
        this.debugObject(target, log, null);
    }

    public void debugObject(Object target, Logger logger, String desc) {
        try {
            if (this.isEnabled() && logger.isDebugEnabled()) {
                String des = LangUtils.isEmpty(desc) ? "" : desc + " ->\n";
                String logMsg = des + this.getObjectInfo(target);
                logger.debug(logMsg);
            }
        }
        catch (Exception e) {
            LogUtils.debug(e, LOGGER);
        }
    }

    public String getObjectInfo(Object target) {
        try {
            return this.getObjectInfo(target, 1);
        }
        catch (Exception e) {
            LogUtils.debug(e, LOGGER);
            return "null";
        }
    }

    private String getObjectInfo(Object target, int level) throws IllegalAccessException {
        if (target == null) {
            return "null";
        }
        Class<?> tc = target.getClass();
        StringBuilder sb = new StringBuilder();
        String spliter = "\n";
        String tab = "   ";
        Field[] fs = tc.getDeclaredFields();
        sb.append(tc.getName()).append(" {");
        for (Field field : fs) {
            field.setAccessible(true);
            sb.append(spliter);
            for (int i = 0; i < level; ++i) {
                sb.append(tab);
            }
            sb.append(field.getName()).append(" = ");
            Object value = field.get(target);
            Class<?> filedType = field.getType();
            if (ClassUtils.isBasicType(filedType) || ClassUtils.isCellection(filedType) || ClassUtils.isMap(filedType)) {
                sb.append(value);
                continue;
            }
            if (level > this.getRecursionLevel()) {
                sb.append(value);
                continue;
            }
            sb.append(this.getObjectInfo(value, level + 1));
        }
        sb.append(spliter);
        for (int i = 1; i < level; ++i) {
            sb.append(tab);
        }
        sb.append("}");
        return sb.toString();
    }

    public int getRecursionLevel() {
        return this.recursionLevel;
    }

    public void setRecursionLevel(int recursionLevel) {
        if (recursionLevel < 1) {
            recursionLevel = 1;
        }
        this.recursionLevel = recursionLevel;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

