/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.io;

import cn.featherfly.common.io.WatchListener;
import cn.featherfly.common.io.Watcher;
import cn.featherfly.common.lang.AlgorithmUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LogUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtils
extends org.apache.commons.io.FileUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileUtils.class);
    private static final Map<String, Long> FILES = new HashMap<String, Long>();

    private FileUtils() {
    }

    public static boolean isChanged(File file) {
        boolean changed = true;
        String path = file.getPath();
        long lastModified = file.lastModified();
        if (FILES.containsKey(path)) {
            changed = FILES.get(path) != lastModified;
        } else {
            FILES.put(path, lastModified);
        }
        return changed;
    }

    public static void touch(File file) {
        boolean result;
        long currentTime = System.currentTimeMillis();
        if (!file.exists()) {
            LOGGER.warn("file not found:{}", (Object)file.getName());
            LOGGER.debug("Create a new file:{}", (Object)file.getName());
            try {
                if (file.createNewFile()) {
                    LOGGER.info("Succeeded!");
                } else {
                    LOGGER.debug("Create file failed!");
                }
            }
            catch (IOException e) {
                LogUtils.warn(e, LOGGER);
            }
        }
        if (!(result = file.setLastModified(currentTime))) {
            LOGGER.error("touch failed: {}", (Object)file.getName());
        }
    }

    public static void touch(String fileName) {
        File file = new File(fileName);
        FileUtils.touch(file);
    }

    public static void touch(File[] files) {
        for (int i = 0; i < files.length; ++i) {
            FileUtils.touch(files[i]);
        }
    }

    public static void touch(String[] fileNames) {
        File[] files = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            files[i] = new File(fileNames[i]);
        }
        FileUtils.touch(files);
    }

    public static boolean makeDirectory(File file) {
        File parent = file.getParentFile();
        if (parent != null) {
            return parent.mkdirs();
        }
        return false;
    }

    public static boolean makeDirectory(String fileName) {
        File file = new File(fileName);
        return FileUtils.makeDirectory(file);
    }

    public static boolean clearDirectory(File directory) {
        boolean result = true;
        File[] entries = directory.listFiles();
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].delete()) continue;
            result = false;
        }
        return result;
    }

    public static boolean clearDirectory(File directory, boolean cascade) {
        boolean result = true;
        File[] entries = directory.listFiles();
        if (cascade) {
            for (int i = 0; i < entries.length; ++i) {
                if (FileUtils.delete(entries[i])) continue;
                result = false;
            }
        } else {
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].delete()) continue;
                result = false;
            }
        }
        return result;
    }

    public static boolean clearDirectory(String directoryName) {
        File dir = new File(directoryName);
        return FileUtils.clearDirectory(dir);
    }

    public static boolean deleteDir(String dirName) {
        AssertIllegalArgument.isNotEmpty(dirName, "String dirName");
        return FileUtils.deleteDir(new File(dirName));
    }

    public static boolean deleteDir(File dir) {
        AssertIllegalArgument.isNotNull(dir, "File dir");
        AssertIllegalArgument.isExists(dir, "File dir");
        AssertIllegalArgument.isDirectory(dir, "File dir");
        File[] entries = dir.listFiles();
        int sz = entries.length;
        for (int i = 0; i < sz; ++i) {
            if (!(entries[i].isDirectory() ? !FileUtils.deleteDir(entries[i]) : !entries[i].delete())) continue;
            return false;
        }
        return dir.delete();
    }

    public static boolean deleteFile(String fileName) {
        AssertIllegalArgument.isNotEmpty(fileName, "String fileName");
        return FileUtils.deleteFile(new File(fileName));
    }

    public static boolean deleteFile(File file) {
        AssertIllegalArgument.isNotNull(file, "File file");
        AssertIllegalArgument.isExists(file, "File dir");
        AssertIllegalArgument.isFile(file, "File dir");
        return file.delete();
    }

    public static boolean delete(String fileName) {
        AssertIllegalArgument.isNotEmpty(fileName, "String fileName");
        return FileUtils.delete(new File(fileName));
    }

    public static boolean delete(File file) {
        AssertIllegalArgument.isNotNull(file, "File file");
        AssertIllegalArgument.isExists(file, "File file");
        if (file.isDirectory()) {
            return FileUtils.deleteDir(file);
        }
        return FileUtils.deleteFile(file);
    }

    public static File[] listAll(String fileName) {
        return FileUtils.listAll(new File(fileName));
    }

    public static File[] listAll(File file) {
        return FileUtils.listAll(file, f -> true);
    }

    public static File[] listAll(File file, FileFilter filter) {
        ArrayList<File> list = new ArrayList<File>();
        if (!file.exists() || file.isFile()) {
            return null;
        }
        FileUtils.list(list, file, filter);
        File[] files = new File[list.size()];
        return list.toArray(files);
    }

    private static void list(ArrayList<File> list, File file, FileFilter filter) {
        if (filter != null && filter.accept(file)) {
            list.add(file);
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtils.list(list, files[i], filter);
            }
        }
    }

    public static File getRootDir(File file) {
        if (file.getParentFile() != null) {
            return FileUtils.getRootDir(file.getParentFile());
        }
        return file;
    }

    public static File getRootDir() {
        URL resource = FileUtils.class.getResource("/");
        if (resource == null) {
            resource = Thread.currentThread().getContextClassLoader().getResource(".");
        }
        return FileUtils.getRootDir(new File(resource.getPath()));
    }

    public static URI getURI(File file) {
        if (file == null) {
            return null;
        }
        return file.toURI();
    }

    public static long getLength(File file) {
        if (file.exists()) {
            return file.length();
        }
        return -1L;
    }

    public static String getFileName(String filePath) {
        return FileUtils.getFileName(new File(filePath));
    }

    public static String getFileName(File file) {
        if (file == null) {
            return null;
        }
        return file.getName();
    }

    public static String getFilePath(String fileName) {
        return FileUtils.getFilePath(new File(fileName));
    }

    public static String getFilePath(File file) {
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath();
    }

    public static String getParentPath(String path) {
        return FileUtils.getParentPath(new File(path));
    }

    public static String getParentPath(File file) {
        if (file == null) {
            return null;
        }
        return file.getParent();
    }

    public static String getFileExtName(String fileName) {
        return StringUtils.substringAfterLast((String)fileName, (String)".");
    }

    public static String getFileExtName(File file) {
        if (file == null) {
            return "";
        }
        return FileUtils.getFileExtName(file.getAbsolutePath());
    }

    public static String toUnixPath(String filePath) {
        if (filePath == null) {
            return null;
        }
        return filePath.replace('\\', '/');
    }

    public static String getUnixFilePath(String fileName) {
        if (fileName == null) {
            return null;
        }
        File file = new File(fileName);
        return FileUtils.toUnixPath(file.getAbsolutePath());
    }

    public static int getPathIndex(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int point = fileName.indexOf("/");
        if (point == -1) {
            point = fileName.indexOf("\\");
        }
        return point;
    }

    public static int getPathIndex(String fileName, int fromIndex) {
        if (fileName == null) {
            return -1;
        }
        int point = fileName.indexOf("/", fromIndex);
        if (point == -1) {
            point = fileName.indexOf("\\", fromIndex);
        }
        return point;
    }

    public static int getPathLsatIndex(String fileName) {
        if (fileName == null) {
            return -1;
        }
        int point = fileName.lastIndexOf("/");
        if (point == -1) {
            point = fileName.lastIndexOf("\\");
        }
        return point;
    }

    public static int getPathLsatIndex(String fileName, int fromIndex) {
        if (fileName == null) {
            return -1;
        }
        int point = fileName.lastIndexOf("/", fromIndex);
        if (point == -1) {
            point = fileName.lastIndexOf("\\", fromIndex);
        }
        return point;
    }

    public static String trimExtName(String fileName) {
        int index = fileName.lastIndexOf(".");
        if (index != -1) {
            return fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getSubpath(String pathName, String fileName) {
        int index = fileName.indexOf(pathName);
        if (index != -1) {
            return fileName.substring(index + pathName.length() + 1);
        }
        return fileName;
    }

    public static void copyDirectory(String srcDir, String destDir) throws IOException {
        FileUtils.copyDirectory((File)new File(srcDir), (File)new File(destDir));
    }

    public static void copyDirectory(String srcDir, String destDir, FileFilter fileFilter) throws IOException {
        FileUtils.copyDirectory((File)new File(srcDir), (File)new File(destDir), (FileFilter)fileFilter);
    }

    public static void moveDirectory(String srcDir, String destDir) throws IOException {
        FileUtils.moveDirectory((File)new File(srcDir), (File)new File(destDir));
    }

    public static void copyFile(String srcFile, String destFile) throws IOException {
        FileUtils.copyFile((File)new File(srcFile), (File)new File(destFile));
    }

    public static void copyFileToDirectory(String srcFile, String destDir) throws IOException {
        FileUtils.copyFileToDirectory((File)new File(srcFile), (File)new File(destDir));
    }

    public static void moveFile(String srcFile, String destFile) throws IOException {
        FileUtils.moveDirectory((File)new File(srcFile), (File)new File(destFile));
    }

    public static String getFileContent(String filePath, String charset) throws IOException {
        String tempStr = "";
        StringBuilder tempStr2 = new StringBuilder();
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), charset));
        while ((tempStr = in.readLine()) != null) {
            tempStr2.append(tempStr).append("\n");
        }
        in.close();
        return tempStr2.toString();
    }

    public static List<String> getFileContentLines(String filePath, String charset) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        String line = "";
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filePath), charset));
        while ((line = in.readLine()) != null) {
            lines.add(line);
        }
        in.close();
        return lines;
    }

    public static boolean isExist(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean createFile(File file) throws IOException {
        AssertIllegalArgument.isNotNull(file, "File file");
        if (file.isDirectory()) {
            FileUtils.createDirectory(file);
            return true;
        }
        FileUtils.createDirectory(file);
        file.createNewFile();
        return true;
    }

    public static boolean createDirectory(File file) {
        AssertIllegalArgument.isNotNull(file, "File file");
        if (file.isFile()) {
            return file.getParentFile().mkdirs();
        }
        return file.mkdirs();
    }

    public static String getPathInJar(URL resourceUrl) {
        if (resourceUrl == null) {
            return null;
        }
        if (FileUtils.isResourceInJar(resourceUrl)) {
            return StringUtils.substringAfter((String)resourceUrl.getPath(), (String)"!");
        }
        return resourceUrl.getPath();
    }

    public static boolean isResourceInJar(URL resourceUrl) {
        if (resourceUrl == null) {
            return false;
        }
        return "jar".equalsIgnoreCase(resourceUrl.getProtocol());
    }

    public static long crc32(File file) throws IOException {
        return AlgorithmUtils.crc32(new BufferedInputStream(new FileInputStream(file)));
    }

    public static Watcher watch(File dir, WatchListener listener) {
        return FileUtils.watch(dir, listener, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
    }

    public static Watcher watch(File dir, WatchListener listener, WatchEvent.Kind<?> ... events) {
        return FileUtils.watch(Paths.get(dir.toURI()), listener, events);
    }

    public static List<Watcher> watchAll(File dir, WatchListener listener) {
        return FileUtils.watchAll(dir, listener, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
    }

    public static List<Watcher> watchAll(File dir, WatchListener listener, WatchEvent.Kind<?> ... events) {
        return FileUtils.watchAll(dir, listener, (File v) -> true, events);
    }

    public static List<Watcher> watchAll(File dir, WatchListener listener, FileFilter filter) {
        return FileUtils.watchAll(dir, listener, filter, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_MODIFY, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.OVERFLOW);
    }

    public static List<Watcher> watchAll(File dir, WatchListener listener, FileFilter filter, WatchEvent.Kind<?> ... events) {
        return FileUtils.watch(Arrays.stream(FileUtils.listAll(dir, v -> v.isDirectory() && filter.accept(v))).map(d -> Paths.get(d.toURI())).collect(Collectors.toList()), listener, events);
    }

    private static List<Watcher> watch(List<Path> paths, WatchListener listener, WatchEvent.Kind<?>[] events) {
        ArrayList<Watcher> watchers = new ArrayList<Watcher>();
        for (Path path : paths) {
            watchers.add(FileUtils.watch(path, listener, events));
        }
        return watchers;
    }

    private static Watcher watch(Path watchDirectory, WatchListener listener, WatchEvent.Kind<?>[] events) {
        Watcher watcher = new Watcher(watchDirectory, listener, events);
        watcher.watch();
        return watcher;
    }
}

