/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.AssertIllegalArgument;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Dates {
    private static final Logger LOGGER = LoggerFactory.getLogger(Dates.class);
    private static final String FORMART_DATE = "yyyy-MM-dd";
    private static final String FORMART_TIME = "yyyy-MM-dd HH:mm:ss";
    private static final DateTimeFormatter FORMATTER_DATE = DateTimeFormatter.ofPattern("yyyy-MM-dd");
    private static final DateTimeFormatter FORMATTER_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final String MSG_START_AFTER_END = "\u5f00\u59cb\u65e5\u671fstartDate\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671fendDate";
    public static final int MONDAY = 1;
    public static final int TUESDAY = 2;
    public static final int WEDNESDAY = 3;
    public static final int THURSDAY = 4;
    public static final int FRIDAY = 5;
    public static final int SATURDAY = 6;
    public static final int SUNDAY = 7;
    public static final int COMPARE_LT = -1;
    public static final int COMPARE_EQ = 0;
    public static final int COMPARE_GT = 1;

    private Dates() {
    }

    public static long getTime(LocalDateTime localDateTime) {
        return Dates.getTime(localDateTime, ZoneId.systemDefault());
    }

    public static long getTime(LocalDateTime localDateTime, ZoneId zoneId) {
        if (localDateTime == null) {
            return 0L;
        }
        if (zoneId == null) {
            zoneId = ZoneId.systemDefault();
        }
        return localDateTime.atZone(zoneId).toInstant().toEpochMilli();
    }

    public static LocalDateTime toLocalDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static LocalDate toLocalDate(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalTime toLocalTime(Date date) {
        if (date == null) {
            return null;
        }
        return date.toInstant().atZone(ZoneId.systemDefault()).toLocalTime();
    }

    public static Date toDate(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return null;
        }
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static String formatDate(LocalDateTime localDateTime) {
        return localDateTime.format(FORMATTER_DATE);
    }

    public static String formatTime(LocalDateTime localDateTime) {
        return Dates.format(localDateTime, FORMATTER_TIME);
    }

    public static String format(LocalDateTime localDateTime, String format) {
        LOGGER.debug("formart : formart={} ||| localDateTime ={}", new Object[]{format, localDateTime});
        return Dates.format(localDateTime, DateTimeFormatter.ofPattern(format));
    }

    private static String format(LocalDateTime localDateTime, DateTimeFormatter formartter) {
        if (localDateTime != null) {
            return localDateTime.format(formartter);
        }
        return "";
    }

    public static String formatDate(Date date) {
        return Dates.format(date, FORMART_DATE);
    }

    public static String formatTime(Date date) {
        return Dates.format(date, FORMART_TIME);
    }

    public static String format(Date date, String format) {
        LOGGER.debug("formartDate: formart={} ||| date={}", new Object[]{format, date});
        if (date != null) {
            SimpleDateFormat df = new SimpleDateFormat(format);
            return df.format(date);
        }
        return "";
    }

    public static Date parseDate(String strDate) {
        return Dates.parse(strDate, FORMART_DATE);
    }

    public static Date parseTime(String strDate) {
        return Dates.parse(strDate, FORMART_TIME);
    }

    public static Date parse(String strDate, String formart) {
        LOGGER.debug("parse: formart={} ||| strDate={}", new Object[]{formart, strDate});
        AssertIllegalArgument.isNotBlank(strDate, "String strDate");
        AssertIllegalArgument.isNotBlank(formart, "String formart");
        SimpleDateFormat format = new SimpleDateFormat(formart);
        try {
            return format.parse(strDate);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Date getDate(int year, int month, int day) {
        return Dates.toDate(LocalDate.of(year, month, day));
    }

    public static Date getTime(int year, int month, int day, int hour, int minute, int second) {
        return Dates.toDate(LocalDateTime.of(year, month, day, hour, minute, second));
    }

    public static int getCurrentYear() {
        return LocalDate.now().getYear();
    }

    public static int getCurrentMonth() {
        return LocalDate.now().getMonthValue();
    }

    public static int getCurrentDayOfMonth() {
        return LocalDate.now().getDayOfMonth();
    }

    public static int getCurrentDayOfWeek() {
        return LocalDate.now().getDayOfWeek().getValue();
    }

    public static int getCurrentHour() {
        return LocalTime.now().getHour();
    }

    public static int getCurrentMinute() {
        return LocalTime.now().getMinute();
    }

    public static int getCurrentSecond() {
        return LocalTime.now().getSecond();
    }

    public static int getYear(Date date) {
        return Dates.toLocalDate(date).getYear();
    }

    public static int getMonth(Date date) {
        return Dates.toLocalDate(date).getMonthValue();
    }

    public static int getDayOfMonth(Date date) {
        return Dates.toLocalDate(date).getDayOfMonth();
    }

    public static int getDayOfWeek(Date date) {
        return Dates.toLocalDate(date).getDayOfWeek().getValue();
    }

    public static int getDayOfYear(Date date) {
        return Dates.toLocalDate(date).getDayOfYear();
    }

    public static int getWeekOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.setFirstDayOfWeek(2);
        return c.get(3);
    }

    public static int getHour(Date date) {
        return Dates.toLocalTime(date).getHour();
    }

    public static int getMinute(Date date) {
        return Dates.toLocalTime(date).getMinute();
    }

    public static int getSecond(Date date) {
        return Dates.toLocalTime(date).getSecond();
    }

    public static long getTime(Date date, TimeType type) {
        long result = 0L;
        if (date != null) {
            switch (type) {
                case millisecond: {
                    result = date.getTime();
                    break;
                }
                case second: {
                    result = date.getTime() / 1000L;
                    break;
                }
                case minute: {
                    result = date.getTime() / 1000L / 60L;
                    break;
                }
                case hour: {
                    result = date.getTime() / 1000L / 60L / 60L;
                    break;
                }
                case day: {
                    result = date.getTime() / 1000L / 60L / 60L / 24L;
                    break;
                }
                default: {
                    result = date.getTime();
                }
            }
        }
        return result;
    }

    public static int compareYear(Date firstDate, Date secondDate) {
        String formart = "yyyy";
        return Dates.compare(firstDate, secondDate, "yyyy");
    }

    public static int compareMonth(Date firstDate, Date secondDate) {
        String formart = "yyyyMM";
        return Dates.compare(firstDate, secondDate, "yyyyMM");
    }

    public static int compareDay(Date firstDate, Date secondDate) {
        String formart = "yyyyMMdd";
        return Dates.compare(firstDate, secondDate, "yyyyMMdd");
    }

    public static int compareHour(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHH";
        return Dates.compare(firstDate, secondDate, "yyyyMMddHH");
    }

    public static int compareMinute(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHHmm";
        return Dates.compare(firstDate, secondDate, "yyyyMMddHHmm");
    }

    public static int compareSecond(Date firstDate, Date secondDate) {
        String formart = "yyyyMMddHHmmss";
        return Dates.compare(firstDate, secondDate, "yyyyMMddHHmmss");
    }

    public static boolean beforeYear(Date firstDate, Date secondDate) {
        return -1 == Dates.compareYear(firstDate, secondDate);
    }

    public static boolean equalsYear(Date firstDate, Date secondDate) {
        return 0 == Dates.compareYear(firstDate, secondDate);
    }

    public static boolean afterYear(Date firstDate, Date secondDate) {
        return 1 == Dates.compareYear(firstDate, secondDate);
    }

    public static boolean beforeMonth(Date firstDate, Date secondDate) {
        return -1 == Dates.compareMonth(firstDate, secondDate);
    }

    public static boolean equalsMonth(Date firstDate, Date secondDate) {
        return 0 == Dates.compareMonth(firstDate, secondDate);
    }

    public static boolean afterMonth(Date firstDate, Date secondDate) {
        return 1 == Dates.compareMonth(firstDate, secondDate);
    }

    public static boolean beforeDay(Date firstDate, Date secondDate) {
        return -1 == Dates.compareDay(firstDate, secondDate);
    }

    public static boolean equalsDay(Date firstDate, Date secondDate) {
        return 0 == Dates.compareDay(firstDate, secondDate);
    }

    public static boolean afterDay(Date firstDate, Date secondDate) {
        return 1 == Dates.compareDay(firstDate, secondDate);
    }

    public static boolean beforeHour(Date firstDate, Date secondDate) {
        return -1 == Dates.compareHour(firstDate, secondDate);
    }

    public static boolean equalsHour(Date firstDate, Date secondDate) {
        return 0 == Dates.compareHour(firstDate, secondDate);
    }

    public static boolean afterHour(Date firstDate, Date secondDate) {
        return 1 == Dates.compareHour(firstDate, secondDate);
    }

    public static boolean beforeMinute(Date firstDate, Date secondDate) {
        return -1 == Dates.compareMinute(firstDate, secondDate);
    }

    public static boolean equalsMinute(Date firstDate, Date secondDate) {
        return 0 == Dates.compareMinute(firstDate, secondDate);
    }

    public static boolean afterMinute(Date firstDate, Date secondDate) {
        return 1 == Dates.compareMinute(firstDate, secondDate);
    }

    public static boolean beforeSecond(Date firstDate, Date secondDate) {
        return -1 == Dates.compareSecond(firstDate, secondDate);
    }

    public static boolean equalsSecond(Date firstDate, Date secondDate) {
        return 0 == Dates.compareSecond(firstDate, secondDate);
    }

    public static boolean afterSecond(Date firstDate, Date secondDate) {
        return 1 == Dates.compareSecond(firstDate, secondDate);
    }

    public static int getMaxDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(2, cal.get(2) + 1);
        cal.set(5, 1);
        cal.add(5, -1);
        return cal.get(5);
    }

    public static int getMaxDayOfMonth(int year, int month) {
        int lastMonth = 12;
        AssertIllegalArgument.isInRange(month, 1, 12, "month");
        return Dates.getMaxDayOfMonth(Dates.getDate(year, month, 1));
    }

    public static int getYearNumber(Date startDate, Date endDate) {
        return Dates.getYearNumber(startDate, endDate, true, true);
    }

    public static int getYearNumber(Date startDate, Date endDate, boolean computeMonth, boolean computeDay) {
        Dates.checkNull(startDate, endDate);
        int startYear = Dates.getYear(startDate);
        int endYear = Dates.getYear(endDate);
        Dates.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int years = endYear - startYear;
        if (computeMonth) {
            int endDay;
            int startDay;
            int endMonth;
            int startMonth = Dates.getMonth(startDate);
            if (startMonth > (endMonth = Dates.getMonth(endDate))) {
                --years;
            } else if (startMonth == endMonth && computeDay && (startDay = Dates.getDayOfMonth(startDate)) > (endDay = Dates.getDayOfMonth(endDate))) {
                --years;
            }
        }
        return years;
    }

    public static int getMonthNumber(Date startDate, Date endDate) {
        return Dates.getMonthNumber(startDate, endDate, true);
    }

    public static int getMonthNumber(Date startDate, Date endDate, boolean computeDay) {
        Dates.checkNull(startDate, endDate);
        int startYear = Dates.getYear(startDate);
        int startMonth = Dates.getMonth(startDate);
        int endYear = Dates.getYear(endDate);
        int endMonth = Dates.getMonth(endDate);
        Dates.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int months = 0;
        for (int i = startYear; i <= endYear; ++i) {
            if (i == startYear) {
                months += 12 - startMonth;
                continue;
            }
            if (i == endYear) {
                months += endMonth;
                continue;
            }
            months += 12;
        }
        int startDay = Dates.getDayOfMonth(startDate);
        int endDay = Dates.getDayOfMonth(endDate);
        if (computeDay && startDay > endDay) {
            --months;
        }
        return months;
    }

    public static int getDayNumber(Date startDate, Date endDate) {
        int endDay;
        Dates.checkNull(startDate, endDate);
        int startYear = Dates.getYear(startDate);
        int endYear = Dates.getYear(endDate);
        Dates.isTrue(startYear <= endYear, MSG_START_AFTER_END);
        int days = 0;
        for (int i = 0; i < endYear - startYear; ++i) {
            int maxDayOfMonth = Dates.getMaxDayOfMonth(startYear, 2);
            if (maxDayOfMonth == 28) {
                days += 365;
                continue;
            }
            days += 366;
        }
        int startDay = Dates.getDayOfYear(startDate);
        Dates.isTrue(startDay <= (endDay = Dates.getDayOfYear(endDate)), MSG_START_AFTER_END);
        return days + endDay - startDay + 1;
    }

    public static int getWorkDayNumber(Date startDate, Date endDate) {
        Dates.checkNull(startDate, endDate);
        int startDay = Dates.getDayOfYear(startDate);
        int endDay = Dates.getDayOfYear(endDate);
        Dates.isTrue(startDay <= endDay, MSG_START_AFTER_END);
        int days = 0;
        Calendar cal = null;
        while (startDate.before(endDate) || startDate.equals(endDate)) {
            cal = Calendar.getInstance();
            cal.setTime(startDate);
            if (cal.get(7) != 7 && cal.get(7) != 1) {
                ++days;
            }
            cal.add(5, 1);
            startDate = cal.getTime();
        }
        return days;
    }

    public static int getAge(Date birthday) {
        AssertIllegalArgument.isNotNull(birthday, "Date birthday");
        return Dates.getAge(birthday, new Date());
    }

    public static int getAge(Date birthday, Date compareDay) {
        AssertIllegalArgument.isNotNull(birthday, "Date birthday");
        AssertIllegalArgument.isNotNull(compareDay, "Date compareDay");
        Dates.isTrue(Dates.beforeDay(birthday, compareDay) || Dates.equalsDay(birthday, compareDay), "birthday\u4e0d\u80fd\u665a\u4e8ecompareDay");
        int age = Dates.getYear(compareDay) - Dates.getYear(birthday);
        if (Dates.compare(compareDay, birthday, "MMdd") == -1) {
            --age;
        }
        return age;
    }

    private static int compare(Date firstDate, Date secondDate, String formart) {
        Dates.checkNull(firstDate, secondDate);
        long first = Long.parseLong(Dates.format(firstDate, formart));
        long second = Long.parseLong(Dates.format(secondDate, formart));
        if (first < second) {
            return -1;
        }
        if (first == second) {
            return 0;
        }
        return 1;
    }

    private static void checkNull(Date firstDate, Date secondDate) {
        AssertIllegalArgument.isNotNull(firstDate, "Date firstDate");
        AssertIllegalArgument.isNotNull(secondDate, "Date secondDate");
    }

    private static void isTrue(boolean exp, String msg) {
        if (!exp) {
            throw new IllegalArgumentException(msg);
        }
    }

    public static enum TimeType {
        millisecond,
        second,
        minute,
        hour,
        day;

    }
}

