/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.data;

import cn.featherfly.common.data.Matcher;
import cn.featherfly.common.enums.Logic;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.CollectionUtils;
import cn.featherfly.common.lang.Lang;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class GroupMatcher<M extends Matcher<O>, O>
implements Matcher<O> {
    private Logic logic = Logic.AND;
    private Set<M> matchers = new HashSet<M>();

    public GroupMatcher() {
    }

    public GroupMatcher(M ... matchers) {
        CollectionUtils.addAll(this.matchers, matchers);
    }

    public GroupMatcher(Logic logic, M ... matchers) {
        this.setLogic(logic);
        CollectionUtils.addAll(this.matchers, matchers);
    }

    @Override
    public boolean test(O o) {
        if (Lang.isEmpty(this.matchers)) {
            return false;
        }
        if (this.logic == Logic.AND) {
            return this.matchAnd(o, this.matchers);
        }
        return this.matchOr(o, this.matchers);
    }

    public void addMatcher(M matcher) {
        this.matchers.add(matcher);
    }

    public void addMatcher(M ... matchers) {
        CollectionUtils.addAll(this.matchers, matchers);
    }

    public void addMatcher(Collection<M> matchers) {
        this.matchers.addAll(matchers);
    }

    private boolean matchAnd(O o, Collection<M> matchers) {
        boolean matchResult = false;
        for (Matcher matcher : matchers) {
            matchResult = matcher.test(o);
            if (matchResult) continue;
            return false;
        }
        return true;
    }

    private boolean matchOr(O o, Collection<M> matchers) {
        boolean matchResult = false;
        for (Matcher matcher : matchers) {
            matchResult = matcher.test(o);
            if (!matchResult) continue;
            return true;
        }
        return false;
    }

    public Logic getLogic() {
        return this.logic;
    }

    public void setLogic(Logic logic) {
        AssertIllegalArgument.isNotNull((Object)logic, "Logic logic");
        this.logic = logic;
    }

    public Set<M> getMatchers() {
        return this.matchers;
    }

    public void setMatchers(Set<M> matchers) {
        this.matchers = matchers;
    }
}

