/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.exception.ReflectException;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.GenericType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanProperty<T>
implements GenericType<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BeanProperty.class);
    private String name;
    private Class<T> type;
    private Method setter;
    private Method getter;
    private Field field;
    private Class<?> ownerType;
    private Class<?> declaringType;
    private Collection<Annotation> annotations;

    protected BeanProperty(String propertyName, Field field, Class<T> propertyType, Method setter, Method getter, Class<?> ownerType, Class<?> declaringType) {
        this.ownerType = ownerType;
        this.declaringType = declaringType;
        this.field = field;
        this.name = propertyName;
        this.type = propertyType;
        this.setter = setter;
        this.getter = getter;
        this.initAnnotation();
    }

    private void initAnnotation() {
        this.annotations = new HashSet<Annotation>();
        if (this.isWritable()) {
            for (Annotation a : this.setter.getAnnotations()) {
                this.annotations.add(a);
            }
        }
        if (this.isReadable()) {
            for (Annotation a : this.getter.getAnnotations()) {
                this.annotations.add(a);
            }
        }
        if (this.field != null) {
            for (Annotation a : this.field.getAnnotations()) {
                this.annotations.add(a);
            }
        }
    }

    public void setValue(Object obj, Object value) {
        this.checkType(obj.getClass());
        if (this.isWritable()) {
            try {
                if (this.type == Optional.class) {
                    this.setter.invoke(obj, Optional.of(value));
                }
                this.setter.invoke(obj, value);
            }
            catch (Exception e) {
                throw new ReflectException(e);
            }
        } else {
            LOGGER.warn("{}\u7c7b\u578b\u5bf9\u8c61\u7684\u5c5e\u6027\uff1a{} \u4e0d\u53ef\u5199", new Object[]{obj.getClass().getName(), this.name});
            return;
        }
    }

    public void setValueForce(Object obj, Object value) {
        if (this.isWritable()) {
            this.setValue(obj, value);
        } else if (this.field != null) {
            this.checkType(obj.getClass());
            try {
                this.field.setAccessible(true);
                if (this.type == Optional.class) {
                    this.field.set(obj, Optional.of(value));
                } else {
                    this.field.set(obj, value);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public Object getValue(Object obj) {
        this.checkType(obj.getClass());
        if (this.isReadable()) {
            try {
                return this.getter.invoke(obj, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        LOGGER.warn("{}\u7c7b\u578b\u5bf9\u8c61\u7684\u5c5e\u6027\uff1a{}\u4e0d\u53ef\u8bfb", (Object)obj.getClass().getName(), (Object)this.name);
        return null;
    }

    public Object getValueForce(Object obj) {
        if (this.isReadable()) {
            return this.getValue(obj);
        }
        if (this.field == null) {
            return null;
        }
        this.checkType(obj.getClass());
        try {
            this.field.setAccessible(true);
            return this.field.get(obj);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isReadable() {
        return this.getter != null;
    }

    public boolean isWritable() {
        return this.setter != null;
    }

    public Class<?> getGenericType() {
        if (this.field != null) {
            return ClassUtils.getFieldGenericParameterType(this.ownerType, this.field);
        }
        if (this.getter != null) {
            return ClassUtils.getMethodReturnTypeGenericParameterType(this.ownerType, this.getter);
        }
        return ClassUtils.getMethodGenericParameterType(this.ownerType, this.setter);
    }

    public List<Class<?>> getGenericTypes() {
        if (this.field != null) {
            return ClassUtils.getFieldGenericParameterTypes(this.ownerType, this.field);
        }
        if (this.getter != null) {
            return ClassUtils.getMethodReturnTypeGenericParameterTypes(this.ownerType, this.getter);
        }
        return ClassUtils.getMethodGenericParameterTypes(this.ownerType, this.setter);
    }

    public <A extends Annotation> boolean hasAnnotation(Class<A> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <A extends Annotation> A getAnnotation(Class<A> annotationClass) {
        if (annotationClass == null) {
            return null;
        }
        for (Annotation annotation : this.annotations) {
            if (!annotation.annotationType().equals(annotationClass)) continue;
            Annotation a = annotation;
            return (A)a;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        return this.annotations.toArray(new Annotation[0]);
    }

    public String toString() {
        return String.format("%s#%s[%s]", this.ownerType.getName(), this.getName(), this.type.getName());
    }

    private void checkType(Class<?> objClass) {
        AssertIllegalArgument.isParent(this.ownerType, objClass);
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    public Field getField() {
        return this.field;
    }

    public Class<?> getOwnerType() {
        return this.ownerType;
    }

    public Class<?> getDeclaringType() {
        return this.declaringType;
    }

    public int hashCode() {
        if (this.field != null) {
            return this.field.hashCode();
        }
        if (this.getter != null) {
            return this.getter.hashCode();
        }
        return this.setter.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != BeanProperty.class) {
            return false;
        }
        BeanProperty target = (BeanProperty)obj;
        if (this.field != null) {
            return this.field.equals(target.field);
        }
        if (this.getter != null) {
            return this.getter.equals(target.getter);
        }
        return this.setter.equals(target.setter);
    }

    @Override
    public String getTypeName() {
        return this.type.getName();
    }
}

