/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang.matcher;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.matcher.MethodMatcher;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodReturnTypeMatcher
implements MethodMatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodReturnTypeMatcher.class);
    private Class<?> returnType;
    private boolean matchSubType;

    public MethodReturnTypeMatcher(Class<?> returnType) {
        this.returnType = returnType;
    }

    public MethodReturnTypeMatcher(Class<?> returnType, boolean matchSubType) {
        this.returnType = returnType;
        this.matchSubType = matchSubType;
    }

    @Override
    public boolean test(Method method) {
        if (this.returnType == null || method == null) {
            return false;
        }
        if (this.matchSubType) {
            LOGGER.debug("{} \u5339\u914d\u7c7b\u578b\uff08\u5305\u542b\u5b50\u7c7b\u578b\uff09 {}", (Object)this.returnType.getName(), (Object)method.getReturnType().getName());
            return ClassUtils.isParent(this.returnType, method.getReturnType());
        }
        LOGGER.debug("{} \u5339\u914d\u7c7b\u578b {}", (Object)this.returnType.getName(), (Object)method.getReturnType().getName());
        return this.returnType == method.getReturnType();
    }
}

