/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.lang;

import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.NumberUtils;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;

public final class ArrayUtils {
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final long[] EMPTY_LONG_ARRAY = new long[0];
    public static final Long[] EMPTY_LONG_OBJECT_ARRAY = new Long[0];
    public static final int[] EMPTY_INT_ARRAY = new int[0];
    public static final Integer[] EMPTY_INTEGER_OBJECT_ARRAY = new Integer[0];
    public static final short[] EMPTY_SHORT_ARRAY = new short[0];
    public static final Short[] EMPTY_SHORT_OBJECT_ARRAY = new Short[0];
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final Byte[] EMPTY_BYTE_OBJECT_ARRAY = new Byte[0];
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];
    public static final float[] EMPTY_FLOAT_ARRAY = new float[0];
    public static final Float[] EMPTY_FLOAT_OBJECT_ARRAY = new Float[0];
    public static final boolean[] EMPTY_BOOLEAN_ARRAY = new boolean[0];
    public static final Boolean[] EMPTY_BOOLEAN_OBJECT_ARRAY = new Boolean[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Character[] EMPTY_CHARACTER_OBJECT_ARRAY = new Character[0];

    private ArrayUtils() {
    }

    public static boolean isEmpty(Object array) {
        if (array == null) {
            return true;
        }
        if (array.getClass().isArray()) {
            return Array.getLength(array) == 0;
        }
        return false;
    }

    public static boolean isNotEmpty(Object array) {
        return !ArrayUtils.isEmpty(array);
    }

    public static <T> void each(BiConsumer<T, Integer> consumer, T ... array) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                consumer.accept(array[i], i);
            }
        }
    }

    public static <T> void each(T[] array, BiConsumer<Object, Integer> consumer) {
        if (array != null) {
            for (int i = 0; i < array.length; ++i) {
                consumer.accept(array[i], i);
            }
        }
    }

    public static void each(Object array, BiConsumer<Object, Integer> consumer) {
        if (array != null) {
            if (array.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(array); ++i) {
                    consumer.accept(Array.get(array, i), i);
                }
            } else {
                consumer.accept(array, 0);
            }
        }
    }

    public static <A> String toString(A[] array, char linkSymbol) {
        StringBuilder sb = new StringBuilder();
        for (A a : array) {
            if (a == null) {
                sb.append("null");
            } else {
                sb.append(a);
            }
            sb.append(linkSymbol);
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String toString(Object array) {
        StringBuilder sb = new StringBuilder();
        if (array != null) {
            Class<?> type = array.getClass();
            if (type.isArray()) {
                sb.append("[");
                StringBuilder result = new StringBuilder();
                for (int i = 0; i < Array.getLength(array); ++i) {
                    Object a = Array.get(array, i);
                    if (a == null) {
                        result.append("null");
                    } else {
                        result.append(a);
                    }
                    result.append(",");
                }
                if (result.length() > 0) {
                    result.deleteCharAt(result.length() - 1);
                }
                sb.append(result.toString()).append("]");
            } else {
                sb.append(array.toString());
            }
        }
        return sb.toString();
    }

    @SafeVarargs
    public static <E> String toString(E ... objects) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        if (objects != null && objects.length > 0) {
            for (E object : objects) {
                if (object == null) {
                    sb.append("null");
                } else {
                    sb.append(object.toString());
                }
                sb.append(",");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static <T> List<T> toList(T ... arrays) {
        ArrayList<T> list = new ArrayList<T>();
        if (arrays != null) {
            for (T t : arrays) {
                list.add(t);
            }
        }
        return list;
    }

    public static <A> Map<Integer, A> toMap(A ... arrays) {
        if (arrays == null) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<Integer, A> map = new LinkedHashMap<Integer, A>(arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            map.put(i, arrays[i]);
        }
        return map;
    }

    @Deprecated
    public static <A> Map<String, A> toMap2(A ... arrays) {
        return ArrayUtils.toMapStringKey(arrays);
    }

    public static <A> Map<String, A> toMapStringKey(A ... arrays) {
        if (arrays == null) {
            return new LinkedHashMap(0);
        }
        LinkedHashMap<String, A> map = new LinkedHashMap<String, A>(arrays.length);
        for (int i = 0; i < arrays.length; ++i) {
            map.put(String.valueOf(i), arrays[i]);
        }
        return map;
    }

    public static <A extends Number> A[] toNumbers(Class<A> type, String ... array) {
        int len = 0;
        if (array != null) {
            len = array.length;
        }
        Number[] as = (Number[])ArrayUtils.create(type, len);
        ArrayUtils.each((T a, Integer i) -> {
            as[i.intValue()] = NumberUtils.parse(a, type);
        }, array);
        return as;
    }

    public static <T> void fill(T[] target, T[] source) {
        int len = target.length;
        if (len > source.length) {
            len = source.length;
        }
        for (int i = 0; i < len; ++i) {
            target[i] = source[i];
        }
    }

    public static <T> boolean contain(T[] tSet, T target) {
        if (tSet == null || target == null) {
            return false;
        }
        for (T t : tSet) {
            if (!target.equals(t)) continue;
            return true;
        }
        return false;
    }

    public static boolean contain(String[] strSet, String strTarget, boolean ignoreCase) {
        if (strSet == null || strTarget == null) {
            return false;
        }
        boolean result = false;
        for (String str : strSet) {
            if (ignoreCase) {
                if (!strTarget.equalsIgnoreCase(str)) continue;
                result = true;
                break;
            }
            if (!strTarget.equals(str)) continue;
            result = true;
            break;
        }
        return result;
    }

    @Deprecated
    public static boolean containString(String[] strSet, String strTarget, boolean ignoreCase) {
        return ArrayUtils.contain(strSet, strTarget, ignoreCase);
    }

    public static Object concat(Object arr1, Object arr2) {
        int len2;
        int len1;
        int n = len1 = arr1 != null ? Array.getLength(arr1) : -1;
        if (len1 <= 0) {
            return arr2;
        }
        int n2 = len2 = arr2 != null ? Array.getLength(arr2) : -1;
        if (len2 <= 0) {
            return arr1;
        }
        Class<?> commonComponentType = ClassUtils.parentClass(arr1.getClass().getComponentType(), arr2.getClass().getComponentType());
        Object newArray = Array.newInstance(commonComponentType, len1 + len2);
        System.arraycopy(arr1, 0, newArray, 0, len1);
        System.arraycopy(arr2, 0, newArray, len1, len2);
        return newArray;
    }

    public static <T> T[] create(Class<T> type, int length) {
        Object o = Array.newInstance(type, length);
        return (Object[])o;
    }

    public static void fillAll(char[] target, char[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static void fillAll(char[] target, int startIndex, char[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }

    public static void fillAll(byte[] target, byte[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static void fillAll(byte[] target, int startIndex, byte[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }

    public static void fillAll(int[] target, int[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static void fillAll(int[] target, int startIndex, int[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }

    public static void fillAll(long[] target, long[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static void fillAll(long[] target, int startIndex, long[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }

    public static void fillAll(double[] target, double[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static void fillAll(double[] target, int startIndex, double[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }

    public static <T> void fillAll(T[] target, T[] source) {
        ArrayUtils.fillAll(target, 0, source);
    }

    public static <T> void fillAll(T[] target, int startIndex, T[] source) {
        int len = target.length - startIndex < source.length ? target.length : source.length;
        for (int i = 0; i < len; ++i) {
            target[i + startIndex] = source[i];
        }
    }
}

